/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;

public class FontCache {
    private static final Logger LOGGER = Logging.getLogger(FontCache.class);
    static volatile FontCache defaultInstance;
    Set<String> systemFonts = new HashSet<String>();
    Map<String, Font> loadedFonts = new ConcurrentHashMap<String, Font>();

    public static FontCache getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new FontCache();
        }
        return defaultInstance;
    }

    public synchronized Font getFont(String requestedFont) {
        Font javaFont = null;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("trying to load " + requestedFont);
        }
        if (this.loadedFonts.containsKey(requestedFont)) {
            return this.loadedFonts.get(requestedFont);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("not already loaded");
        }
        if (this.getSystemFonts().contains(requestedFont)) {
            javaFont = new Font(requestedFont, 0, 12);
        } else {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("not a system font");
            }
            javaFont = this.loadFromUrl(requestedFont);
        }
        if (javaFont == null) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.fine("Could not load font " + requestedFont);
            }
        } else {
            this.loadedFonts.put(requestedFont, javaFont);
        }
        return javaFont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Font loadFromUrl(String fontUrl) {
        Serializable file;
        InputStream is;
        block31: {
            is = null;
            if (fontUrl.startsWith("http") || fontUrl.startsWith("file:")) {
                try {
                    URL url = new URL(fontUrl);
                    is = url.openStream();
                }
                catch (MalformedURLException mue) {
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.info("Bad url in SLDStyleFactory " + fontUrl + "\n" + mue);
                    }
                    break block31;
                }
                catch (IOException ioe) {
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.info("IO error in SLDStyleFactory " + fontUrl + "\n" + ioe);
                    }
                    break block31;
                }
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("not a URL");
            }
            if ((file = new File(fontUrl)).exists()) {
                try {
                    is = new FileInputStream((File)file);
                }
                catch (FileNotFoundException fne) {
                    if (!LOGGER.isLoggable(Level.INFO)) break block31;
                    LOGGER.info("Bad file name in SLDStyleFactory" + fontUrl + "\n" + fne);
                }
            }
        }
        if (is == null) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("null input stream, could not load the font");
            }
            return null;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("about to load");
        }
        try {
            file = Font.createFont(0, is);
            return file;
        }
        catch (FontFormatException ffe) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Font format error in FontCache " + fontUrl + "\n" + ffe);
            }
            Font font = null;
            return font;
        }
        catch (IOException ioe) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("IO error in FontCache " + fontUrl + "\n" + ioe);
            }
            Font font = null;
            return font;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOGGER.info("IO error in FontCache" + fontUrl + "\n" + e);
                }
            }
        }
    }

    public void registerFont(Font f) {
        this.loadedFonts.put(f.getName(), f);
    }

    public synchronized void resetCache() {
        if (this.systemFonts != null) {
            this.systemFonts.clear();
        }
        if (this.loadedFonts != null) {
            this.loadedFonts.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getSystemFonts() {
        if (this.systemFonts.size() == 0) {
            Set<String> set = this.systemFonts;
            synchronized (set) {
                if (this.systemFonts.size() == 0) {
                    Font[] fonts;
                    GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    HashSet<String> fontset = new HashSet<String>();
                    for (Font font : fonts = ge.getAllFonts()) {
                        fontset.add(font.getName());
                        fontset.add(font.getFamily());
                    }
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("there are " + fontset.size() + " fonts available");
                    }
                    this.systemFonts.addAll(fontset);
                }
            }
        }
        return this.systemFonts;
    }

    public Set<String> getAvailableFonts() {
        HashSet<String> availableFonts = new HashSet<String>();
        availableFonts.addAll(this.getSystemFonts());
        availableFonts.addAll(this.loadedFonts.keySet());
        return availableFonts;
    }
}

