/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.renderer.lite.GlyphPropertiesList;
import org.geotools.renderer.lite.GlyphRenderer;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Graphic;
import org.geotools.util.logging.Logging;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;

public class CustomGlyphRenderer
implements GlyphRenderer {
    static final Logger LOGGER = Logging.getLogger(CustomGlyphRenderer.class);
    private GlyphPropertiesList list = new GlyphPropertiesList();
    private int maxBarHeight = 0;

    public CustomGlyphRenderer() {
        FilterFactory2 factory = (FilterFactory2)CommonFactoryFinder.getFilterFactory(null);
        this.list.addProperty("radius", Expression.class, factory.literal(50));
        this.list.addProperty("circle color", Expression.class, factory.literal((Object)"#000066"));
        this.list.addProperty("bar height", Expression.class, factory.literal(150));
        this.list.addProperty("bar color", Expression.class, factory.literal((Object)"#000000"));
        this.list.addProperty("bar uncertainty", Expression.class, factory.literal(50));
        this.list.addProperty("bar uncertainty width", Expression.class, factory.literal(5));
        this.list.addProperty("bar uncertainty color", Expression.class, factory.literal((Object)"#999999"));
        this.list.addProperty("pointer length", Expression.class, factory.literal(100));
        this.list.addProperty("pointer color", Expression.class, factory.literal((Object)"#FF0000"));
        this.list.addProperty("pointer direction", Expression.class, factory.literal(21));
        this.list.addProperty("wedge width", Expression.class, factory.literal(25));
        this.list.addProperty("wedge color", Expression.class, factory.literal((Object)"#9999FF"));
    }

    @Override
    public boolean canRender(String format) {
        return format.equalsIgnoreCase("image/hack");
    }

    @Override
    public List getFormats() {
        Vector<String> ret = new Vector<String>();
        ret.add("image/hack");
        return ret;
    }

    public String getGlyphName() {
        return "exploded clock";
    }

    public GlyphPropertiesList getGlyphProperties() {
        return this.list;
    }

    public void setGlyphProperties(GlyphPropertiesList gpl) {
        this.list = gpl;
    }

    @Override
    public BufferedImage render(Graphic graphic, ExternalGraphic eg, Object feature, int height) {
        Map props = eg.getCustomProperties();
        Set propNames = props.keySet();
        for (String nextName : propNames) {
            if (this.list.hasProperty(nextName)) {
                this.list.setPropertyValue(nextName, props.get(nextName));
                continue;
            }
            LOGGER.log(Level.WARNING, "Tried to set the property " + nextName + " to a glyph that does not have this property.");
        }
        int radius = 50;
        Expression e = (Expression)this.list.getPropertyValue("radius");
        if (e != null) {
            radius = ((Number)e.evaluate(feature)).intValue();
        }
        Color circleColor = Color.BLUE.darker();
        e = (Expression)this.list.getPropertyValue("circle color");
        if (e != null) {
            circleColor = Color.decode((String)e.evaluate(feature));
        }
        int barHeight = 150;
        e = (Expression)this.list.getPropertyValue("bar height");
        if (e != null) {
            barHeight = ((Number)e.evaluate(feature)).intValue();
        }
        Color barColor = Color.BLACK;
        e = (Expression)this.list.getPropertyValue("bar color");
        if (e != null) {
            barColor = Color.decode((String)e.evaluate(feature));
        }
        int barUncertainty = 50;
        e = (Expression)this.list.getPropertyValue("bar uncertainty");
        if (e != null) {
            barUncertainty = ((Number)e.evaluate(feature)).intValue();
        }
        int barUncWidth = 5;
        e = (Expression)this.list.getPropertyValue("bar uncertainty width");
        if (e != null) {
            barUncWidth = ((Number)e.evaluate(feature)).intValue();
        }
        Color barUncColor = Color.GRAY;
        e = (Expression)this.list.getPropertyValue("bar uncertainty color");
        if (e != null) {
            barUncColor = Color.decode((String)e.evaluate(feature));
        }
        int pointerDirection = 21;
        e = (Expression)this.list.getPropertyValue("pointer direction");
        if (e != null) {
            pointerDirection = ((Number)e.evaluate(feature)).intValue();
        }
        Color pointerColor = Color.RED;
        e = (Expression)this.list.getPropertyValue("pointer color");
        if (e != null) {
            pointerColor = Color.decode((String)e.evaluate(feature));
        }
        int pointerLength = 100;
        e = (Expression)this.list.getPropertyValue("pointer length");
        if (e != null) {
            pointerLength = ((Number)e.evaluate(feature)).intValue();
        }
        int wedgeWidth = 25;
        e = (Expression)this.list.getPropertyValue("wedge width");
        if (e != null) {
            wedgeWidth = ((Number)e.evaluate(feature)).intValue();
        }
        Color wedgeColor = Color.BLUE;
        e = (Expression)this.list.getPropertyValue("wedge color");
        if (e != null) {
            wedgeColor = Color.decode((String)e.evaluate(feature));
        }
        Expression tempExp = (Expression)this.list.getPropertyValue("bar height");
        int temp1 = 0;
        if (tempExp != null) {
            temp1 = ((Number)tempExp.evaluate(feature)).intValue();
        }
        tempExp = (Expression)this.list.getPropertyValue("bar uncertainty");
        int temp2 = 0;
        if (tempExp != null) {
            temp2 = ((Number)tempExp.evaluate(feature)).intValue();
        }
        if (temp1 + temp2 > this.maxBarHeight) {
            this.maxBarHeight = temp1 + temp2;
        }
        int circleCenterX = Math.max(pointerLength, radius);
        int circleCenterY = Math.max(this.maxBarHeight, Math.max(pointerLength, radius));
        int imageHeight = Math.max(radius * 2, Math.max(radius + pointerLength, Math.max(radius + this.maxBarHeight, pointerLength + this.maxBarHeight)));
        int imageWidth = Math.max(radius * 2, pointerLength * 2);
        BufferedImage image = new BufferedImage(imageWidth, imageHeight, 2);
        pointerLength = Math.max(pointerLength, radius);
        Graphics2D imageGraphic = image.createGraphics();
        imageGraphic.setColor(circleColor);
        imageGraphic.fillOval(circleCenterX - radius, circleCenterY - radius, radius * 2, radius * 2);
        imageGraphic.setColor(wedgeColor);
        imageGraphic.fillArc(circleCenterX - radius, circleCenterY - radius, radius * 2, radius * 2, this.calculateWedgeAngle(pointerDirection, wedgeWidth), wedgeWidth * 2);
        imageGraphic.setColor(barUncColor);
        imageGraphic.fillRect(circleCenterX - barUncWidth, circleCenterY - barHeight - barUncertainty, barUncWidth * 2, barUncertainty * 2);
        int[] endPoint = this.calculateEndOfPointer(circleCenterX, circleCenterY, pointerLength, pointerDirection);
        imageGraphic.setStroke(new BasicStroke(3.0f));
        imageGraphic.setColor(pointerColor);
        imageGraphic.draw(new Line2D.Double(circleCenterX, circleCenterY, endPoint[0], endPoint[1]));
        imageGraphic.setStroke(new BasicStroke(3.0f));
        imageGraphic.setColor(barColor);
        imageGraphic.draw(new Line2D.Double(circleCenterX, circleCenterY, circleCenterX, circleCenterY - barHeight));
        imageGraphic.dispose();
        return image;
    }

    private int calculateWedgeAngle(int pointerDirection, int wedgeWidth) {
        return 450 - (pointerDirection + wedgeWidth);
    }

    private int[] calculateEndOfPointer(int circleCenterX, int circleCenterY, int pointerLength, int pointerDirection) {
        int x = circleCenterX + (int)Math.round((double)pointerLength * Math.cos(Math.toRadians(pointerDirection - 90)));
        int y = circleCenterY + (int)Math.round((double)pointerLength * Math.sin(Math.toRadians(pointerDirection - 90)));
        return new int[]{x, y};
    }
}

