/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import java.util.logging.Logger;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.measure.Measure;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.vector.VectorProcess;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.linearref.LengthIndexedLine;
import org.locationtech.jts.operation.distance.DistanceOp;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import si.uom.SI;
import systems.uom.common.USCustomary;

@DescribeProcess(title="Measure point in LRS", description="Computes the measure of a point along a feature (as feature with attribute lrs_measure). The point is measured along the nearest feature.")
public class LRSMeasureProcess
implements VectorProcess {
    private static final Logger LOGGER = Logging.getLogger(LRSMeasureProcess.class);
    private final GeometryFactory geometryFactory = new GeometryFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DescribeResult(name="result", description="Output feature collection")
    public FeatureCollection execute(@DescribeParameter(name="features", description="Input feature collection") FeatureCollection featureCollection, @DescribeParameter(name="from_measure_attb", description="Attribute providing start measure of feature") String fromMeasureAttb, @DescribeParameter(name="to_measure_attb", description="Attribute providing end measure of feature") String toMeasureAttb, @DescribeParameter(name="point", description="Point whose location to measure") Point point, @DescribeParameter(name="crs", min=0, description="Coordinate reference system to use for input (default is the input collection CRS)") CoordinateReferenceSystem crs) throws ProcessException {
        DefaultFeatureCollection results = new DefaultFeatureCollection();
        try {
            CoordinateReferenceSystem epsg4326;
            GeometryDescriptor gd;
            if (featureCollection == null || featureCollection.size() == 0) {
                LOGGER.info("No features provided in request");
                return results;
            }
            if (crs == null && (gd = featureCollection.getSchema().getGeometryDescriptor()) != null) {
                crs = gd.getCoordinateReferenceSystem();
            }
            if (crs == null) {
                throw new ProcessException("The CRS parameter was not provided and the feature collection does not have a default one either");
            }
            if (fromMeasureAttb == null || featureCollection.getSchema().getDescriptor(fromMeasureAttb) == null) {
                throw new ProcessException("The from_measure_attb parameter was not provided or not defined in schema");
            }
            if (toMeasureAttb == null || featureCollection.getSchema().getDescriptor(toMeasureAttb) == null) {
                throw new ProcessException("The to_measure_attb parameter was not provided");
            }
            if (point == null) {
                throw new ProcessException("The point parameter was not provided");
            }
            try {
                epsg4326 = CRS.decode((String)"EPSG:4326");
            }
            catch (Exception e) {
                throw new ProcessException("Unknown CRS code: EPSG:4326", (Throwable)e);
            }
            MathTransform crsTransform = CRS.findMathTransform((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)epsg4326);
            SimpleFeatureType targetFeatureType = this.createTargetFeatureType(featureCollection.getSchema());
            Unit fromUnit = SI.METRE;
            Unit toUnit = USCustomary.MILE;
            UnitConverter unitConvert = fromUnit.getConverterTo(toUnit);
            SimpleFeature nearestFeature = null;
            double nearestDistance = 9.0E9;
            Coordinate[] nearestCoords = null;
            try (FeatureIterator featureIterator = null;){
                featureIterator = featureCollection.features();
                while (featureIterator.hasNext()) {
                    SimpleFeature f = (SimpleFeature)featureIterator.next();
                    if (f.getDefaultGeometryProperty().getValue() == null) continue;
                    DistanceOp op = new DistanceOp((Geometry)point, (Geometry)f.getDefaultGeometryProperty().getValue());
                    Coordinate[] co = op.closestPoints();
                    double[] co0 = new double[]{co[0].x, co[0].y};
                    double[] co1 = new double[]{co[1].x, co[1].y};
                    double[] geo0 = new double[2];
                    double[] geo1 = new double[2];
                    crsTransform.transform(co0, 0, geo0, 0, 1);
                    crsTransform.transform(co1, 0, geo1, 0, 1);
                    Measure m = DefaultGeographicCRS.WGS84.distance(geo0, geo1);
                    if (m.doubleValue() > nearestDistance) continue;
                    nearestFeature = f;
                    nearestDistance = m.doubleValue();
                    nearestCoords = co;
                }
            }
            if (nearestFeature != null) {
                LengthIndexedLine lengthIndexedLine = new LengthIndexedLine((Geometry)nearestFeature.getDefaultGeometryProperty().getValue());
                double lineIndex = lengthIndexedLine.indexOf((Coordinate)nearestCoords[1]);
                double lineLength = ((Geometry)nearestFeature.getDefaultGeometryProperty().getValue()).getLength();
                Double featureFromMeasure = (Double)nearestFeature.getProperty(fromMeasureAttb).getValue();
                Double featureToMeasure = (Double)nearestFeature.getProperty(toMeasureAttb).getValue();
                double lrsMeasure = featureFromMeasure + (featureToMeasure - featureFromMeasure) * lineIndex / lineLength;
                nearestFeature.getDefaultGeometryProperty().setValue((Object)this.geometryFactory.createPoint(new Coordinate(nearestCoords[1].x, nearestCoords[1].y)));
                results.add(this.createTargetFeature((Feature)nearestFeature, targetFeatureType, lrsMeasure));
                return results;
            }
            return results;
        }
        catch (ProcessException e) {
            throw e;
        }
        catch (Throwable e) {
            LOGGER.warning("Error executing method: " + e);
            throw new ProcessException("Error executing method: " + e, e);
        }
    }

    private SimpleFeatureType createTargetFeatureType(FeatureType sourceFeatureType) throws ProcessException {
        try {
            SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
            typeBuilder.setName(sourceFeatureType.getName().getLocalPart());
            typeBuilder.setNamespaceURI(sourceFeatureType.getName().getNamespaceURI());
            for (PropertyDescriptor attbType : sourceFeatureType.getDescriptors()) {
                typeBuilder.add((AttributeDescriptor)attbType);
            }
            typeBuilder.minOccurs(1).maxOccurs(1).nillable(false).add("lrs_measure", Double.class);
            typeBuilder.setDefaultGeometry(sourceFeatureType.getGeometryDescriptor().getLocalName());
            return typeBuilder.buildFeatureType();
        }
        catch (Exception e) {
            LOGGER.warning("Error creating type: " + e);
            throw new ProcessException("Error creating type: " + e, (Throwable)e);
        }
    }

    private SimpleFeature createTargetFeature(Feature feature, SimpleFeatureType targetFeatureType, Double lrsMeasure) throws ProcessException {
        try {
            AttributeDescriptor lrsMeasureAttbType = targetFeatureType.getDescriptor("lrs_measure");
            Object[] attributes = new Object[targetFeatureType.getAttributeCount()];
            for (int i = 0; i < attributes.length; ++i) {
                AttributeDescriptor attbType = (AttributeDescriptor)targetFeatureType.getAttributeDescriptors().get(i);
                attributes[i] = attbType.equals(lrsMeasureAttbType) ? lrsMeasure : feature.getProperty(attbType.getName()).getValue();
            }
            return SimpleFeatureBuilder.build((SimpleFeatureType)targetFeatureType, (Object[])attributes, (String)feature.getIdentifier().getID());
        }
        catch (Exception e) {
            LOGGER.warning("Error creating feature: " + e);
            throw new ProcessException("Error creating feature: " + e, (Throwable)e);
        }
    }

    private double calcBearing(Coordinate[] coords) {
        double y = Math.sin(coords[1].x - coords[0].x) * Math.cos(coords[1].y);
        double x = Math.cos(coords[0].y) * Math.sin(coords[1].y) - Math.sin(coords[0].y) * Math.cos(coords[1].y) * Math.cos(coords[1].x - coords[0].x);
        double brng = (Math.atan2(y, x) * 180.0 / Math.PI + 360.0) % 360.0;
        return brng;
    }
}

