/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.function.EqualIntervalFunction;
import org.geotools.filter.function.JenksNaturalBreaksFunction;
import org.geotools.filter.function.QuantileFunction;
import org.geotools.filter.function.RangedClassifier;
import org.geotools.process.ProcessException;
import org.geotools.process.classify.ClassificationMethod;
import org.geotools.process.classify.ClassificationStats;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.vector.VectorProcess;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.jaitools.numeric.Range;
import org.jaitools.numeric.Statistic;
import org.jaitools.numeric.StreamingSampleStats;
import org.opengis.feature.Feature;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.FilterFactory;
import org.opengis.util.ProgressListener;

@DescribeProcess(title="featureClassStats", description="Calculates statistics from feature values classified into bins/classes.")
public class FeatureClassStats
implements VectorProcess {
    static Logger LOG = Logging.getLogger(FeatureClassStats.class);
    static FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DescribeResult(name="results", description="The classified results")
    public Results execute(@DescribeParameter(name="features", description="The feature collection to analyze") FeatureCollection features, @DescribeParameter(name="attribute", description="The feature attribute to analyze") String attribute, @DescribeParameter(name="stats", description="The statistics to calculate for each class", collectionType=Statistic.class) Set<Statistic> stats, @DescribeParameter(name="classes", description="The number of breaks/classes", min=0) Integer classes, @DescribeParameter(name="method", description="The classification method", min=0) ClassificationMethod method, @DescribeParameter(name="noData", description="The attribute value to be omitted from any calculation", min=0) Double noData, ProgressListener progressListener) throws ProcessException, IOException {
        if (features == null) {
            throw new ProcessException(Errors.format((int)143, (Object)"features"));
        }
        if (attribute == null) {
            throw new ProcessException(Errors.format((int)143, (Object)"attribute"));
        }
        PropertyDescriptor property = features.getSchema().getDescriptor(attribute);
        if (property == null) {
            throw new ProcessException("No such feature attribute '" + attribute + "'");
        }
        if (!Number.class.isAssignableFrom(property.getType().getBinding())) {
            throw new ProcessException("Feature attribute '" + attribute + "' is not numeric");
        }
        if (classes == null) {
            classes = 10;
        }
        if (classes < 1) {
            throw new ProcessException(Errors.format((int)58, (Object)"classes", (Object)classes));
        }
        if (method == null) {
            method = ClassificationMethod.EQUAL_INTERVAL;
        }
        if (stats == null || stats.isEmpty()) {
            stats = Collections.singleton(Statistic.MEAN);
        }
        EqualIntervalFunction cf = null;
        switch (method) {
            case EQUAL_INTERVAL: {
                cf = new EqualIntervalFunction();
                break;
            }
            case QUANTILE: {
                cf = new QuantileFunction();
                break;
            }
            case NATURAL_BREAKS: {
                cf = new JenksNaturalBreaksFunction();
                break;
            }
            default: {
                throw new ProcessException("Unknown method: " + method);
            }
        }
        cf.setParameters(Arrays.asList(filterFactory.property(attribute), filterFactory.literal((Object)classes)));
        RangedClassifier rc = (RangedClassifier)cf.evaluate((Object)features);
        ArrayList<Range<Double>> ranges = new ArrayList<Range<Double>>();
        StreamingSampleStats[] sampleStats = new StreamingSampleStats[rc.getSize()];
        for (int i = 0; i < rc.getSize(); ++i) {
            ranges.add((Range<Double>)Range.create((Number)((Double)rc.getMin(i)), (boolean)true, (Number)((Double)rc.getMax(i)), (i == rc.getSize() - 1 ? 1 : 0) != 0));
            StreamingSampleStats s = new StreamingSampleStats(Range.Type.INCLUDE);
            s.setStatistics(stats.toArray(new Statistic[stats.size()]));
            if (noData != null) {
                s.addNoDataValue(noData);
            }
            sampleStats[i] = s;
        }
        try (FeatureIterator it = features.features();){
            while (it.hasNext()) {
                Feature f = it.next();
                Object val = f.getProperty(attribute).getValue();
                if (val == null) continue;
                Double dubVal = (Double)Converters.convert((Object)val, Double.class);
                if (dubVal == null) {
                    LOG.warning(String.format("Unable to convert value %s (attribute '%s') to Double, skipping", val, attribute));
                    continue;
                }
                int slot = rc.classify((Object)dubVal);
                sampleStats[slot].offer(dubVal);
            }
        }
        return new Results(ranges, sampleStats);
    }

    public static class Results
    implements ClassificationStats {
        List<Range<Double>> ranges;
        StreamingSampleStats[] sampleStats;
        Statistic firstStat;

        public Results(List<Range<Double>> ranges, StreamingSampleStats[] sampleStats) {
            this.ranges = ranges;
            this.sampleStats = sampleStats;
            this.firstStat = (Statistic)sampleStats[0].getStatistics().iterator().next();
        }

        public int size() {
            return this.ranges.size();
        }

        public Set<Statistic> getStats() {
            return this.sampleStats[0].getStatistics();
        }

        public Range range(int i) {
            return this.ranges.get(i);
        }

        public Double value(int i, Statistic stat) {
            return this.sampleStats[i].getStatisticValue(stat);
        }

        public Long count(int i) {
            return this.sampleStats[i].getNumAccepted(this.firstStat);
        }

        public void print() {
            for (int i = 0; i < this.size(); ++i) {
                System.out.println(this.range(i));
                for (Statistic stat : this.sampleStats[0].getStatistics()) {
                    System.out.println(stat + " = " + this.value(i, stat));
                }
            }
        }
    }
}

