/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import java.util.NoSuchElementException;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.vector.SimpleProcessingCollection;
import org.geotools.process.vector.VectorProcess;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

@DescribeProcess(title="Centroid", description="Computes the geometric centroids of features")
public class CentroidProcess
implements VectorProcess {
    @DescribeResult(name="result", description="Centroids of input features")
    public SimpleFeatureCollection execute(@DescribeParameter(name="features", description="Input feature collection") SimpleFeatureCollection features) throws ProcessException {
        return DataUtilities.simple((FeatureCollection)new CentroidFeatureCollection(features));
    }

    static class CentroidFeatureIterator
    implements SimpleFeatureIterator {
        SimpleFeatureIterator delegate;
        SimpleFeatureBuilder fb;

        public CentroidFeatureIterator(SimpleFeatureIterator delegate, SimpleFeatureType schema) {
            this.delegate = delegate;
            this.fb = new SimpleFeatureBuilder(schema);
        }

        public void close() {
            this.delegate.close();
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public SimpleFeature next() throws NoSuchElementException {
            SimpleFeature f = (SimpleFeature)this.delegate.next();
            for (Object attribute : f.getAttributes()) {
                if (attribute instanceof Geometry && !(attribute instanceof Point)) {
                    attribute = ((Geometry)attribute).getCentroid();
                }
                this.fb.add(attribute);
            }
            return this.fb.buildFeature(f.getID());
        }
    }

    static class CentroidFeatureCollection
    extends SimpleProcessingCollection {
        SimpleFeatureCollection delegate;

        public CentroidFeatureCollection(SimpleFeatureCollection delegate) {
            this.delegate = delegate;
        }

        public SimpleFeatureIterator features() {
            return new CentroidFeatureIterator(this.delegate.features(), (SimpleFeatureType)this.getSchema());
        }

        @Override
        public ReferencedEnvelope getBounds() {
            return DataUtilities.bounds((FeatureIterator)this.features());
        }

        @Override
        protected SimpleFeatureType buildTargetFeatureType() {
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            for (AttributeDescriptor ad : ((SimpleFeatureType)this.delegate.getSchema()).getAttributeDescriptors()) {
                if (ad instanceof GeometryDescriptor) {
                    GeometryDescriptor gd = (GeometryDescriptor)ad;
                    Class binding = ad.getType().getBinding();
                    if (Point.class.isAssignableFrom(binding)) {
                        tb.add(ad);
                        continue;
                    }
                    tb.minOccurs(ad.getMinOccurs());
                    tb.maxOccurs(ad.getMaxOccurs());
                    tb.nillable(ad.isNillable());
                    tb.add(ad.getLocalName(), Point.class, gd.getCoordinateReferenceSystem());
                    continue;
                }
                tb.add(ad);
            }
            tb.setName(((SimpleFeatureType)this.delegate.getSchema()).getName());
            return tb.buildFeatureType();
        }

        @Override
        public int size() {
            return this.delegate.size();
        }
    }
}

