/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 *
 *    (C) 2011, Open Source Geospatial Foundation (OSGeo)
 *    (C) 2004-2005, Open Geospatial Consortium Inc.
 *
 *    All Rights Reserved. http://www.opengis.org/legal/
 */
package org.opengis.metadata.quality;

import static org.opengis.annotation.Specification.*;

import org.opengis.annotation.UML;

/**
 * Closeness of the relative positions of features in the scope to their respective relative
 * positions accepted as or being true.
 *
 * @version <A HREF="http://www.opengeospatial.org/standards/as#01-111">ISO 19115</A>
 * @author Martin Desruisseaux (IRD)
 * @since GeoAPI 2.0
 */
@UML(identifier = "DQ_RelativeInternalPositionalAccuracy", specification = ISO_19115)
public interface RelativeInternalPositionalAccuracy extends PositionalAccuracy {}
