/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.util.ArrayList;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.BSONObject;
import org.bson.types.BasicBSONList;
import org.bson.types.ObjectId;
import org.geotools.data.mongodb.MongoLayer;
import org.geotools.data.mongodb.MongoPluginConfig;
import org.geotools.data.mongodb.MongoPluginException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class MongoResultSet {
    private MongoLayer layer = null;
    private ArrayList<SimpleFeature> features = null;
    private ReferencedEnvelope bounds = null;
    double minX = 180.0;
    double maxX = -180.0;
    double minY = 90.0;
    double maxY = -90.0;
    private static final Logger log = MongoPluginConfig.getLog();
    private static final PrecisionModel pm = new PrecisionModel();
    private static final GeometryFactory geoFactory = new GeometryFactory(pm, -1);

    public MongoResultSet(MongoLayer layer, BasicDBObject query) {
        this.layer = layer;
        this.bounds = new ReferencedEnvelope(0.0, 0.0, 0.0, 0.0, layer.getCRS());
        this.features = new ArrayList();
        if (query != null) {
            this.buildFeatures(query);
        }
    }

    private void buildFeatures(BasicDBObject query) {
        if (this.layer == null) {
            log.warning("buildFeatures called, but layer is null");
            return;
        }
        Mongo mongo = null;
        try {
            if (this.layer.getGeometryType() == null) {
                return;
            }
            mongo = new Mongo(this.layer.getConfig().getHost(), this.layer.getConfig().getPort());
            DB db = mongo.getDB(this.layer.getConfig().getDB());
            DBCollection coll = db.getCollection(this.layer.getName());
            DBCursor cur = coll.find((DBObject)query);
            this.minX = 180.0;
            this.maxX = -180.0;
            this.minY = 90.0;
            this.maxY = -90.0;
            SimpleFeatureBuilder fb = new SimpleFeatureBuilder(this.layer.getSchema());
            log.finer("cur.count()=" + cur.count());
            while (cur.hasNext()) {
                DBObject geo;
                DBObject dbo = cur.next();
                if (dbo == null) continue;
                if (dbo.get("_id") instanceof ObjectId) {
                    ObjectId oid = (ObjectId)dbo.get("_id");
                    fb.set("_id", (Object)oid.toString());
                } else if (dbo.get("_id") instanceof String) {
                    fb.set("_id", dbo.get("_id"));
                } else {
                    throw new MongoPluginException("_id is invalid type: " + dbo.get("_id").getClass());
                }
                if ((geo = (DBObject)dbo.get("geometry")) == null || geo.get("type") == null || geo.get("coordinates") == null && geo.get("geometries") == null) continue;
                MongoLayer.GeometryType recordGeoType = MongoLayer.GeometryType.valueOf((String)geo.get("type"));
                if (!this.layer.getGeometryType().equals((Object)recordGeoType)) continue;
                Geometry recordGeometry = this.createGeometry(recordGeoType, geo);
                if (recordGeometry != null) {
                    fb.set("geometry", (Object)recordGeometry);
                    DBObject props = (DBObject)dbo.get("properties");
                    this.setProperties(fb, "properties", (BSONObject)props);
                    this.features.add(fb.buildFeature(null));
                    this.bounds = new ReferencedEnvelope(this.minX, this.maxX, this.minY, this.maxY, this.layer.getCRS());
                    continue;
                }
                fb.reset();
            }
        }
        catch (Throwable t) {
            log.severe("Error building layer " + this.layer.getName() + "; " + t.getLocalizedMessage());
        }
        if (mongo != null) {
            mongo.close();
        }
    }

    private void setProperties(SimpleFeatureBuilder fb, String base, BSONObject dbo) {
        Set cols = dbo.keySet();
        for (String col : cols) {
            Object dbcol = dbo.get(col);
            if (dbcol instanceof BasicDBObject || dbcol instanceof BasicBSONList) {
                this.setProperties(fb, base + "." + col, (BSONObject)dbcol);
                continue;
            }
            Class featureBinding = fb.getFeatureType().getType(base + "." + col).getBinding();
            Class<?> dboBinding = dbo.get(col).getClass();
            if (dboBinding.equals(featureBinding)) {
                fb.set(base + "." + col, dbo.get(col));
                continue;
            }
            if (!featureBinding.equals(String.class) && (!featureBinding.getSuperclass().equals(Number.class) || !dboBinding.getSuperclass().equals(Number.class))) continue;
            try {
                fb.set(base + "." + col, (Object)dbo.get(col).toString());
            }
            catch (NumberFormatException ne) {}
        }
    }

    public SimpleFeatureType getSchema() {
        return this.layer.getSchema();
    }

    public SimpleFeature getFeature(int idx) throws IndexOutOfBoundsException {
        if (idx < 0 || idx >= this.features.size()) {
            throw new IndexOutOfBoundsException("Index " + idx + " exceeds features size of " + this.features.size());
        }
        return this.features.get(idx);
    }

    public int getCount() {
        return this.features.size();
    }

    public ReferencedEnvelope getBounds() {
        return this.bounds;
    }

    public void paginateFeatures(int startIndex, int maxFeatures) {
        int endIndex = startIndex + maxFeatures;
        if (startIndex >= 0 && maxFeatures > 0 && endIndex < this.features.size()) {
            this.features = new ArrayList<SimpleFeature>(this.features.subList(startIndex, endIndex));
        }
    }

    private Coordinate createCoordinate(BasicDBList coords) {
        double x = 0.0;
        double y = 0.0;
        boolean success = true;
        Coordinate coord = null;
        try {
            x = Double.parseDouble(coords.get(0).toString());
            y = Double.parseDouble(coords.get(1).toString());
            if (x < -180.0 || x > 180.0) {
                success = false;
            }
            if (y < -90.0 || y > 90.0) {
                success = false;
            }
            if (success) {
                if (x < this.minX) {
                    this.minX = x;
                }
                if (x > this.maxX) {
                    this.maxX = x;
                }
                if (y < this.minY) {
                    this.minY = y;
                }
                if (y > this.maxY) {
                    this.maxY = y;
                }
            }
            coord = new Coordinate(x, y);
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, t.getLocalizedMessage(), t);
            coord = null;
        }
        return coord;
    }

    private Point createPoint(BasicDBList coords) {
        Coordinate coord = this.createCoordinate(coords);
        Point pt = null;
        if (coord != null) {
            pt = geoFactory.createPoint(coord);
        }
        return pt;
    }

    private Polygon createPolygon(BasicDBList polyCoords) {
        Vector rings = new Vector();
        boolean success = true;
        for (Object polys : polyCoords) {
            BasicDBList inner = (BasicDBList)polys;
            ArrayList<Coordinate> ring = new ArrayList<Coordinate>();
            for (Object obj : inner) {
                BasicDBList aPoint = (BasicDBList)obj;
                Coordinate coord = this.createCoordinate(aPoint);
                ring.add(coord);
            }
            rings.add(ring);
        }
        Polygon poly = null;
        if (success && rings.size() > 0) {
            Coordinate[] shellCoords = new Coordinate[((ArrayList)rings.get(0)).size()];
            shellCoords = ((ArrayList)rings.get(0)).toArray(shellCoords);
            LinearRing shell = geoFactory.createLinearRing(shellCoords);
            LinearRing[] holes = null;
            if (rings.size() > 1) {
                holes = new LinearRing[rings.size() - 1];
                for (int i = 1; i < rings.size(); ++i) {
                    Coordinate[] holeCoords = new Coordinate[((ArrayList)rings.get(i)).size()];
                    holeCoords = ((ArrayList)rings.get(i)).toArray(holeCoords);
                    holes[i - 1] = geoFactory.createLinearRing(holeCoords);
                }
            }
            poly = geoFactory.createPolygon(shell, holes);
        }
        return poly;
    }

    private LineString createLineString(BasicDBList outer) {
        Coordinate[] coords = new Coordinate[outer.size()];
        int i = 0;
        for (Object lineCoords : outer) {
            coords[i++] = this.createCoordinate((BasicDBList)lineCoords);
        }
        LineString lineString = geoFactory.createLineString(coords);
        return lineString;
    }

    private Geometry createGeometry(MongoLayer.GeometryType type, DBObject coordinates) {
        LineString geometryObj = null;
        if (type.equals((Object)MongoLayer.GeometryType.GeometryCollection)) {
            if (!coordinates.containsField("geometries")) {
                log.warning("No geometries detected for GeometryCollection, skipping.");
                return geometryObj;
            }
            BasicDBList geometryList = (BasicDBList)coordinates.get("geometries");
            int i = 0;
            Geometry[] geometries = new Geometry[geometryList.size()];
            for (Object geoElement : geometryList) {
                String subType = (String)((BasicDBList)geoElement).get("type");
                MongoLayer.GeometryType geoType = MongoLayer.GeometryType.valueOf(subType);
                geometries[i++] = this.createGeometry(geoType, (DBObject)geoElement);
            }
            geometryObj = geoFactory.createGeometryCollection(geometries);
        } else {
            if (!coordinates.containsField("coordinates")) {
                return geoFactory.createPoint((Coordinate)null);
            }
            BasicDBList coords = (BasicDBList)coordinates.get("coordinates");
            int i = 0;
            switch (type) {
                case LineString: {
                    geometryObj = this.createLineString(coords);
                    break;
                }
                case Point: {
                    geometryObj = this.createPoint(coords);
                    break;
                }
                case Polygon: {
                    geometryObj = this.createPolygon(coords);
                    break;
                }
                case MultiLineString: {
                    LineString[] lines = new LineString[coords.size()];
                    for (Object lineCoords : coords) {
                        lines[i++] = this.createLineString((BasicDBList)lineCoords);
                    }
                    geometryObj = geoFactory.createMultiLineString(lines);
                    break;
                }
                case MultiPoint: {
                    Point[] points = new Point[coords.size()];
                    for (Object obj : coords) {
                        BasicDBList aPoint = (BasicDBList)obj;
                        points[i++] = this.createPoint(aPoint);
                    }
                    geometryObj = geoFactory.createMultiPoint(points);
                    break;
                }
                case MultiPolygon: {
                    Polygon[] polys = new Polygon[coords.size()];
                    for (Object polyCoords : coords) {
                        polys[i++] = this.createPolygon((BasicDBList)polyCoords);
                    }
                    geometryObj = geoFactory.createMultiPolygon(polys);
                }
            }
        }
        return geometryObj;
    }
}

