/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import java.net.URI;
import java.util.Set;
import org.geotools.data.ResourceInfo;
import org.geotools.data.mongodb.MongoFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MongoResourceInfo
implements ResourceInfo {
    private MongoFeatureSource myFS;
    private URI myURI;

    public MongoResourceInfo(MongoFeatureSource fs) {
        this.myFS = fs;
        this.myURI = URI.create(this.myFS.getLayer().getSchema().getName().getNamespaceURI());
    }

    public CoordinateReferenceSystem getCRS() {
        return this.myFS.getLayer().getCRS();
    }

    public ReferencedEnvelope getBounds() {
        return this.myFS.getBounds();
    }

    public URI getSchema() {
        return this.myURI;
    }

    public String getName() {
        return this.myFS.getLayer().getName();
    }

    public String getDescription() {
        return "MongoDB Resource";
    }

    public Set<String> getKeywords() {
        return this.myFS.getLayer().getKeywords();
    }

    public String getTitle() {
        return this.myFS.getLayer().getSchema().getDescription().toString();
    }
}

