/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.mongodb.MongoPluginException;
import org.geotools.util.logging.Logging;

public class MongoPluginConfig {
    private static final String MONGO_HOST_PARAM = "mongo_host";
    private static final String MONGO_PORT_PARAM = "mongo_port";
    private static final String MONGO_DB_NAME_PARAM = "mongo_db_name";
    private static final String NAMESPACE_PARAM = "namespace";
    private static final String MONGO_DB_USERNAME = "username";
    private static final String MONGO_DB_PASSWORD = "password";
    private String mongoHost;
    private int mongoPort;
    private String mongoDB;
    private String namespace;
    private static final Logger log = Logging.getLogger((String)"org.geotools.data.mongodb");
    private static List<DataAccessFactory.Param> mongoParams = null;

    public static List<DataAccessFactory.Param> getPluginParams() {
        if (mongoParams == null) {
            mongoParams = new ArrayList<DataAccessFactory.Param>();
            mongoParams.add(new DataAccessFactory.Param(NAMESPACE_PARAM, String.class, "Namespace associated with this data store", false));
            mongoParams.add(new DataAccessFactory.Param(MONGO_HOST_PARAM, String.class, "MongoDB Server", true, (Object)"localhost"));
            mongoParams.add(new DataAccessFactory.Param(MONGO_PORT_PARAM, Integer.class, "MongoDB Port", true, (Object)27017));
            mongoParams.add(new DataAccessFactory.Param(MONGO_DB_NAME_PARAM, String.class, "MongoDB Database", true, (Object)"db"));
        }
        return mongoParams;
    }

    public MongoPluginConfig(Map<String, Serializable> params) throws MongoPluginException {
        String msg = "Mongo Plugin Configuration Error";
        try {
            String param = params.get(NAMESPACE_PARAM).toString();
            if (param == null) {
                msg = "Mongo Plugin: Missing namespace param";
                throw new Exception();
            }
            this.namespace = param;
            param = params.get(MONGO_HOST_PARAM).toString();
            if (param == null) {
                msg = "Mongo Plugin: Missing server name param";
                throw new Exception();
            }
            this.mongoHost = param;
            param = params.get(MONGO_PORT_PARAM).toString();
            if (param == null) {
                msg = "Mongo Plugin: Missing port param";
                throw new Exception();
            }
            msg = "Mongo Plugin: Error parsing port param";
            this.mongoPort = Integer.parseInt(param);
            param = params.get(MONGO_DB_NAME_PARAM).toString();
            if (param == null) {
                msg = "Mongo Plugin: Missing database name param";
                throw new Exception();
            }
            this.mongoDB = param;
        }
        catch (Throwable t) {
            throw new MongoPluginException(msg);
        }
    }

    public String getHost() {
        return this.mongoHost;
    }

    public int getPort() {
        return this.mongoPort;
    }

    public String getDB() {
        return this.mongoDB;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public static Logger getLog() {
        return log;
    }
}

