/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.types.BasicBSONList;
import org.geotools.data.mongodb.MongoPluginConfig;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MongoLayer {
    private MongoPluginConfig config = null;
    private String layerName = null;
    private SimpleFeatureType schema = null;
    private Set<String> keywords = null;
    private CoordinateReferenceSystem crs = null;
    private DBObject metaData = null;
    private GeometryType geometryType = null;
    private RecordBuilder buildRule = RecordBuilder.MAJORITY;
    private String metaMapFunc = "function() { mapfields_recursive (\"\", this);}";
    private String metaReduceFunc = "function (key, vals) {  sum = 0;  for (var i in vals) sum += vals[i];  return sum;}";
    private String metaResultsColl = "FieldsAndTypes";
    private static HashMap<String, String> classNameMap = new HashMap();
    private static final Logger log;

    public MongoLayer(DBCollection coll, MongoPluginConfig config) {
        this.config = config;
        this.layerName = coll.getName();
        log.fine("MongoLayer; layerName " + this.layerName);
        this.keywords = new HashSet<String>();
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(this.layerName);
        builder.setNamespaceURI(config.getNamespace());
        AttributeTypeBuilder b = new AttributeTypeBuilder();
        b.setBinding(String.class);
        b.setName("_id");
        b.setNillable(false);
        b.setDefaultValue(null);
        b.setLength(1024);
        AttributeDescriptor a = b.buildDescriptor("_id");
        builder.add(a);
        try {
            this.crs = CRS.decode((String)"EPSG:4326");
        }
        catch (Throwable t) {
            this.crs = DefaultGeographicCRS.WGS84;
        }
        b = new AttributeTypeBuilder();
        b.setName("geometry");
        b.setNillable(false);
        b.setDefaultValue(null);
        b.setCRS(this.crs);
        this.metaData = this.getCollectionModel(coll, this.buildRule);
        this.setGeometryType(this.metaData);
        switch (this.geometryType) {
            case GeometryCollection: {
                b.setBinding(GeometryCollection.class);
                break;
            }
            case LineString: {
                b.setBinding(LineString.class);
                break;
            }
            case Point: {
                b.setBinding(Point.class);
                break;
            }
            case Polygon: {
                b.setBinding(Polygon.class);
                break;
            }
            case MultiLineString: {
                b.setBinding(MultiLineString.class);
                break;
            }
            case MultiPoint: {
                b.setBinding(MultiPoint.class);
                break;
            }
            case MultiPolygon: {
                b.setBinding(MultiPolygon.class);
                break;
            }
            case Unknown: {
                log.warning("Unknown geometry for layer " + this.layerName + " (but has valid distinct geometry.type)");
                return;
            }
        }
        a = b.buildDescriptor("geometry");
        builder.add(a);
        this.keywords.add("_id");
        this.keywords.add("geometry");
        DBObject props = (DBObject)this.metaData.get("properties");
        this.addAttributes(builder, (BSONObject)props, "properties");
        this.schema = builder.buildFeatureType();
    }

    private void addAttributes(SimpleFeatureTypeBuilder builder, BSONObject dbo, String baseProp) {
        Set cols = dbo.keySet();
        for (String col : cols) {
            Object dbcol = dbo.get(col);
            String propName = baseProp + "." + col;
            this.keywords.add(propName);
            if (dbcol == null) continue;
            AttributeTypeBuilder b = new AttributeTypeBuilder();
            b.setName(propName);
            b.setBinding(dbcol.getClass());
            b.setNillable(true);
            b.setDefaultValue(null);
            b.setLength(1024);
            AttributeDescriptor a = b.buildDescriptor(propName);
            builder.add(a);
            if (!(dbcol instanceof BasicDBObject) && !(dbcol instanceof BasicBSONList)) continue;
            this.addAttributes(builder, (BSONObject)dbcol, propName);
        }
    }

    public String getName() {
        return this.layerName;
    }

    public SimpleFeatureType getSchema() {
        return this.schema;
    }

    public Set<String> getKeywords() {
        return this.keywords;
    }

    public CoordinateReferenceSystem getCRS() {
        return this.crs;
    }

    public MongoPluginConfig getConfig() {
        return this.config;
    }

    public GeometryType getGeometryType() {
        return this.geometryType;
    }

    private DBObject getCollectionModel(DBCollection coll, RecordBuilder buildRule) {
        coll.mapReduce(this.metaMapFunc, this.metaReduceFunc, this.metaResultsColl, (DBObject)new BasicDBObject());
        DBCollection metaColl = coll.getDB().getCollection(this.metaResultsColl);
        HashMap<String, ClassCount> fieldMap = this.getFieldMap(metaColl);
        log.finest("fieldMap=" + fieldMap);
        HashMap<String, String> finalMap = this.finalizeMajorityRule(fieldMap, buildRule);
        log.finest("finalMap=" + finalMap);
        DBObject metaData = this.convertMapToJson(finalMap);
        log.finest("metaData=" + metaData);
        return metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, ClassCount> getFieldMap(DBCollection metaResultsColl) {
        BasicDBObject query = new BasicDBObject();
        DBCursor cursor = metaResultsColl.find((DBObject)query);
        cursor.addOption(16);
        HashMap<String, ClassCount> fieldMap = new HashMap<String, ClassCount>();
        try {
            while (cursor.hasNext()) {
                DBObject currRec = cursor.next();
                DBObject currField = (DBObject)currRec.get("_id");
                String fieldName = (String)currField.get("fieldname");
                String fieldType = (String)currField.get("type");
                int typeCount = ((Double)currRec.get("value")).intValue();
                if (!fieldMap.containsKey(fieldName)) {
                    fieldMap.put(fieldName, new ClassCount(fieldType, typeCount));
                    continue;
                }
                ClassCount currCount = fieldMap.get(fieldName);
                currCount.add(fieldType, typeCount);
                fieldMap.put(fieldName, currCount);
            }
        }
        finally {
            cursor.close();
        }
        return fieldMap;
    }

    private HashMap<String, String> finalizeMajorityRule(HashMap<String, ClassCount> fieldMap, RecordBuilder buildRule) {
        HashMap<String, String> finalMap = new HashMap<String, String>();
        for (String field : fieldMap.keySet()) {
            String finalClass = fieldMap.get(field).getMajorityClass(field, buildRule);
            finalMap.put(field, finalClass);
        }
        return finalMap;
    }

    private DBObject convertMapToJson(HashMap<String, String> finalMap) {
        BasicDBObject metaData = new BasicDBObject();
        BasicDBObject geometry = new BasicDBObject();
        geometry.append("type", (Object)finalMap.get("geometry.type"));
        metaData.append("geometry", (Object)geometry);
        BasicDBObject properties = new BasicDBObject();
        properties = (BasicDBObject)this.recreateJson("properties", properties, finalMap);
        metaData.append("properties", (Object)properties);
        return metaData;
    }

    private BSONObject recreateJson(String baseName, Object base, HashMap<String, String> fieldMap) {
        HashMap<String, String> propMap = new HashMap<String, String>();
        for (String key : fieldMap.keySet()) {
            if (!key.startsWith(baseName + ".")) continue;
            String propKey = key.substring(baseName.length() + 1);
            propMap.put(propKey, fieldMap.get(key));
        }
        BasicDBObject json = null;
        if (base instanceof BasicDBObject) {
            json = new BasicDBObject();
        } else if (base instanceof BasicBSONList) {
            json = new BasicBSONList();
        } else {
            log.warning("Error, can only process BasicDBObject (JSON) or BasicBSONList (Array), base is a " + base.getClass());
            return new BasicBSONObject();
        }
        for (String propKey : propMap.keySet()) {
            if (propKey.contains(".") || propMap.get(propKey) == null) continue;
            if (((String)propMap.get(propKey)).equals("com.mongodb.BasicDBObject")) {
                BasicDBObject subJSON = new BasicDBObject();
                json.put(propKey, (Object)this.recreateJson(propKey, subJSON, propMap));
                continue;
            }
            if (((String)propMap.get(propKey)).equals("com.mongodb.BasicDBList")) {
                BasicBSONList subArray = new BasicBSONList();
                json.put(propKey, (Object)this.recreateJson(propKey, subArray, propMap));
                continue;
            }
            try {
                json.put(propKey, Class.forName(propMap.get(propKey)).newInstance());
            }
            catch (InstantiationException ie) {
                try {
                    json.put(propKey, Class.forName(propMap.get(propKey)).getConstructor(String.class).newInstance("0"));
                }
                catch (Exception e) {
                }
            }
            catch (Exception e) {}
        }
        return json;
    }

    private void setGeometryType(DBObject metaData) {
        try {
            String geoTypeStr = (String)((DBObject)metaData.get("geometry")).get("type");
            this.geometryType = GeometryType.valueOf(geoTypeStr);
        }
        catch (Throwable t) {
            this.geometryType = GeometryType.Unknown;
        }
    }

    static {
        classNameMap.put("array", BasicDBList.class.getCanonicalName());
        classNameMap.put("boolean", Boolean.class.getCanonicalName());
        classNameMap.put("date", Date.class.getCanonicalName());
        classNameMap.put("double", Double.class.getCanonicalName());
        classNameMap.put("long", Long.class.getCanonicalName());
        classNameMap.put("object", BasicDBObject.class.getCanonicalName());
        classNameMap.put("string", String.class.getCanonicalName());
        log = MongoPluginConfig.getLog();
    }

    private class ClassCount {
        private HashMap<String, Integer> classMap = new HashMap();

        public ClassCount(String initClass, int initCount) {
            this.classMap.put(initClass, initCount);
        }

        public void add(String newClass, int newCount) {
            if (this.classMap.containsKey(newClass)) {
                int currCount = this.classMap.get(newClass);
                this.classMap.put(newClass, currCount + newCount);
            } else {
                this.classMap.put(newClass, newCount);
            }
        }

        public String getMajorityClass(String propKey, RecordBuilder buildRule) {
            int max = -1;
            String maxClass = null;
            Set<String> keys = this.classMap.keySet();
            if (keys.size() > 1 && buildRule.equals((Object)RecordBuilder.STRING) && !keys.contains("geometry.type")) {
                maxClass = String.class.getCanonicalName();
            } else {
                for (String currClass : keys) {
                    if (this.classMap.get(currClass) <= max) continue;
                    max = this.classMap.get(currClass);
                    maxClass = currClass;
                }
                if (!propKey.equals("geometry.type")) {
                    maxClass = (String)classNameMap.get(maxClass);
                }
            }
            return maxClass;
        }

        public String toString() {
            return this.classMap.toString();
        }
    }

    public static enum RecordBuilder {
        MAJORITY,
        STRING;

    }

    public static enum GeometryType {
        GeometryCollection,
        LineString,
        Point,
        Polygon,
        MultiLineString,
        MultiPoint,
        MultiPolygon,
        Unknown;

    }
}

