/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import com.mongodb.BasicDBObject;
import java.awt.RenderingHints;
import java.util.Collections;
import java.util.Set;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ResourceInfo;
import org.geotools.data.mongodb.FilterToMongoQuery;
import org.geotools.data.mongodb.MongoDataStore;
import org.geotools.data.mongodb.MongoFeatureCollection;
import org.geotools.data.mongodb.MongoLayer;
import org.geotools.data.mongodb.MongoQueryCaps;
import org.geotools.data.mongodb.MongoResourceInfo;
import org.geotools.data.mongodb.MongoResultSet;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;

public class MongoFeatureSource
implements SimpleFeatureSource {
    private MongoDataStore store;
    private MongoLayer layer = null;
    private MongoResultSet results = null;
    private MongoQueryCaps queryCaps = new MongoQueryCaps();
    private MongoResourceInfo info = null;

    public MongoFeatureSource(MongoDataStore store, MongoLayer layer) {
        this.init(store, layer, null);
    }

    public MongoFeatureSource(MongoDataStore store, MongoLayer layer, BasicDBObject dbo) {
        this.init(store, layer, dbo);
    }

    private void init(MongoDataStore store, MongoLayer layer, BasicDBObject dbo) {
        this.store = store;
        this.layer = layer;
        BasicDBObject query = dbo;
        if (query == null) {
            query = new BasicDBObject();
        }
        this.results = new MongoResultSet(layer, query);
        this.info = new MongoResourceInfo(this);
    }

    public MongoLayer getLayer() {
        return this.layer;
    }

    public ReferencedEnvelope getBounds() {
        return this.results.getBounds();
    }

    public Set<String> getKeywords() {
        return this.layer.getKeywords();
    }

    public final Set<RenderingHints.Key> getSupportedHints() {
        return Collections.emptySet();
    }

    public final int getCount(Query query) {
        int res = 0;
        FilterToMongoQuery f2m = new FilterToMongoQuery();
        Filter filter = query.getFilter();
        BasicDBObject dbo = (BasicDBObject)filter.accept((FilterVisitor)f2m, null);
        MongoResultSet rs = new MongoResultSet(this.layer, dbo);
        res = rs.getCount();
        return res;
    }

    public final ReferencedEnvelope getBounds(Query query) {
        FilterToMongoQuery f2m = new FilterToMongoQuery();
        Filter filter = query.getFilter();
        BasicDBObject dbo = (BasicDBObject)filter.accept((FilterVisitor)f2m, null);
        MongoResultSet rs = new MongoResultSet(this.layer, dbo);
        return rs.getBounds();
    }

    public final SimpleFeatureCollection getFeatures() {
        return new MongoFeatureCollection(this.results);
    }

    public final SimpleFeatureCollection getFeatures(Filter filter) {
        FilterToMongoQuery f2m = new FilterToMongoQuery();
        BasicDBObject dbo = (BasicDBObject)filter.accept((FilterVisitor)f2m, null);
        MongoResultSet rs = new MongoResultSet(this.layer, dbo);
        return new MongoFeatureCollection(rs);
    }

    public final SimpleFeatureCollection getFeatures(Query query) {
        FilterToMongoQuery f2m = new FilterToMongoQuery();
        Filter filter = query.getFilter();
        BasicDBObject dbo = (BasicDBObject)filter.accept((FilterVisitor)f2m, null);
        MongoResultSet rs = new MongoResultSet(this.layer, dbo);
        int maxFeatures = query.getMaxFeatures();
        if (maxFeatures > 0) {
            int startIndex = 0;
            if (query.getStartIndex() != null) {
                startIndex = query.getStartIndex();
            }
            rs.paginateFeatures(startIndex, maxFeatures);
        }
        return new MongoFeatureCollection(rs);
    }

    public final SimpleFeatureType getSchema() {
        return this.layer.getSchema();
    }

    public final void addFeatureListener(FeatureListener listener) {
        this.store.addListener((FeatureSource<?, ?>)this, listener);
    }

    public final void removeFeatureListener(FeatureListener listener) {
        this.store.removeListener((FeatureSource<?, ?>)this, listener);
    }

    public final DataStore getDataStore() {
        return this.store;
    }

    public QueryCapabilities getQueryCapabilities() {
        return this.queryCaps;
    }

    public ResourceInfo getInfo() {
        return this.info;
    }

    public Name getName() {
        return this.layer.getSchema().getName();
    }
}

