/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import java.awt.RenderingHints;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.mongodb.MongoDataStore;
import org.geotools.data.mongodb.MongoPluginConfig;
import org.geotools.data.mongodb.MongoPluginException;

public class MongoDataStoreFactory
implements DataStoreFactorySpi {
    private static final String FACTORY_DESCRIPTION = "MongoDB GeoServer Plugin";
    private static final String FACTORY_DISPLAY_NAME = "MongoDB";
    private static final Logger log = MongoPluginConfig.getLog();

    public DataStore createNewDataStore(Map<String, Serializable> map) {
        return this.createDataStore(map);
    }

    public DataStore createDataStore(Map<String, Serializable> params) {
        MongoDataStore theStore = null;
        log.info("DataStore.createDataStore()");
        try {
            MongoPluginConfig config = new MongoPluginConfig(params);
            theStore = new MongoDataStore(config);
            log.info("DataStore.createDataStore(); theStore=" + theStore);
        }
        catch (Throwable t) {
            log.severe(t.getLocalizedMessage());
        }
        return theStore;
    }

    public boolean isAvailable() {
        boolean result = false;
        try {
            Class.forName("com.mongodb.BasicDBObject");
            result = true;
        }
        catch (Throwable t) {
            log.severe("Mongo Plugin: The MongoDB JAR file was not found on the class path.");
        }
        return result;
    }

    public boolean canProcess(Map<String, Serializable> params) {
        boolean result = true;
        try {
            new MongoPluginConfig(params);
        }
        catch (MongoPluginException e) {
            result = false;
        }
        return result;
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        List<DataAccessFactory.Param> params = MongoPluginConfig.getPluginParams();
        return params.toArray(new DataAccessFactory.Param[params.size()]);
    }

    public String getDescription() {
        return FACTORY_DESCRIPTION;
    }

    public String getDisplayName() {
        return FACTORY_DISPLAY_NAME;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.emptyMap();
    }
}

