/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.bson.types.BasicBSONList;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.EmptyFeatureWriter;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureListenerManager;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.mongodb.FilterToMongoQuery;
import org.geotools.data.mongodb.MongoFeatureReader;
import org.geotools.data.mongodb.MongoFeatureSource;
import org.geotools.data.mongodb.MongoLayer;
import org.geotools.data.mongodb.MongoPluginConfig;
import org.geotools.data.mongodb.MongoResultSet;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MongoDataStore
implements DataStore {
    private ArrayList<MongoLayer> layers = null;
    private CoordinateReferenceSystem crs = null;
    private MongoPluginConfig config = null;
    private FeatureListenerManager lsnMgr = null;
    private static final Logger log = MongoPluginConfig.getLog();

    public MongoDataStore(MongoPluginConfig config) {
        this.config = config;
        this.lsnMgr = new FeatureListenerManager();
        this.layers = new ArrayList();
        log.info("MongoDataStore; layers=" + this.layers);
        try {
            this.crs = CRS.decode((String)"EPSG:4326");
        }
        catch (Throwable t) {
            this.crs = DefaultGeographicCRS.WGS84;
        }
        if (this.layers.size() == 0) {
            this.getLayers();
        }
    }

    private void getLayers() {
        Mongo mongo = null;
        try {
            mongo = new Mongo(this.config.getHost(), this.config.getPort());
            DB db = mongo.getDB(this.config.getDB());
            Set colls = db.getCollectionNames();
            for (String s : colls) {
                DBCollection dbc = db.getCollection(s);
                log.info("getLayers; collection=" + dbc);
                List geoList = dbc.distinct("geometry.type");
                List propList = null;
                try {
                    propList = dbc.distinct("properties");
                }
                catch (IllegalArgumentException ex) {
                    propList = new BasicBSONList();
                    propList.add("ex nihilo");
                }
                catch (MongoException ex) {
                    propList = new BasicBSONList();
                    propList.add("ex nihilo");
                }
                if (geoList == null || propList == null || propList.size() <= 0) continue;
                boolean hasValidGeo = false;
                for (MongoLayer.GeometryType type : MongoLayer.GeometryType.values()) {
                    if (!geoList.contains(type.toString())) continue;
                    hasValidGeo = true;
                    break;
                }
                if (!hasValidGeo) continue;
                this.layers.add(new MongoLayer(dbc, this.config));
            }
        }
        catch (Throwable t) {
            log.severe("getLayers error; " + t.getLocalizedMessage());
        }
        if (mongo != null) {
            mongo.close();
        }
    }

    public CoordinateReferenceSystem getCRS() {
        return this.crs;
    }

    public MongoPluginConfig getConfig() {
        return this.config;
    }

    public void addListener(FeatureSource<?, ?> src, FeatureListener listener) {
        this.lsnMgr.addFeatureListener(src, listener);
    }

    public void removeListener(FeatureSource<?, ?> src, FeatureListener listener) {
        this.lsnMgr.removeFeatureListener(src, listener);
    }

    public Set<String> getKeywords(String typeName) {
        Set<String> result = null;
        for (MongoLayer ml : this.layers) {
            if (!ml.getName().equals(typeName)) continue;
            result = ml.getKeywords();
            break;
        }
        return result;
    }

    public LockingManager getLockingManager() {
        return null;
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction transaction) {
        return new EmptyFeatureWriter(new SimpleFeatureTypeBuilder().buildFeatureType());
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Transaction transaction) {
        return new EmptyFeatureWriter(new SimpleFeatureTypeBuilder().buildFeatureType());
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Filter filter, Transaction transaction) {
        return new EmptyFeatureWriter(new SimpleFeatureTypeBuilder().buildFeatureType());
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction transaction) {
        FilterToMongoQuery f2m = new FilterToMongoQuery();
        Filter filter = query.getFilter();
        BasicDBObject dbo = (BasicDBObject)filter.accept((FilterVisitor)f2m, null);
        MongoLayer layer = this.getMongoLayer(query.getTypeName());
        MongoResultSet rs = new MongoResultSet(layer, dbo);
        return new MongoFeatureReader(rs);
    }

    public SimpleFeatureSource getFeatureSource(String typeName) throws IOException {
        MongoLayer layer = this.getMongoLayer(typeName);
        return new MongoFeatureSource(this, layer);
    }

    public FeatureSource<SimpleFeatureType, SimpleFeature> getView(Query query) {
        FilterToMongoQuery f2m = new FilterToMongoQuery();
        Filter filter = query.getFilter();
        BasicDBObject dbo = (BasicDBObject)filter.accept((FilterVisitor)f2m, null);
        MongoLayer layer = this.getMongoLayer(query.getTypeName());
        return new MongoFeatureSource(this, layer, dbo);
    }

    public SimpleFeatureType getSchema(String typeName) {
        SimpleFeatureType sft = null;
        for (MongoLayer ml : this.layers) {
            if (!ml.getName().equals(typeName)) continue;
            sft = ml.getSchema();
        }
        return sft;
    }

    public String[] getTypeNames() {
        String[] names = new String[this.layers.size()];
        int idx = 0;
        for (MongoLayer ml : this.layers) {
            names[idx++] = ml.getName();
        }
        return names;
    }

    public void updateSchema(String typeName, SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("Schema modification not supported");
    }

    public void dispose() {
    }

    public SimpleFeatureSource getFeatureSource(Name name) throws IOException {
        return this.getFeatureSource(name.getLocalPart());
    }

    public SimpleFeatureType getSchema(Name name) throws IOException {
        return this.getSchema(name.getLocalPart());
    }

    public List<Name> getNames() throws IOException {
        ArrayList<Name> names = new ArrayList<Name>(this.layers.size());
        for (MongoLayer ml : this.layers) {
            names.add((Name)new NameImpl(ml.getName()));
        }
        return names;
    }

    public void updateSchema(Name typeName, SimpleFeatureType featureType) throws IOException {
        this.updateSchema(typeName.getLocalPart(), featureType);
    }

    public void createSchema(SimpleFeatureType featureType) throws IOException, IllegalArgumentException {
    }

    public ServiceInfo getInfo() {
        DefaultServiceInfo info = new DefaultServiceInfo();
        info.setTitle("MongoDB Data Store");
        info.setDescription("Features from MongoDB");
        try {
            info.setSchema(new URI(this.config.getNamespace()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return info;
    }

    public MongoLayer getMongoLayer(String typeName) {
        MongoLayer layer = null;
        for (MongoLayer ml : this.layers) {
            if (!ml.getName().equals(typeName)) continue;
            layer = ml;
            break;
        }
        return layer;
    }
}

