/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.util.List;
import java.util.regex.Pattern;
import org.opengis.filter.And;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.AnyInteracts;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.Meets;
import org.opengis.filter.temporal.MetBy;
import org.opengis.filter.temporal.OverlappedBy;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;

public class FilterToMongoQuery
implements FilterVisitor,
ExpressionVisitor {
    protected BasicDBObject asDBObject(Object extraData) {
        if (extraData != null || extraData instanceof BasicDBObject) {
            return (BasicDBObject)extraData;
        }
        return new BasicDBObject();
    }

    public Object visit(Literal expression, Object extraData) {
        Object literal = expression.getValue();
        String ret = literal.toString();
        return ret;
    }

    public Object visit(PropertyName expression, Object extraData) {
        return expression.getPropertyName();
    }

    public Object visit(ExcludeFilter filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        output.put("foo", (Object)"not_likely_to_exist");
        return output;
    }

    public Object visit(IncludeFilter filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        return output;
    }

    public Object visit(And filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        List children = filter.getChildren();
        if (children != null) {
            for (Filter child : children) {
                child.accept((FilterVisitor)this, (Object)output);
            }
        }
        return output;
    }

    public Object visit(Id filter, Object extraData) {
        throw new IllegalStateException("Cannot encode an Id as legal CQL");
    }

    public Object visit(Not filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        BasicDBObject expr = (BasicDBObject)filter.getFilter().accept((FilterVisitor)this, null);
        output.put("$not", (Object)expr);
        return output;
    }

    public Object visit(Or filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        List children = filter.getChildren();
        BasicDBList orList = new BasicDBList();
        if (children != null) {
            for (Filter child : children) {
                BasicDBObject item = (BasicDBObject)child.accept((FilterVisitor)this, null);
                orList.add((Object)item);
            }
            output.put("$or", (Object)orList);
        }
        return output;
    }

    public Object visit(PropertyIsBetween filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        Object propName = filter.getExpression().accept((ExpressionVisitor)this, null);
        Object lower = filter.getLowerBoundary().accept((ExpressionVisitor)this, null);
        Object upper = filter.getUpperBoundary().accept((ExpressionVisitor)this, null);
        if (propName instanceof String && lower instanceof String && upper instanceof String) {
            BasicDBObject dbo = new BasicDBObject();
            dbo.put("$gte", lower);
            dbo.put("$lte", upper);
            output.put((String)propName, (Object)dbo);
        }
        return output;
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        Object expr1 = filter.getExpression1().accept((ExpressionVisitor)this, null);
        Object expr2 = filter.getExpression2().accept((ExpressionVisitor)this, null);
        if (expr1 instanceof String && expr2 instanceof String) {
            String expr2Str = ((String)expr2).trim();
            try {
                if (expr2Str.matches("-? ?(\\d+,)*\\d+")) {
                    output.put((String)expr1, (Object)new Long((String)expr2));
                } else if (expr2Str.matches("-? ?(\\d+,)*\\d+\\.\\d+")) {
                    output.put((String)expr1, (Object)new Double((String)expr2));
                } else {
                    output.put((String)expr1, expr2);
                }
            }
            catch (NumberFormatException e) {
                output.put((String)expr1, expr2);
            }
        }
        return output;
    }

    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        Object expr1 = filter.getExpression1().accept((ExpressionVisitor)this, null);
        Object expr2 = filter.getExpression2().accept((ExpressionVisitor)this, null);
        if (expr1 instanceof String && expr2 instanceof String) {
            BasicDBObject dbo = new BasicDBObject();
            try {
                dbo.put("$ne", (Object)new Double((String)expr2));
            }
            catch (NumberFormatException e) {
                dbo.put("$ne", expr2);
            }
            output.put((String)expr1, (Object)dbo);
        }
        return output;
    }

    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        Object expr1 = filter.getExpression1().accept((ExpressionVisitor)this, null);
        Object expr2 = filter.getExpression2().accept((ExpressionVisitor)this, null);
        if (expr1 instanceof String && expr2 instanceof String) {
            BasicDBObject dbo = new BasicDBObject();
            try {
                dbo.put("$gt", (Object)new Double((String)expr2));
            }
            catch (NumberFormatException e) {
                dbo.put("$gt", expr2);
            }
            output.put((String)expr1, (Object)dbo);
        }
        return output;
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        Object expr1 = filter.getExpression1().accept((ExpressionVisitor)this, null);
        Object expr2 = filter.getExpression2().accept((ExpressionVisitor)this, null);
        if (expr1 instanceof String && expr2 instanceof String) {
            BasicDBObject dbo = new BasicDBObject();
            try {
                dbo.put("$gte", (Object)new Double((String)expr2));
            }
            catch (NumberFormatException e) {
                dbo.put("$gte", expr2);
            }
            output.put((String)expr1, (Object)dbo);
        }
        return output;
    }

    public Object visit(PropertyIsLessThan filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        Object expr1 = filter.getExpression1().accept((ExpressionVisitor)this, null);
        Object expr2 = filter.getExpression2().accept((ExpressionVisitor)this, null);
        if (expr1 instanceof String && expr2 instanceof String) {
            BasicDBObject dbo = new BasicDBObject();
            try {
                dbo.put("$lt", (Object)new Double((String)expr2));
            }
            catch (NumberFormatException e) {
                dbo.put("$lt", expr2);
            }
            output.put((String)expr1, (Object)dbo);
        }
        return output;
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        Object expr1 = filter.getExpression1().accept((ExpressionVisitor)this, null);
        Object expr2 = filter.getExpression2().accept((ExpressionVisitor)this, null);
        if (expr1 instanceof String && expr2 instanceof String) {
            BasicDBObject dbo = new BasicDBObject();
            try {
                dbo.put("$lte", (Object)new Double((String)expr2));
            }
            catch (NumberFormatException e) {
                dbo.put("$lte", expr2);
            }
            output.put((String)expr1, (Object)dbo);
        }
        return output;
    }

    public Object visit(PropertyIsLike filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        Expression expr = filter.getExpression();
        if (expr instanceof String) {
            String multi = filter.getWildCard();
            String single = filter.getSingleChar();
            int flags = filter.isMatchingCase() ? 0 : 2;
            String cqlPattern = filter.getLiteral();
            cqlPattern.replaceAll(multi, ".*");
            cqlPattern.replaceAll(single, ".");
            try {
                Pattern p = Pattern.compile(cqlPattern, flags);
                output.put((String)expr, (Object)p);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return output;
    }

    public Object visit(PropertyIsNull filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        Object expr = filter.accept((FilterVisitor)this, null);
        if (expr instanceof String) {
            BasicDBObject dbo = new BasicDBObject();
            dbo.put("$exists", (Object)false);
            output.put((String)expr, (Object)dbo);
        }
        return output;
    }

    public Object visit(BBOX filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        double minX = 180.0;
        double minY = 90.0;
        double maxX = -180.0;
        double maxY = -90.0;
        Expression exp2 = filter.getExpression2();
        if (exp2 instanceof Literal) {
            Geometry bbox = (Geometry)((Literal)exp2).getValue();
            Coordinate[] coords = bbox.getEnvelope().getCoordinates();
            minX = coords[0].x;
            minY = coords[0].y;
            maxX = coords[2].x;
            maxY = coords[2].y;
        }
        if (minX < -180.0) {
            minX = -180.0;
        }
        if (maxX > 180.0) {
            maxX = 180.0;
        }
        if (minY < -90.0) {
            minY = -90.0;
        }
        if (maxY > 90.0) {
            maxY = 90.0;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("gtmpGeoQuery([");
        sb.append(minX);
        sb.append(",");
        sb.append(minY);
        sb.append(",");
        sb.append(maxX);
        sb.append(",");
        sb.append(maxY);
        sb.append("])");
        output.put("$where", (Object)sb.toString());
        return output;
    }

    public Object visitNullFilter(Object extraData) {
        throw new NullPointerException("Cannot encode null as a Filter");
    }

    public Object visit(NilExpression expression, Object extraData) {
        return extraData;
    }

    public Object visit(Beyond filter, Object extraData) {
        return extraData;
    }

    public Object visit(Contains filter, Object extraData) {
        return extraData;
    }

    public Object visit(Crosses filter, Object extraData) {
        return extraData;
    }

    public Object visit(Disjoint filter, Object extraData) {
        return extraData;
    }

    public Object visit(DWithin filter, Object extraData) {
        return extraData;
    }

    public Object visit(Equals filter, Object extraData) {
        return extraData;
    }

    public Object visit(Intersects filter, Object extraData) {
        return extraData;
    }

    public Object visit(Overlaps filter, Object extraData) {
        return extraData;
    }

    public Object visit(Touches filter, Object extraData) {
        return extraData;
    }

    public Object visit(Within filter, Object extraData) {
        return extraData;
    }

    public Object visit(Add expression, Object extraData) {
        return extraData;
    }

    public Object visit(Divide expression, Object extraData) {
        return extraData;
    }

    public Object visit(Function function, Object extraData) {
        return extraData;
    }

    public Object visit(Multiply expression, Object extraData) {
        return extraData;
    }

    public Object visit(Subtract expression, Object extraData) {
        return extraData;
    }

    public Object visit(PropertyIsNil filter, Object extraData) {
        return null;
    }

    public Object visit(After after, Object extraData) {
        return null;
    }

    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        return null;
    }

    public Object visit(Before before, Object extraData) {
        return null;
    }

    public Object visit(Begins begins, Object extraData) {
        return null;
    }

    public Object visit(BegunBy begunBy, Object extraData) {
        return null;
    }

    public Object visit(During during, Object extraData) {
        return null;
    }

    public Object visit(EndedBy endedBy, Object extraData) {
        return null;
    }

    public Object visit(Ends ends, Object extraData) {
        return null;
    }

    public Object visit(Meets meets, Object extraData) {
        return null;
    }

    public Object visit(MetBy metBy, Object extraData) {
        return null;
    }

    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        return null;
    }

    public Object visit(TContains contains, Object extraData) {
        return null;
    }

    public Object visit(TEquals equals, Object extraData) {
        return null;
    }

    public Object visit(TOverlaps contains, Object extraData) {
        return null;
    }
}

