/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.awt.RenderingHints;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.imageio.spi.RegisterableService;
import javax.imageio.spi.ServiceRegistry;
import org.geotools.factory.Factory;
import org.geotools.factory.FactoryComparator;
import org.geotools.factory.Hints;
import org.geotools.io.TableWriter;
import org.geotools.resources.Classes;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.opengis.referencing.AuthorityFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractFactory
implements Factory,
RegisterableService {
    public static final int MINIMUM_PRIORITY = 1;
    public static final int NORMAL_PRIORITY = 50;
    public static final int MAXIMUM_PRIORITY = 100;
    protected final int priority;
    protected final Map<RenderingHints.Key, Object> hints = new LinkedHashMap<RenderingHints.Key, Object>();
    private final Map<RenderingHints.Key, Object> unmodifiableHints = Collections.unmodifiableMap(this.hints);

    protected AbstractFactory() {
        this(50);
    }

    protected AbstractFactory(int priority) {
        this.priority = priority;
        if (priority < 1 || priority > 100) {
            throw new IllegalArgumentException(Errors.format(42, "priority", priority));
        }
    }

    public int getPriority() {
        return this.priority;
    }

    protected boolean addImplementationHints(RenderingHints map) {
        boolean changed = false;
        if (map != null) {
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                Object key = entry.getKey();
                if (!(key instanceof RenderingHints.Key)) continue;
                Object value = entry.getValue();
                Object old = this.hints.put((RenderingHints.Key)key, value);
                if (changed || Utilities.equals(value, old)) continue;
                changed = true;
            }
        }
        return changed;
    }

    @Override
    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return this.unmodifiableHints;
    }

    public void onRegistration(ServiceRegistry registry, Class category) {
        Iterator it = registry.getServiceProviders(category, false);
        while (it.hasNext()) {
            AbstractFactory second;
            AbstractFactory first;
            int compare;
            Object provider = it.next();
            if (provider == this || !(provider instanceof AbstractFactory)) continue;
            AbstractFactory factory = (AbstractFactory)provider;
            int priority = this.getPriority();
            if (priority > (compare = factory.getPriority())) {
                first = this;
                second = factory;
            } else {
                if (priority >= compare) continue;
                first = factory;
                second = this;
            }
            registry.setOrdering(category, first, second);
        }
    }

    public void onDeregistration(ServiceRegistry registry, Class category) {
    }

    public final int hashCode() {
        return this.getClass().hashCode() + 37 * this.priority;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            AbstractFactory that = (AbstractFactory)object;
            if (this.priority == that.priority) {
                HashSet<FactoryComparator> comparators = new HashSet<FactoryComparator>();
                return new FactoryComparator(this, that).compare(comparators);
            }
        }
        return false;
    }

    public String toString() {
        String name = AbstractFactory.format(this);
        IdentityHashMap<Factory, String> done = new IdentityHashMap<Factory, String>();
        done.put(this, name);
        String tree = AbstractFactory.format(this.getImplementationHints(), done);
        return name + System.getProperty("line.separator", "\n") + tree;
    }

    static String toString(Map<?, ?> hints) {
        return AbstractFactory.format(hints, new IdentityHashMap<Factory, String>());
    }

    private static String format(Factory factory) {
        String name = Classes.getShortClassName(factory);
        if (factory instanceof AuthorityFactory) {
            name = name + "[\"" + ((AuthorityFactory)factory).getAuthority().getTitle() + "\"]";
        }
        return name;
    }

    private static String format(Map<?, ?> hints, Map<Factory, String> done) {
        TableWriter table;
        try {
            table = new TableWriter(null, " ");
            AbstractFactory.format(table, hints, "  ", done);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return ((Object)table).toString();
    }

    private static void format(Writer table, Map<?, ?> hints, String indent, Map<Factory, String> done) throws IOException {
        for (Map.Entry<?, ?> entry : hints.entrySet()) {
            Object k = entry.getKey();
            String key = k instanceof RenderingHints.Key ? Hints.nameOf((RenderingHints.Key)k) : String.valueOf(k);
            Object value = entry.getValue();
            table.write(indent);
            table.write(key);
            table.write("\t= ");
            Factory recursive = null;
            if (value instanceof Factory) {
                recursive = (Factory)value;
                value = AbstractFactory.format(recursive);
                String previous = done.put(recursive, key);
                if (previous != null) {
                    done.put(recursive, previous);
                    table.write("(same as ");
                    table.write(previous);
                    value = ")";
                    recursive = null;
                }
            }
            table.write(String.valueOf(value));
            table.write(10);
            if (recursive == null) continue;
            String nextIndent = Utilities.spaces(indent.length() + 2);
            AbstractFactory.format(table, recursive.getImplementationHints(), nextIndent, done);
        }
    }
}

