/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.impl.PackedCoordinateSequence;
import java.util.ArrayList;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;

public class LiteCoordinateSequence
extends PackedCoordinateSequence {
    private static final GeometryFactory geomFac = new GeometryFactory((CoordinateSequenceFactory)new LiteCoordinateSequenceFactory());
    private double[] coords;
    private int size;

    public LiteCoordinateSequence(double[] coords, int dimensions) {
        this.init(coords, dimensions);
    }

    void init(double[] coords, int dimensions) {
        this.dimension = dimensions;
        if (dimensions < 2) {
            throw new IllegalArgumentException("Invalid dimensions, must be at least 2");
        }
        if (coords.length % this.dimension != 0) {
            throw new IllegalArgumentException("Packed array does not contain an integral number of coordinates");
        }
        this.coords = coords;
        this.size = coords.length / this.dimension;
    }

    public LiteCoordinateSequence(double[] coords) {
        this.init(coords, 2);
    }

    public LiteCoordinateSequence(float[] coordinates, int dimension) {
        double[] dcoords = new double[coordinates.length];
        for (int i = 0; i < coordinates.length; ++i) {
            dcoords[i] = coordinates[i];
        }
        this.init(dcoords, dimension);
    }

    public LiteCoordinateSequence(float[] coordinates) {
        this(coordinates, 2);
    }

    public LiteCoordinateSequence(Coordinate[] coordinates) {
        if (coordinates == null) {
            coordinates = new Coordinate[]{};
        }
        this.dimension = 2;
        this.coords = new double[coordinates.length * this.dimension];
        for (int i = 0; i < coordinates.length; ++i) {
            this.coords[i * this.dimension] = coordinates[i].x;
            if (this.dimension < 2) continue;
            this.coords[i * this.dimension + 1] = coordinates[i].y;
        }
        this.size = coordinates.length;
    }

    public LiteCoordinateSequence(int size, int dimension) {
        this.dimension = dimension;
        this.coords = new double[size * this.dimension];
        this.size = this.coords.length / dimension;
    }

    public LiteCoordinateSequence(LiteCoordinateSequence seq) {
        this.dimension = seq.dimension;
        this.size = seq.size;
        double[] orig = seq.getArray();
        this.coords = new double[orig.length];
        System.arraycopy(orig, 0, this.coords, 0, this.coords.length);
    }

    public LiteCoordinateSequence(CoordinateSequence cs, int dimension) {
        this.size = cs.size();
        this.dimension = dimension;
        if (cs instanceof LiteCoordinateSequence) {
            double[] orig = ((LiteCoordinateSequence)cs).getOrdinateArray(dimension);
            this.coords = new double[orig.length];
            System.arraycopy(orig, 0, this.coords, 0, this.coords.length);
        } else {
            this.coords = new double[this.size * dimension];
            int minDimension = Math.min(dimension, cs.getDimension());
            for (int i = 0; i < this.size; ++i) {
                for (int j = 0; j < minDimension; ++j) {
                    this.coords[i * dimension + j] = cs.getOrdinate(i, j);
                }
            }
        }
    }

    public Coordinate getCoordinateInternal(int i) {
        double x = this.coords[i * this.dimension];
        double y = this.coords[i * this.dimension + 1];
        double z = this.dimension == 2 ? Double.NaN : this.coords[i * this.dimension + 2];
        return new Coordinate(x, y, z);
    }

    public int size() {
        return this.size;
    }

    public Object clone() {
        double[] clone = new double[this.coords.length];
        System.arraycopy(this.coords, 0, clone, 0, this.coords.length);
        return new LiteCoordinateSequence(clone, this.dimension);
    }

    public double getOrdinate(int index, int ordinate) {
        return this.coords[index * this.dimension + ordinate];
    }

    public double getX(int index) {
        return this.coords[index * this.dimension];
    }

    public double getY(int index) {
        return this.coords[index * this.dimension + 1];
    }

    public void setOrdinate(int index, int ordinate, double value) {
        this.coordRef = null;
        this.coords[index * this.dimension + ordinate] = value;
    }

    public Envelope expandEnvelope(Envelope env) {
        double miny;
        double minx;
        double maxx = minx = this.coords[0];
        double maxy = miny = this.coords[1];
        for (int i = 0; i < this.coords.length; i += this.dimension) {
            double x = this.coords[i];
            if (x < minx) {
                minx = x;
            } else if (x > maxx) {
                maxx = x;
            }
            double y = this.coords[i + 1];
            if (y < miny) {
                miny = y;
                continue;
            }
            if (!(y > maxy)) continue;
            maxy = y;
        }
        env.expandToInclude(minx, miny);
        env.expandToInclude(maxx, maxy);
        return env;
    }

    public double[] getArray() {
        return this.coords;
    }

    public void setArray(double[] coords2) {
        this.coords = coords2;
        this.size = this.coords.length / this.dimension;
        this.coordRef = null;
    }

    public void setArray(double[] coords2, int dimension) {
        this.coords = coords2;
        this.dimension = dimension;
        this.size = this.coords.length / dimension;
        this.coordRef = null;
    }

    public double[] getXYArray() {
        if (this.dimension == 2) {
            return this.coords;
        }
        int n = this.size();
        double[] result = new double[n * 2];
        for (int t = 0; t < n; ++t) {
            result[t * 2] = this.getOrdinate(t, 0);
            result[t * 2 + 1] = this.getOrdinate(t, 1);
        }
        return result;
    }

    public double[] getOrdinateArray(int dimensions) {
        if (dimensions == this.dimension) {
            return this.coords;
        }
        int n = this.size();
        double[] result = new double[n * dimensions];
        int minDimensions = Math.min(dimensions, this.dimension);
        for (int t = 0; t < n; ++t) {
            for (int d = 0; d < minDimensions; ++d) {
                result[t * 2 + d] = this.getOrdinate(t, d);
            }
        }
        return result;
    }

    public static Geometry cloneGeometry(Geometry geom, int dimension) {
        if (dimension < 2) {
            throw new IllegalArgumentException("Invalid dimension value, must be >= 2");
        }
        if (geom == null) {
            return null;
        }
        if (geom instanceof LineString) {
            return LiteCoordinateSequence.cloneGeometry((LineString)geom, dimension);
        }
        if (geom instanceof Polygon) {
            return LiteCoordinateSequence.cloneGeometry((Polygon)geom, dimension);
        }
        if (geom instanceof Point) {
            return LiteCoordinateSequence.cloneGeometry((Point)geom, dimension);
        }
        return LiteCoordinateSequence.cloneGeometry((GeometryCollection)geom, dimension);
    }

    public static final Geometry cloneGeometry(Geometry geom) {
        return LiteCoordinateSequence.cloneGeometry(geom, 2);
    }

    private static final Geometry cloneGeometry(Polygon geom, int dimension) {
        LinearRing lr = (LinearRing)LiteCoordinateSequence.cloneGeometry((LinearRing)geom.getExteriorRing(), dimension);
        LinearRing[] rings = new LinearRing[geom.getNumInteriorRing()];
        for (int t = 0; t < rings.length; ++t) {
            rings[t] = (LinearRing)LiteCoordinateSequence.cloneGeometry((LinearRing)geom.getInteriorRingN(t), dimension);
        }
        return geomFac.createPolygon(lr, rings);
    }

    private static final Geometry cloneGeometry(Point geom, int dimension) {
        return geomFac.createPoint((CoordinateSequence)new LiteCoordinateSequence(geom.getCoordinateSequence(), dimension));
    }

    private static final Geometry cloneGeometry(LineString geom, int dimension) {
        return geomFac.createLineString((CoordinateSequence)new LiteCoordinateSequence(geom.getCoordinateSequence(), dimension));
    }

    private static final Geometry cloneGeometry(LinearRing geom, int dimension) {
        return geomFac.createLinearRing((CoordinateSequence)new LiteCoordinateSequence(geom.getCoordinateSequence(), dimension));
    }

    private static final Geometry cloneGeometry(GeometryCollection geom, int dimension) {
        if (geom.getNumGeometries() == 0) {
            Geometry[] gs = new Geometry[]{};
            return geomFac.createGeometryCollection(gs);
        }
        ArrayList<Geometry> gs = new ArrayList<Geometry>(geom.getNumGeometries());
        int n = geom.getNumGeometries();
        for (int t = 0; t < n; ++t) {
            gs.add(LiteCoordinateSequence.cloneGeometry(geom.getGeometryN(t), dimension));
        }
        return geomFac.buildGeometry(gs);
    }

    public String toString() {
        if (this.size > 0) {
            StringBuffer strBuf = new StringBuffer(9 * this.dimension * this.size);
            strBuf.append('(');
            for (int i = 0; i < this.size; ++i) {
                for (int j = 0; j < this.dimension; ++j) {
                    strBuf.append(this.coords[i * this.dimension + j]);
                    if (j >= this.dimension - 1) continue;
                    strBuf.append(" ");
                }
                if (i >= this.size - 1) continue;
                strBuf.append(", ");
            }
            strBuf.append(')');
            return strBuf.toString();
        }
        return "()";
    }
}

