/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.awt.Color;
import java.net.URL;
import java.util.Arrays;
import java.util.logging.Logger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.filter.IllegalFilterException;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbol;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;

public class StyleBuilder {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.styling");
    public static final String LINE_JOIN_MITRE = "mitre";
    public static final String LINE_JOIN_ROUND = "round";
    public static final String LINE_JOIN_BEVEL = "bevel";
    public static final String LINE_CAP_BUTT = "butt";
    public static final String LINE_CAP_ROUND = "round";
    public static final String LINE_CAP_SQUARE = "square";
    public static final String MARK_SQUARE = "square";
    public static final String MARK_CIRCLE = "circle";
    public static final String MARK_TRIANGLE = "triangle";
    public static final String MARK_STAR = "star";
    public static final String MARK_CROSS = "cross";
    public static final String MARK_ARROW = "arrow";
    public static final String MARK_X = "x";
    public static final String FONT_STYLE_NORMAL = "normal";
    public static final String FONT_STYLE_ITALIC = "italic";
    public static final String FONT_STYLE_OBLIQUE = "oblique";
    public static final String FONT_WEIGHT_NORMAL = "normal";
    public static final String FONT_WEIGHT_BOLD = "bold";
    private StyleFactory sf;
    private FilterFactory2 ff;

    public StyleBuilder() {
        this(CommonFactoryFinder.getStyleFactory((Hints)GeoTools.getDefaultHints()));
    }

    public StyleBuilder(StyleFactory styleFactory) {
        this(styleFactory, CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints()));
    }

    public StyleBuilder(FilterFactory filterFactory) {
        this(CommonFactoryFinder.getStyleFactory((Hints)GeoTools.getDefaultHints()), filterFactory);
    }

    public StyleBuilder(StyleFactory styleFactory, FilterFactory filterFactory) {
        this.sf = styleFactory;
        this.ff = (FilterFactory2)filterFactory;
    }

    public void setStyleFactory(StyleFactory factory) {
        this.sf = factory;
    }

    public StyleFactory getStyleFactory() {
        return this.sf;
    }

    public void setFilterFactory(FilterFactory factory) {
        this.ff = (FilterFactory2)factory;
    }

    public FilterFactory2 getFilterFactory() {
        return this.ff;
    }

    public Stroke createStroke() {
        return this.sf.getDefaultStroke();
    }

    public Stroke createStroke(double width) {
        return this.createStroke(Color.BLACK, width);
    }

    public Stroke createStroke(Color color) {
        return this.createStroke(color, 1.0);
    }

    public Stroke createStroke(Color color, double width) {
        return this.sf.createStroke(this.colorExpression(color), this.literalExpression(width));
    }

    public Stroke createStroke(Color color, double width, String lineJoin, String lineCap) {
        Stroke stroke = this.createStroke(color, width);
        stroke.setLineJoin(this.literalExpression(lineJoin));
        stroke.setLineCap(this.literalExpression(lineCap));
        return stroke;
    }

    public Stroke createStroke(Color color, double width, float[] dashArray) {
        Stroke stroke = this.createStroke(color, width);
        stroke.setDashArray(dashArray);
        return stroke;
    }

    public Stroke createStroke(Expression color, Expression width) {
        return this.sf.createStroke(color, width);
    }

    public Stroke createStroke(Color color, double width, double opacity) {
        return this.sf.createStroke(this.colorExpression(color), this.literalExpression(width), this.literalExpression(opacity));
    }

    public Stroke createStroke(Expression color, Expression width, Expression opacity) {
        return this.sf.createStroke(color, width, opacity);
    }

    public Fill createFill() {
        Fill f = this.sf.getDefaultFill();
        f.setColor(this.literalExpression("#808080"));
        f.setBackgroundColor(this.literalExpression("#808080"));
        f.setOpacity(this.literalExpression(1.0));
        return f;
    }

    public Fill createFill(Color fillColor) {
        return this.createFill(this.colorExpression(fillColor));
    }

    public Fill createFill(Expression fillColor) {
        return this.sf.createFill(fillColor);
    }

    public Fill createFill(Color fillColor, double opacity) {
        return this.sf.createFill(this.colorExpression(fillColor), this.literalExpression(opacity));
    }

    public Fill createFill(Expression color, Expression opacity) {
        return this.sf.createFill(color, opacity);
    }

    public Fill createFill(Color color, Color backgroundColor, double opacity, Graphic fill) {
        return this.sf.createFill(this.colorExpression(color), this.colorExpression(backgroundColor), this.literalExpression(opacity), fill);
    }

    public Fill createFill(Expression color, Expression backgroundColor, Expression opacity, Graphic fill) {
        return this.sf.createFill(color, backgroundColor, opacity, fill);
    }

    public String[] getWellKnownMarkNames() {
        return new String[]{"square", MARK_CIRCLE, MARK_TRIANGLE, MARK_STAR, MARK_CROSS, MARK_ARROW, MARK_X};
    }

    public Mark createMark(String wellKnownName) {
        Mark mark = this.sf.createMark();
        mark.setWellKnownName(this.literalExpression(wellKnownName));
        return mark;
    }

    public Mark createMark(String wellKnownName, Color fillColor, Color borderColor, double borderWidth) {
        Mark mark = this.sf.createMark();
        mark.setWellKnownName(this.literalExpression(wellKnownName));
        mark.setStroke((org.opengis.style.Stroke)this.createStroke(borderColor, borderWidth));
        mark.setFill((org.opengis.style.Fill)this.createFill(fillColor));
        return mark;
    }

    public Mark createMark(String wellKnownName, Color borderColor, double borderWidth) {
        Mark mark = this.sf.createMark();
        mark.setWellKnownName(this.literalExpression(wellKnownName));
        mark.setStroke((org.opengis.style.Stroke)this.createStroke(borderColor, borderWidth));
        return mark;
    }

    public Mark createMark(String wellKnownName, Color fillColor) {
        Mark mark = this.sf.createMark();
        mark.setWellKnownName(this.literalExpression(wellKnownName));
        mark.setFill((org.opengis.style.Fill)this.createFill(fillColor, 1.0));
        mark.setStroke(null);
        return mark;
    }

    public Mark createMark(String wellKnownName, Fill fill, Stroke stroke) {
        Mark mark = this.sf.createMark();
        mark.setWellKnownName(this.literalExpression(wellKnownName));
        mark.setStroke((org.opengis.style.Stroke)stroke);
        mark.setFill((org.opengis.style.Fill)fill);
        return mark;
    }

    public Mark createMark(Expression wellKnownName, Fill fill, Stroke stroke) {
        Mark mark = this.sf.createMark();
        mark.setWellKnownName(wellKnownName);
        mark.setStroke((org.opengis.style.Stroke)stroke);
        mark.setFill((org.opengis.style.Fill)fill);
        return mark;
    }

    public ExternalGraphic createExternalGraphic(String uri, String format) {
        return this.sf.createExternalGraphic(uri, format);
    }

    public ExternalGraphic createExternalGraphic(URL url, String format) {
        return this.sf.createExternalGraphic(url, format);
    }

    public Graphic createGraphic() {
        Graphic gr = this.sf.getDefaultGraphic();
        Mark mark = this.createMark("square", Color.decode("#808080"), Color.BLACK, 1.0);
        gr.setMarks(new Mark[]{mark});
        gr.setSize(Expression.NIL);
        return gr;
    }

    public Graphic createGraphic(ExternalGraphic externalGraphic, Mark mark, Symbol symbol) {
        Graphic gr = this.sf.getDefaultGraphic();
        if (symbol != null) {
            gr.setSymbols(new Symbol[]{symbol});
        } else {
            gr.setSymbols(new Symbol[0]);
        }
        if (externalGraphic != null) {
            gr.setExternalGraphics(new ExternalGraphic[]{externalGraphic});
        }
        if (mark != null) {
            gr.setMarks(new Mark[]{mark});
        } else {
            gr.setMarks(new Mark[0]);
        }
        return gr;
    }

    public Graphic createGraphic(ExternalGraphic externalGraphic, Mark mark, Symbol symbol, double opacity, double size, double rotation) {
        ExternalGraphic[] egs = null;
        Mark[] marks = null;
        Symbol[] symbols = null;
        if (externalGraphic != null) {
            egs = new ExternalGraphic[]{externalGraphic};
        }
        if (mark != null) {
            marks = new Mark[]{mark};
        }
        if (symbol != null) {
            symbols = new Symbol[]{symbol};
        }
        return this.createGraphic(egs, marks, symbols, this.literalExpression(opacity), this.literalExpression(size), this.literalExpression(rotation));
    }

    public Graphic createGraphic(ExternalGraphic[] externalGraphics, Mark[] marks, Symbol[] symbols, double opacity, double size, double rotation) {
        return this.createGraphic(externalGraphics, marks, symbols, this.literalExpression(opacity), this.literalExpression(size), this.literalExpression(rotation));
    }

    public Graphic createGraphic(ExternalGraphic[] externalGraphics, Mark[] marks, Symbol[] symbols, Expression opacity, Expression size, Expression rotation) {
        Symbol[] s;
        Mark[] m;
        ExternalGraphic[] exg = externalGraphics;
        if (exg == null) {
            exg = new ExternalGraphic[]{};
        }
        if ((m = marks) == null) {
            m = new Mark[]{};
        }
        if ((s = symbols) == null) {
            s = new Symbol[]{};
        }
        return this.sf.createGraphic(exg, m, s, opacity, size, rotation);
    }

    public AnchorPoint createAnchorPoint(double x, double y) {
        return this.sf.createAnchorPoint(this.literalExpression(x), this.literalExpression(y));
    }

    public AnchorPoint createAnchorPoint(Expression x, Expression y) {
        return this.sf.createAnchorPoint(x, y);
    }

    public Displacement createDisplacement(double x, double y) {
        return this.sf.createDisplacement(this.literalExpression(x), this.literalExpression(y));
    }

    public Displacement createDisplacement(Expression x, Expression y) {
        return this.sf.createDisplacement(x, y);
    }

    public PointPlacement createPointPlacement() {
        return this.sf.getDefaultPointPlacement();
    }

    public PointPlacement createPointPlacement(double anchorX, double anchorY, double rotation) {
        AnchorPoint anchorPoint = this.createAnchorPoint(anchorX, anchorY);
        return this.sf.createPointPlacement(anchorPoint, null, this.literalExpression(rotation));
    }

    public PointPlacement createPointPlacement(double anchorX, double anchorY, double displacementX, double displacementY, double rotation) {
        AnchorPoint anchorPoint = this.createAnchorPoint(anchorX, anchorY);
        Displacement displacement = this.createDisplacement(displacementX, displacementY);
        return this.sf.createPointPlacement(anchorPoint, displacement, this.literalExpression(rotation));
    }

    public PointPlacement createPointPlacement(AnchorPoint anchorPoint, Displacement displacement, Expression rotation) {
        return this.sf.createPointPlacement(anchorPoint, displacement, rotation);
    }

    public LinePlacement createLinePlacement(double offset) {
        return this.sf.createLinePlacement(this.literalExpression(offset));
    }

    public LinePlacement createLinePlacement(Expression offset) {
        return this.sf.createLinePlacement(offset);
    }

    public Font createFont(java.awt.Font font) {
        Expression family = this.literalExpression(font.getFamily());
        Expression weight = font.isBold() ? this.literalExpression(FONT_WEIGHT_BOLD) : this.literalExpression("normal");
        Expression style = font.isItalic() ? this.literalExpression(FONT_STYLE_ITALIC) : this.literalExpression("normal");
        return this.sf.createFont(family, style, weight, this.literalExpression(font.getSize2D()));
    }

    public Font createFont(String fontFamily, double fontSize) {
        Expression family = this.literalExpression(fontFamily);
        Expression style = this.literalExpression("normal");
        Expression weight = this.literalExpression("normal");
        return this.sf.createFont(family, style, weight, this.literalExpression(fontSize));
    }

    public Font createFont(String fontFamily, boolean italic, boolean bold, double fontSize) {
        Expression family = this.literalExpression(fontFamily);
        Expression weight = bold ? this.literalExpression(FONT_WEIGHT_BOLD) : this.literalExpression("normal");
        Expression style = italic ? this.literalExpression(FONT_STYLE_ITALIC) : this.literalExpression("normal");
        return this.sf.createFont(family, style, weight, this.literalExpression(fontSize));
    }

    public Font createFont(Expression fontFamily, Expression fontStyle, Expression fontWeight, Expression fontSize) {
        return this.sf.createFont(fontFamily, fontStyle, fontWeight, fontSize);
    }

    public Halo createHalo() {
        return this.sf.createHalo(this.createFill(Color.WHITE), this.literalExpression(1));
    }

    public Halo createHalo(Color color, double radius) {
        return this.sf.createHalo(this.createFill(color), this.literalExpression(radius));
    }

    public Halo createHalo(Color color, double opacity, double radius) {
        return this.sf.createHalo(this.createFill(color, opacity), this.literalExpression(radius));
    }

    public Halo createHalo(Fill fill, double radius) {
        return this.sf.createHalo(fill, this.literalExpression(radius));
    }

    public Halo createHalo(Fill fill, Expression radius) {
        return this.sf.createHalo(fill, radius);
    }

    public LineSymbolizer createLineSymbolizer() {
        return this.sf.getDefaultLineSymbolizer();
    }

    public LineSymbolizer createLineSymbolizer(double width) {
        return this.createLineSymbolizer(this.createStroke(width), null);
    }

    public LineSymbolizer createLineSymbolizer(Color color) {
        return this.createLineSymbolizer(this.createStroke(color), null);
    }

    public LineSymbolizer createLineSymbolizer(Color color, double width) {
        return this.createLineSymbolizer(this.createStroke(color, width), null);
    }

    public LineSymbolizer createLineSymbolizer(Color color, double width, String geometryPropertyName) {
        return this.createLineSymbolizer(this.createStroke(color, width), geometryPropertyName);
    }

    public LineSymbolizer createLineSymbolizer(Stroke stroke) {
        return this.sf.createLineSymbolizer(stroke, null);
    }

    public LineSymbolizer createLineSymbolizer(Stroke stroke, String geometryPropertyName) {
        return this.sf.createLineSymbolizer(stroke, geometryPropertyName);
    }

    public PolygonSymbolizer createPolygonSymbolizer() {
        PolygonSymbolizer ps = this.sf.createPolygonSymbolizer();
        ps.setFill((org.opengis.style.Fill)this.createFill());
        ps.setStroke((org.opengis.style.Stroke)this.createStroke());
        return ps;
    }

    public PolygonSymbolizer createPolygonSymbolizer(Color fillColor) {
        return this.createPolygonSymbolizer(null, this.createFill(fillColor));
    }

    public PolygonSymbolizer createPolygonSymbolizer(Color fillColor, Color borderColor, double borderWidth) {
        return this.createPolygonSymbolizer(this.createStroke(borderColor, borderWidth), this.createFill(fillColor));
    }

    public PolygonSymbolizer createPolygonSymbolizer(Color borderColor, double borderWidth) {
        return this.createPolygonSymbolizer(this.createStroke(borderColor, borderWidth), null);
    }

    public PolygonSymbolizer createPolygonSymbolizer(Stroke stroke, Fill fill) {
        return this.createPolygonSymbolizer(stroke, fill, null);
    }

    public PolygonSymbolizer createPolygonSymbolizer(Stroke stroke, Fill fill, String geometryPropertyName) {
        return this.sf.createPolygonSymbolizer(stroke, fill, geometryPropertyName);
    }

    public PointSymbolizer createPointSymbolizer() {
        return this.sf.getDefaultPointSymbolizer();
    }

    public PointSymbolizer createPointSymbolizer(Graphic graphic) {
        PointSymbolizer ps = this.sf.createPointSymbolizer();
        ps.setGraphic((org.opengis.style.Graphic)graphic);
        return ps;
    }

    public PointSymbolizer createPointSymbolizer(Graphic graphic, String geometryPropertyName) {
        return this.sf.createPointSymbolizer(graphic, geometryPropertyName);
    }

    public TextSymbolizer createTextSymbolizer() {
        TextSymbolizer ts = this.sf.createTextSymbolizer();
        ts.setFill((org.opengis.style.Fill)this.createFill(Color.BLACK));
        ts.setLabel(this.literalExpression("Label"));
        ts.setFonts(new Font[]{this.createFont("Lucida Sans", 10.0)});
        return ts;
    }

    public TextSymbolizer createTextSymbolizer(Color color, Font font, String attributeName) throws IllegalFilterException {
        return this.createTextSymbolizer(this.createFill(color), new Font[]{font}, null, this.attributeExpression(attributeName), null, null);
    }

    public TextSymbolizer createTextSymbolizer(Color color, Font[] fonts, String attributeName) throws IllegalFilterException {
        return this.createTextSymbolizer(this.createFill(color), fonts, null, this.attributeExpression(attributeName), null, null);
    }

    public TextSymbolizer createStaticTextSymbolizer(Color color, Font font, String label) {
        return this.createTextSymbolizer(this.createFill(color), new Font[]{font}, null, this.literalExpression(label), null, null);
    }

    public TextSymbolizer createStaticTextSymbolizer(Color color, Font[] fonts, String label) {
        return this.createTextSymbolizer(this.createFill(color), fonts, null, this.literalExpression(label), null, null);
    }

    public TextSymbolizer createTextSymbolizer(Fill fill, Font[] fonts, Halo halo, Expression label, LabelPlacement labelPlacement, String geometryPropertyName) {
        TextSymbolizer ts = this.sf.createTextSymbolizer();
        if (fill != null) {
            ts.setFill((org.opengis.style.Fill)fill);
        }
        if (halo != null) {
            ts.setHalo((org.opengis.style.Halo)halo);
        }
        if (label != null) {
            ts.setLabel(label);
        }
        if (labelPlacement != null) {
            ts.setPlacement(labelPlacement);
        }
        if (geometryPropertyName != null) {
            ts.setGeometryPropertyName(geometryPropertyName);
        }
        if (fonts != null) {
            ts.setFonts(fonts);
        }
        return ts;
    }

    public FeatureTypeStyle createFeatureTypeStyle(Symbolizer symbolizer) {
        return this.createFeatureTypeStyle(null, symbolizer, Double.NaN, Double.NaN);
    }

    public Rule createRule(Symbolizer symbolizer) {
        return this.createRule(symbolizer, Double.NaN, Double.NaN);
    }

    public Rule createRule(Symbolizer[] symbolizers) {
        return this.createRule(symbolizers, Double.NaN, Double.NaN);
    }

    public Rule createRule(Symbolizer symbolizer, double minScaleDenominator, double maxScaleDenominator) {
        return this.createRule(new Symbolizer[]{symbolizer}, minScaleDenominator, maxScaleDenominator);
    }

    public Rule createRule(Symbolizer[] symbolizers, double minScaleDenominator, double maxScaleDenominator) {
        Rule r = this.sf.createRule();
        r.setSymbolizers(symbolizers);
        if (!Double.isNaN(maxScaleDenominator)) {
            r.setMaxScaleDenominator(maxScaleDenominator);
        } else {
            r.setMaxScaleDenominator(Double.POSITIVE_INFINITY);
        }
        if (!Double.isNaN(minScaleDenominator)) {
            r.setMinScaleDenominator(minScaleDenominator);
        } else {
            r.setMinScaleDenominator(0.0);
        }
        return r;
    }

    public FeatureTypeStyle createFeatureTypeStyle(Symbolizer symbolizer, double minScaleDenominator, double maxScaleDenominator) {
        return this.createFeatureTypeStyle(null, symbolizer, minScaleDenominator, maxScaleDenominator);
    }

    public FeatureTypeStyle createFeatureTypeStyle(Symbolizer[] symbolizers, double minScaleDenominator, double maxScaleDenominator) {
        return this.createFeatureTypeStyle(null, symbolizers, minScaleDenominator, maxScaleDenominator);
    }

    public FeatureTypeStyle createFeatureTypeStyle(String featureTypeName, Symbolizer symbolizer) {
        return this.createFeatureTypeStyle(featureTypeName, symbolizer, Double.NaN, Double.NaN);
    }

    public FeatureTypeStyle createFeatureTypeStyle(String featureTypeName, Symbolizer[] symbolizers) {
        return this.createFeatureTypeStyle(featureTypeName, symbolizers, Double.NaN, Double.NaN);
    }

    public FeatureTypeStyle createFeatureTypeStyle(String typeName, Symbolizer symbolizer, double minScaleDenominator, double maxScaleDenominator) {
        return this.createFeatureTypeStyle(typeName, new Symbolizer[]{symbolizer}, minScaleDenominator, maxScaleDenominator);
    }

    public FeatureTypeStyle createFeatureTypeStyle(String typeName, Symbolizer[] symbolizers, double minScaleDenominator, double maxScaleDenominator) {
        Rule r = this.createRule(symbolizers, minScaleDenominator, maxScaleDenominator);
        FeatureTypeStyle fts = this.sf.createFeatureTypeStyle();
        fts.setRules(new Rule[]{r});
        if (typeName != null) {
            fts.setFeatureTypeName(typeName);
        }
        return fts;
    }

    public FeatureTypeStyle createFeatureTypeStyle(String typeName, Rule r) {
        FeatureTypeStyle fts = this.sf.createFeatureTypeStyle();
        fts.setRules(new Rule[]{r});
        if (typeName != null) {
            fts.setFeatureTypeName(typeName);
        }
        return fts;
    }

    public FeatureTypeStyle createFeatureTypeStyle(String typeName, Rule[] rules) {
        FeatureTypeStyle fts = this.sf.createFeatureTypeStyle();
        fts.setRules(rules);
        if (typeName != null) {
            fts.setFeatureTypeName(typeName);
        }
        return fts;
    }

    public Style createStyle(Symbolizer symbolizer) {
        return this.createStyle(null, symbolizer, Double.NaN, Double.NaN);
    }

    public Style createStyle(Symbolizer symbolizer, double minScaleDenominator, double maxScaleDenominator) {
        return this.createStyle(null, symbolizer, minScaleDenominator, maxScaleDenominator);
    }

    public Style createStyle(String typeName, Symbolizer symbolizer) {
        return this.createStyle(typeName, symbolizer, Double.NaN, Double.NaN);
    }

    public Style createStyle(String typeName, Symbolizer symbolizer, double minScaleDenominator, double maxScaleDenominator) {
        FeatureTypeStyle fts = this.createFeatureTypeStyle(typeName, symbolizer, minScaleDenominator, maxScaleDenominator);
        Style style = this.sf.createStyle();
        style.addFeatureTypeStyle(fts);
        return style;
    }

    public Style createStyle() {
        return this.sf.createStyle();
    }

    public Expression colorExpression(Color color) {
        if (color == null) {
            return null;
        }
        String redCode = Integer.toHexString(color.getRed());
        String greenCode = Integer.toHexString(color.getGreen());
        String blueCode = Integer.toHexString(color.getBlue());
        if (redCode.length() == 1) {
            redCode = "0" + redCode;
        }
        if (greenCode.length() == 1) {
            greenCode = "0" + greenCode;
        }
        if (blueCode.length() == 1) {
            blueCode = "0" + blueCode;
        }
        String colorCode = "#" + redCode + greenCode + blueCode;
        return this.ff.literal((Object)colorCode.toUpperCase());
    }

    public Expression literalExpression(double value) {
        return this.ff.literal(value);
    }

    public Expression literalExpression(int value) {
        return this.ff.literal(value);
    }

    public Expression literalExpression(String value) {
        Literal result = null;
        if (value != null) {
            result = this.ff.literal((Object)value);
        }
        return result;
    }

    public Expression literalExpression(Object value) throws IllegalFilterException {
        Literal result = null;
        if (value != null) {
            result = this.ff.literal(value);
        }
        return result;
    }

    public Expression attributeExpression(String attributeName) throws IllegalFilterException {
        return this.ff.property(attributeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Style buildClassifiedStyle(SimpleFeatureCollection fc, String name, String[] colors, SimpleFeatureType schema) throws IllegalFilterException {
        PropertyName value = this.ff.property(name);
        String geomName = schema.getGeometryDescriptor().getLocalName();
        double[] values = new double[fc.size()];
        int count = 0;
        SimpleFeatureIterator it = fc.features();
        try {
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                values[count++] = ((Number)f.getAttribute(name)).doubleValue();
            }
        }
        finally {
            it.close();
        }
        EqualClasses ec = new EqualClasses(colors.length, values);
        double[] breaks = ec.getBreaks();
        Style ret = this.createStyle();
        Rule[] rules = new Rule[colors.length + 1];
        PropertyIsLessThan cf1 = this.ff.less((Expression)value, (Expression)this.ff.literal(breaks[0]));
        LOGGER.fine(cf1.toString());
        rules[0] = this.sf.createRule();
        rules[0].setFilter((Filter)cf1);
        Color c = this.createColor(colors[0]);
        PolygonSymbolizer symb1 = this.createPolygonSymbolizer(c, Color.black, 1.0);
        rules[0].setSymbolizers(new Symbolizer[]{symb1});
        LOGGER.fine("added low class " + breaks[0] + " " + colors[0]);
        for (int i = 1; i < colors.length - 1; ++i) {
            rules[i] = this.sf.createRule();
            PropertyName expr = value;
            Literal lower = this.ff.literal(breaks[i - 1]);
            Literal upper = this.ff.literal(breaks[i]);
            PropertyIsBetween cf = this.ff.between((Expression)expr, (Expression)lower, (Expression)upper);
            LOGGER.fine(cf.toString());
            c = this.createColor(colors[i]);
            LOGGER.fine("color " + c.toString());
            PolygonSymbolizer symb = this.createPolygonSymbolizer(c, Color.black, 1.0);
            rules[i].setSymbolizers(new Symbolizer[]{symb});
            rules[i].setFilter((Filter)cf);
            LOGGER.fine("added class " + breaks[i - 1] + "->" + breaks[i] + " " + colors[i]);
        }
        PropertyIsGreaterThan cf2 = this.ff.greater((Expression)value, (Expression)this.ff.literal(breaks[colors.length - 2]));
        LOGGER.fine(cf2.toString());
        rules[colors.length - 1] = this.sf.createRule();
        rules[colors.length - 1].setFilter((Filter)cf2);
        rules[colors.length - 1].setName(geomName);
        c = this.createColor(colors[colors.length - 1]);
        PolygonSymbolizer symb2 = this.createPolygonSymbolizer(c, Color.black, 1.0);
        rules[colors.length - 1].setSymbolizers(new Symbolizer[]{symb2});
        LOGGER.fine("added upper class " + breaks[colors.length - 2] + "  " + colors[colors.length - 1]);
        rules[colors.length] = this.sf.createRule();
        PolygonSymbolizer elsePoly = this.createPolygonSymbolizer(Color.black, 1.0);
        rules[colors.length].setSymbolizers(new Symbolizer[]{elsePoly});
        rules[colors.length].setElseFilter(true);
        FeatureTypeStyle ft = this.sf.createFeatureTypeStyle(rules);
        ft.setFeatureTypeName("Feature");
        ft.setName(name);
        ret.addFeatureTypeStyle(ft);
        return ret;
    }

    private Color createColor(String text) {
        int i = Integer.decode("0x" + text);
        return Color.decode("" + i);
    }

    public RasterSymbolizer createRasterSymbolizer() {
        return this.sf.getDefaultRasterSymbolizer();
    }

    public RasterSymbolizer createRasterSymbolizer(ColorMap colorMap, double opacity) {
        RasterSymbolizer rs = this.sf.getDefaultRasterSymbolizer();
        rs.setColorMap((org.opengis.style.ColorMap)colorMap);
        rs.setOpacity(this.literalExpression(opacity));
        return rs;
    }

    public ColorMap createColorMap(String[] labels, double[] quantities, Color[] colors, int type) {
        ColorMap colorMap = this.sf.createColorMap();
        colorMap.setType(type);
        if (labels == null || quantities == null || colors == null || labels.length != quantities.length || quantities.length != colors.length) {
            throw new IllegalArgumentException("Labels, quantities and colors arrays should be not null and have the same size");
        }
        for (int i = 0; i < colors.length; ++i) {
            colorMap.addColorMapEntry(this.createColorMapEntry(labels[i], quantities[i], colors[i]));
        }
        return colorMap;
    }

    private ColorMapEntry createColorMapEntry(String label, double quantity, Color color) {
        ColorMapEntry entry = this.sf.createColorMapEntry();
        entry.setQuantity(this.literalExpression(quantity));
        entry.setColor(this.colorExpression(color));
        entry.setOpacity(this.literalExpression((double)color.getAlpha() / 255.0));
        entry.setLabel(label);
        return entry;
    }

    public class EqualClasses {
        int numberClasses;
        double[] breaks;
        double[] collection;

        public EqualClasses(int numberClasses, double[] fc) {
            this.breaks = new double[numberClasses - 1];
            this.setCollection(fc);
            this.setNumberClasses(numberClasses);
        }

        public int getNumberClasses() {
            return this.numberClasses;
        }

        public void setNumberClasses(int numberClasses) {
            int step;
            this.numberClasses = numberClasses;
            if (this.breaks == null) {
                this.breaks = new double[numberClasses - 1];
            }
            Arrays.sort(this.collection);
            int i = step = this.collection.length / numberClasses;
            int j = 0;
            while (j < this.breaks.length) {
                this.breaks[j] = this.collection[i];
                ++j;
                i += step;
            }
        }

        public double[] getBreaks() {
            return this.breaks;
        }

        public void setCollection(double[] collection) {
            this.collection = collection;
        }
    }
}

