/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.AttributeTypeImpl;
import org.geotools.util.Converters;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.feature.type.PropertyType;
import org.opengis.filter.Filter;
import org.xml.sax.helpers.NamespaceSupport;

public class Types {
    public static boolean isValid(Attribute attribute) {
        try {
            Types.validate(attribute.getType(), attribute, attribute.getValue(), false);
            return true;
        }
        catch (IllegalAttributeException invalid) {
            return false;
        }
    }

    public static void validate(Attribute attribute, Object attributeContent) throws IllegalAttributeException {
        Types.validate(attribute.getType(), attribute, attributeContent, false);
    }

    public static void validate(AttributeType type, Attribute attribute, Object attributeContent) throws IllegalAttributeException {
        Types.validate(type, attribute, attributeContent, false);
    }

    protected static void validate(AttributeType type, Attribute attribute, Object attributeContent, boolean isSuper) throws IllegalAttributeException {
        if (type == null) {
            throw new IllegalAttributeException("null type");
        }
        if (attributeContent == null) {
            if (!attribute.isNillable()) {
                throw new IllegalAttributeException(type.getName() + " not nillable");
            }
            return;
        }
        if (type.isIdentified() && attribute.getIdentifier() == null) {
            throw new NullPointerException(type.getName() + " is identified, null id not accepted");
        }
        if (!isSuper) {
            Class<?> clazz = attributeContent.getClass();
            Class binding = type.getBinding();
            if (binding != null && binding != clazz && !binding.isAssignableFrom(clazz)) {
                throw new IllegalAttributeException(clazz.getName() + " is not an acceptable class for " + type.getName() + " as it is not assignable from " + binding);
            }
        }
        if (type.getRestrictions() != null) {
            for (Filter f : type.getRestrictions()) {
                if (f.evaluate((Object)attribute)) continue;
                throw new IllegalAttributeException("Attribute instance (" + attribute.getIdentifier() + ")" + "fails to pass filter: " + f);
            }
        }
        if (type.getSuper() != null) {
            Types.validate(type.getSuper(), attribute, attributeContent, true);
        }
    }

    public static void validate(AttributeDescriptor descriptor, Object value) throws IllegalAttributeException {
        if (descriptor == null) {
            throw new NullPointerException("Attribute descriptor required for validation");
        }
        if (value == null) {
            if (!descriptor.isNillable()) {
                throw new IllegalArgumentException(descriptor.getName() + " requires a non null value");
            }
        } else {
            Types.validate(descriptor.getType(), value, false);
        }
    }

    public static Object parse(AttributeDescriptor descriptor, Object value) throws IllegalArgumentException {
        if (value == null) {
            if (descriptor.isNillable()) {
                return descriptor.getDefaultValue();
            }
        } else {
            Object converted;
            Class target = descriptor.getType().getBinding();
            if (!target.isAssignableFrom(value.getClass()) && (converted = Converters.convert((Object)value, (Class)target)) != null) {
                return converted;
            }
        }
        return value;
    }

    protected static void validate(AttributeType type, Object value, boolean isSuper) throws IllegalAttributeException {
        if (!isSuper) {
            Class<?> clazz = value.getClass();
            Class binding = type.getBinding();
            if (binding != null && !binding.isAssignableFrom(clazz)) {
                throw new IllegalAttributeException(clazz.getName() + " is not an acceptable class for " + type.getName() + " as it is not assignable from " + binding);
            }
        }
        if (type.getRestrictions() != null && type.getRestrictions().size() > 0) {
            for (Filter filter : type.getRestrictions()) {
                if (filter.evaluate(value)) continue;
                throw new IllegalAttributeException(type.getName() + " restriction " + filter + " not met by: " + value);
            }
        }
        if (type.getSuper() != null) {
            Types.validate(type.getSuper(), value, true);
        }
    }

    public static void assertNameAssignable(FeatureType expected, FeatureType actual) {
        String actualName;
        String expectedName = expected.getName().getLocalPart();
        if (!expectedName.equals(actualName = actual.getName().getLocalPart())) {
            throw new IllegalAttributeException("Expected '" + expectedName + "' but was supplied '" + actualName + "'.");
        }
        TreeSet<String> names = new TreeSet<String>();
        for (PropertyDescriptor descriptor : actual.getDescriptors()) {
            names.add(descriptor.getName().getLocalPart());
        }
        for (PropertyDescriptor descriptor : expected.getDescriptors()) {
            expectedName = descriptor.getName().getLocalPart();
            if (names.contains(expectedName)) {
                names.remove(expectedName);
                continue;
            }
            throw new IllegalAttributeException("Expected to find a match for '" + expectedName + "' but was not available remaining names: " + names);
        }
        if (!names.isEmpty()) {
            throw new IllegalAttributeException("Expected to find attributes '" + expectedName + "' but was not available remaining names: " + names);
        }
        for (PropertyDescriptor expectedDescriptor : expected.getDescriptors()) {
            expectedName = expectedDescriptor.getName().getLocalPart();
            PropertyDescriptor actualDescriptor = actual.getDescriptor(expectedName);
            Class expectedBinding = expectedDescriptor.getType().getBinding();
            Class actualBinding = actualDescriptor.getType().getBinding();
            if (actualBinding.isAssignableFrom(expectedBinding)) continue;
            throw new IllegalArgumentException("Expected " + expectedBinding.getSimpleName() + " for " + expectedName + " but was " + actualBinding.getSimpleName());
        }
    }

    public static void assertOrderAssignable(SimpleFeatureType expected, SimpleFeatureType actual) {
        String actualName;
        String expectedName = expected.getName().getLocalPart();
        if (!expectedName.equals(actualName = actual.getName().getLocalPart())) {
            throw new IllegalAttributeException("Expected '" + expectedName + "' but was supplied '" + actualName + "'.");
        }
        if (expected.getAttributeCount() != actual.getAttributeCount()) {
            throw new IllegalAttributeException("Expected " + expected.getAttributeCount() + " attributes, but was supplied " + actual.getAttributeCount());
        }
        for (int i = 0; i < expected.getAttributeCount(); ++i) {
            Class expectedBinding = expected.getDescriptor(i).getType().getBinding();
            Class actualBinding = actual.getDescriptor(i).getType().getBinding();
            if (actualBinding.isAssignableFrom(expectedBinding)) continue;
            String name = expected.getDescriptor(i).getLocalName();
            throw new IllegalArgumentException("Expected " + expectedBinding.getSimpleName() + " for " + name + " but was " + actualBinding.getSimpleName());
        }
    }

    public static Name[] names(ComplexType type) {
        ArrayList<Name> names = new ArrayList<Name>();
        for (AttributeDescriptor ad : type.getDescriptors()) {
            names.add(ad.getName());
        }
        return names.toArray(new Name[names.size()]);
    }

    public static Name typeName(String name) {
        if (name == null) {
            return null;
        }
        return new NameImpl(name);
    }

    public static Name typeName(String namespace, String name) {
        return new NameImpl(namespace, name);
    }

    public static Name typeName(Name name) {
        return new NameImpl(name.getNamespaceURI(), name.getLocalPart());
    }

    public static Name[] toNames(String[] names) {
        if (names == null) {
            return null;
        }
        Name[] attributeNames = new Name[names.length];
        for (int i = 0; i < names.length; ++i) {
            attributeNames[i] = Types.typeName(names[i]);
        }
        return attributeNames;
    }

    public static Name[] toTypeNames(String[] names) {
        if (names == null) {
            return null;
        }
        Name[] typeNames = new Name[names.length];
        for (int i = 0; i < names.length; ++i) {
            typeNames[i] = Types.typeName(names[i]);
        }
        return typeNames;
    }

    public static String[] fromNames(Name[] attributeNames) {
        if (attributeNames == null) {
            return null;
        }
        String[] names = new String[attributeNames.length];
        for (int i = 0; i < attributeNames.length; ++i) {
            names[i] = attributeNames[i].getLocalPart();
        }
        return names;
    }

    public static String[] fromTypeNames(Name[] typeNames) {
        if (typeNames == null) {
            return null;
        }
        String[] names = new String[typeNames.length];
        for (int i = 0; i < typeNames.length; ++i) {
            names[i] = typeNames[i].getLocalPart();
        }
        return names;
    }

    public static Name toTypeName(QName name) {
        if ("".equals(name.getNamespaceURI())) {
            return Types.typeName(name.getLocalPart());
        }
        return Types.typeName(name.getNamespaceURI(), name.getLocalPart());
    }

    public static boolean equals(Name name, QName qName) {
        if (name == null && qName != null) {
            return false;
        }
        if (qName == null && name != null) {
            return false;
        }
        if ("".equals(qName.getNamespaceURI())) {
            if (null != name.getNamespaceURI()) {
                return false;
            }
            return name.getLocalPart().equals(qName.getLocalPart());
        }
        if (null == name.getNamespaceURI() && !"".equals(qName.getNamespaceURI())) {
            return false;
        }
        return name.getNamespaceURI().equals(qName.getNamespaceURI()) && name.getLocalPart().equals(qName.getLocalPart());
    }

    public static Name degloseName(String prefixedName, NamespaceSupport namespaces) throws IllegalArgumentException {
        Name name = null;
        if (prefixedName == null) {
            return null;
        }
        int prefixIdx = prefixedName.lastIndexOf(58);
        if (prefixIdx == -1) {
            return Types.typeName(prefixedName);
        }
        String nsPrefix = prefixedName.substring(0, prefixIdx);
        String localName = prefixedName.substring(prefixIdx + 1);
        String nsUri = namespaces.getURI(nsPrefix);
        if (nsUri == null) {
            throw new IllegalArgumentException("No namespace set: The namespace has not been declared in the app-schema mapping file for name: " + nsPrefix + ":" + localName + " [Check the Namespaces section in the config file] ");
        }
        name = Types.typeName(nsUri, localName);
        return name;
    }

    public static QName toQName(Name featurePath) {
        return Types.toQName(featurePath, null);
    }

    public static QName toQName(Name featurePath, NamespaceSupport ns) {
        QName qName;
        if (featurePath == null) {
            return null;
        }
        String namespace = featurePath.getNamespaceURI();
        String localName = featurePath.getLocalPart();
        if (null == namespace) {
            qName = new QName(localName);
        } else {
            String prefix;
            if (ns != null && (prefix = ns.getPrefix(namespace)) != null) {
                QName qName2 = new QName(namespace, localName, prefix);
                return qName2;
            }
            qName = new QName(namespace, localName);
        }
        return qName;
    }

    public static Name toName(QName name) {
        return Types.toTypeName(name);
    }

    public static Object parse(AttributeType type, Object content) throws IllegalArgumentException {
        AttributeTypeImpl hack;
        Object parsed;
        if (type instanceof AttributeTypeImpl && (parsed = (hack = (AttributeTypeImpl)type).parse(content)) != null) {
            return parsed;
        }
        return content;
    }

    public static void validate(Attribute attribute) throws IllegalAttributeException {
        Types.validate(attribute, attribute.getValue());
    }

    public static void validate(ComplexAttribute attribute) throws IllegalArgumentException {
    }

    public static void validate(ComplexAttribute attribute, Collection content) throws IllegalArgumentException {
    }

    protected static void validate(ComplexType type, ComplexAttribute attribute, Collection content) throws IllegalAttributeException {
        Types.validate((AttributeType)type, (Attribute)attribute, content, false);
        if (content == null) {
            return;
        }
        Collection schema = type.getDescriptors();
        int index = 0;
        for (Attribute att : content) {
            if (att == null) {
                throw new NullPointerException("Attribute at index " + index + " is null. Attributes " + "can't be null. Do you mean Attribute.get() == null?");
            }
            AttributeType attType = att.getType();
            boolean contains = false;
            for (AttributeDescriptor ad : schema) {
                if (!ad.getType().equals(attType)) continue;
                contains = true;
                break;
            }
            if (!contains) {
                throw new IllegalArgumentException("Attribute of type " + attType.getName() + " found at index " + index + " but this type is not allowed by this descriptor");
            }
            ++index;
        }
        if (type.getDescriptors().isEmpty()) {
            if (!content.isEmpty()) {
                throw new IllegalAttributeException(attribute.getDescriptor(), (Object)"Type indicates empty attribute collection, content does not");
            }
            return;
        }
        Types.validateAll(type, attribute, content);
        if (type.getSuper() != null) {
            Types.validate((ComplexType)type.getSuper(), attribute, content);
        }
    }

    private static void validateAll(ComplexType type, ComplexAttribute att, Collection content) throws IllegalAttributeException {
        Types.processAll(type.getDescriptors(), content);
    }

    private static void processAll(Collection all, Collection content) throws IllegalAttributeException {
        ArrayList remaining = new ArrayList(content);
        for (AttributeDescriptor ad : all) {
            int min = ad.getMinOccurs();
            int max = ad.getMaxOccurs();
            int occurences = 0;
            Iterator citr = remaining.iterator();
            while (citr.hasNext()) {
                Attribute a = (Attribute)citr.next();
                if (!a.getName().equals(ad.getName())) continue;
                ++occurences;
                citr.remove();
            }
            if (occurences >= ad.getMinOccurs() && occurences <= ad.getMaxOccurs()) continue;
            throw new IllegalAttributeException(ad, (Object)("Found " + occurences + " of " + ad.getName() + " when type" + "specifies between " + min + " and " + max));
        }
        if (!remaining.isEmpty()) {
            throw new IllegalAttributeException((AttributeDescriptor)remaining.iterator().next(), (Object)("Extra content found beyond the specified in the schema: " + remaining));
        }
    }

    public static boolean isSuperType(PropertyType type, PropertyType parent) {
        while (type.getSuper() != null) {
            if (!(type = type.getSuper()).equals(parent)) continue;
            return true;
        }
        return false;
    }

    public static PropertyDescriptor descriptor(ComplexType type, String name) {
        List match = Types.descriptors(type, name);
        if (match.isEmpty()) {
            return null;
        }
        return (PropertyDescriptor)match.get(0);
    }

    public static PropertyDescriptor descriptor(ComplexType type, String name, String namespace) {
        return Types.descriptor(type, (Name)new NameImpl(namespace, name));
    }

    public static PropertyDescriptor descriptor(ComplexType type, Name name) {
        List match = Types.descriptors(type, name);
        if (match.isEmpty()) {
            return null;
        }
        return (PropertyDescriptor)match.get(0);
    }

    public static List descriptors(ComplexType type, String name) {
        AttributeType superType;
        if (name == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<PropertyDescriptor> match = new ArrayList<PropertyDescriptor>();
        for (PropertyDescriptor descriptor : type.getDescriptors()) {
            String localPart = descriptor.getName().getLocalPart();
            if (!name.equals(localPart)) continue;
            match.add(descriptor);
        }
        if (match.size() == 0 && (superType = type.getSuper()) instanceof ComplexType) {
            List superDescriptors = Types.descriptors((ComplexType)superType, name);
            match.addAll(superDescriptors);
        }
        return match;
    }

    public static List descriptors(ComplexType type, Name name) {
        AttributeType superType;
        if (name == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<PropertyDescriptor> match = new ArrayList<PropertyDescriptor>();
        for (PropertyDescriptor descriptor : type.getDescriptors()) {
            Name descriptorName = descriptor.getName();
            if (!name.equals(descriptorName)) continue;
            match.add(descriptor);
        }
        if (match.size() == 0 && (superType = type.getSuper()) instanceof ComplexType) {
            List superDescriptors = Types.descriptors((ComplexType)superType, name);
            match.addAll(superDescriptors);
        }
        return match;
    }

    public static List<PropertyDescriptor> descriptors(ComplexType type) {
        ArrayList<PropertyDescriptor> children = new ArrayList<PropertyDescriptor>();
        ComplexType loopType = type;
        while (loopType != null) {
            children.addAll(loopType.getDescriptors());
            loopType = loopType.getSuper() instanceof ComplexType ? (ComplexType)loopType.getSuper() : null;
        }
        return children;
    }

    public static PropertyDescriptor findDescriptor(ComplexType parentType, Name name) {
        List<PropertyDescriptor> descriptors = Types.descriptors(parentType);
        for (PropertyDescriptor d : descriptors) {
            if (!d.getName().equals(name)) continue;
            return d;
        }
        Iterator<PropertyDescriptor> it = descriptors.iterator();
        while (it.hasNext()) {
            List substitutionGroup = (List)it.next().getUserData().get("substitutionGroup");
            if (substitutionGroup == null) continue;
            for (AttributeDescriptor d : substitutionGroup) {
                if (!d.getName().equals(name)) continue;
                return d;
            }
        }
        return null;
    }

    public static PropertyDescriptor findDescriptor(ComplexType parentType, String name) {
        List<PropertyDescriptor> descriptors = Types.descriptors(parentType);
        for (PropertyDescriptor d : descriptors) {
            if (!d.getName().getLocalPart().equals(name)) continue;
            return d;
        }
        Iterator<PropertyDescriptor> it = descriptors.iterator();
        while (it.hasNext()) {
            List substitutionGroup = (List)it.next().getUserData().get("substitutionGroup");
            if (substitutionGroup == null) continue;
            for (AttributeDescriptor d : substitutionGroup) {
                if (!d.getName().getLocalPart().equals(name)) continue;
                return d;
            }
        }
        return null;
    }
}

