/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.io.IOException;
import java.util.Iterator;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.sort.SortedFeatureIterator;
import org.geotools.data.store.FeatureIteratorIterator;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.sort.SortBy;

public class SortedSimpleFeatureCollection
extends DecoratingSimpleFeatureCollection {
    private SortBy[] sort;

    public SortedSimpleFeatureCollection(SimpleFeatureCollection delegate, SortBy[] sort) {
        super(delegate);
        this.sort = sort;
    }

    @Override
    public SimpleFeatureIterator features() {
        try {
            SimpleFeatureIterator features = this.delegate.features();
            if (this.sort != null) {
                features = new SortedFeatureIterator(features, this.getSchema(), this.sort, -1);
            }
            return features;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator iterator() {
        return new FeatureIteratorIterator(this.features());
    }

    @Override
    public void close(FeatureIterator<SimpleFeature> close) {
        close.close();
    }

    @Override
    public void close(Iterator<SimpleFeature> close) {
        FeatureIteratorIterator fii = (FeatureIteratorIterator)close;
        this.delegate.close(fii.getDelegate());
    }
}

