/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.util.ProgressListener;

class SimpleFeatureCollectionBridge
implements SimpleFeatureCollection {
    private FeatureCollection<SimpleFeatureType, SimpleFeature> collection;

    public SimpleFeatureCollectionBridge(FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection) {
        if (featureCollection == null) {
            throw new NullPointerException("FeatureCollection required");
        }
        if (featureCollection instanceof SimpleFeatureCollection) {
            throw new IllegalArgumentException("Already a SimpleFeatureCollection");
        }
        if (featureCollection == null) {
            throw new NullPointerException("FeatureCollection required");
        }
        this.collection = featureCollection;
    }

    public SimpleFeatureIterator features() {
        final FeatureIterator features = this.collection.features();
        return new SimpleFeatureIterator(){

            public SimpleFeature next() throws NoSuchElementException {
                return (SimpleFeature)features.next();
            }

            public boolean hasNext() {
                return features.hasNext();
            }

            public void close() {
                features.close();
            }
        };
    }

    public SimpleFeatureCollection sort(SortBy order) {
        return new SimpleFeatureCollectionBridge((FeatureCollection<SimpleFeatureType, SimpleFeature>)this.collection.sort(order));
    }

    public SimpleFeatureCollection subCollection(Filter filter) {
        return new SimpleFeatureCollectionBridge((FeatureCollection<SimpleFeatureType, SimpleFeature>)this.collection.subCollection(filter));
    }

    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        this.collection.accepts(visitor, progress);
    }

    public boolean add(SimpleFeature feature) {
        return this.collection.add((Feature)feature);
    }

    public boolean addAll(Collection<? extends SimpleFeature> toAdd) {
        return this.collection.addAll(toAdd);
    }

    public boolean addAll(FeatureCollection<? extends SimpleFeatureType, ? extends SimpleFeature> resource) {
        return this.collection.addAll(resource);
    }

    public void addListener(CollectionListener listener) throws NullPointerException {
        this.collection.addListener(listener);
    }

    public void clear() {
        this.collection.clear();
    }

    public void close(FeatureIterator<SimpleFeature> close) {
        this.collection.close(close);
    }

    public void close(Iterator<SimpleFeature> close) {
        this.collection.close(close);
    }

    public boolean contains(Object o) {
        return this.collection.contains(o);
    }

    public boolean containsAll(Collection<?> o) {
        return this.collection.containsAll(o);
    }

    public ReferencedEnvelope getBounds() {
        return this.collection.getBounds();
    }

    public String getID() {
        return this.collection.getID();
    }

    public SimpleFeatureType getSchema() {
        return (SimpleFeatureType)this.collection.getSchema();
    }

    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    public Iterator<SimpleFeature> iterator() {
        return this.collection.iterator();
    }

    public void purge() {
        this.collection.purge();
    }

    public boolean remove(Object o) {
        return this.collection.remove(o);
    }

    public boolean removeAll(Collection<?> c) {
        return this.collection.removeAll(c);
    }

    public void removeListener(CollectionListener listener) throws NullPointerException {
        this.collection.removeListener(listener);
    }

    public boolean retainAll(Collection<?> c) {
        return this.collection.retainAll(c);
    }

    public int size() {
        return this.collection.size();
    }

    public Object[] toArray() {
        return this.collection.toArray();
    }

    public <O> O[] toArray(O[] a) {
        return this.collection.toArray((Object[])a);
    }
}

