/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.visitor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Stroke;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbol;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.geotools.styling.visitor.Measure;
import org.geotools.styling.visitor.RescalingMode;
import org.geotools.util.Converters;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

public class RescaleStyleVisitor
extends DuplicatingStyleVisitor {
    protected Expression scale;
    protected Unit<Length> defaultUnit;

    public RescaleStyleVisitor(double scale) {
        this(CommonFactoryFinder.getFilterFactory2(null), scale);
    }

    public RescaleStyleVisitor(Expression scale) {
        this(CommonFactoryFinder.getFilterFactory2(null), scale);
    }

    public RescaleStyleVisitor(FilterFactory2 filterFactory, double scale) {
        this(filterFactory, (Expression)filterFactory.literal(scale));
    }

    public RescaleStyleVisitor(FilterFactory2 filterFactory, Expression scale) {
        super(CommonFactoryFinder.getStyleFactory(null), filterFactory);
        this.scale = scale;
    }

    protected Expression rescale(Expression expr) {
        if (expr == null) {
            return null;
        }
        if (expr == Expression.NIL) {
            return Expression.NIL;
        }
        Measure m = new Measure(expr, this.defaultUnit);
        return RescalingMode.KeepUnits.rescaleToExpression(this.scale, m);
    }

    protected List<Expression> rescale(List<Expression> expressions) {
        if (expressions == null || expressions.isEmpty()) {
            return expressions;
        }
        ArrayList<Expression> rescaled = new ArrayList<Expression>(expressions.size());
        for (Expression expression : expressions) {
            rescaled.add(this.rescale(expression));
        }
        return rescaled;
    }

    protected List<Expression> rescaleDashArray(List<Expression> expressions) {
        if (expressions == null || expressions.isEmpty()) {
            return expressions;
        }
        Expression rescaleToExpression = this.rescale((Expression)this.ff.literal(1));
        String data = ((Literal)rescaleToExpression).getValue().toString();
        boolean evaluate = rescaleToExpression instanceof Literal && Character.isDigit(data.charAt(data.length() - 1));
        ArrayList<Expression> rescaled = new ArrayList<Expression>(expressions.size());
        for (Expression expression : expressions) {
            Function rescale = this.ff.function("listMultiply", new Expression[]{rescaleToExpression, expression});
            if (expression instanceof Literal && evaluate) {
                rescaled.add((Expression)this.ff.literal(rescale.evaluate(null)));
                continue;
            }
            rescaled.add((Expression)rescale);
        }
        return rescaled;
    }

    @Override
    public void visit(Stroke stroke) {
        Stroke copy = this.sf.getDefaultStroke();
        copy.setColor(this.copy(stroke.getColor()));
        copy.setDashArray(this.rescaleDashArray(stroke.dashArray()));
        copy.setDashOffset(this.rescale(stroke.getDashOffset()));
        copy.setGraphicFill((org.opengis.style.Graphic)this.copy(stroke.getGraphicFill()));
        copy.setGraphicStroke((org.opengis.style.Graphic)this.copy(stroke.getGraphicStroke()));
        copy.setLineCap(this.copy(stroke.getLineCap()));
        copy.setLineJoin(this.copy(stroke.getLineJoin()));
        copy.setOpacity(this.copy(stroke.getOpacity()));
        copy.setWidth(this.rescale(stroke.getWidth()));
        this.pages.push(copy);
    }

    @Override
    public void visit(Graphic gr) {
        Graphic copy = null;
        Displacement displacementCopy = null;
        if (gr.getDisplacement() != null) {
            gr.getDisplacement().accept((StyleVisitor)this);
            displacementCopy = (Displacement)this.pages.pop();
        }
        AnchorPoint anchorCopy = null;
        if (gr.getAnchorPoint() != null) {
            gr.getAnchorPoint().accept((StyleVisitor)this);
            anchorCopy = (AnchorPoint)this.pages.pop();
        }
        ExternalGraphic[] externalGraphics = gr.getExternalGraphics();
        ExternalGraphic[] externalGraphicsCopy = new ExternalGraphic[externalGraphics.length];
        int length = externalGraphics.length;
        for (int i = 0; i < length; ++i) {
            externalGraphicsCopy[i] = this.copy(externalGraphics[i]);
        }
        Mark[] marks = gr.getMarks();
        Mark[] marksCopy = new Mark[marks.length];
        length = marks.length;
        for (int i = 0; i < length; ++i) {
            marksCopy[i] = this.copy(marks[i]);
        }
        Expression opacityCopy = this.copy(gr.getOpacity());
        Expression rotationCopy = this.copy(gr.getRotation());
        Expression sizeCopy = this.rescaleGraphicSize(gr);
        Symbol[] symbols = gr.getSymbols();
        length = symbols.length;
        Symbol[] symbolCopys = new Symbol[length];
        for (int i = 0; i < length; ++i) {
            symbolCopys[i] = this.copy(symbols[i]);
        }
        copy = this.sf.createDefaultGraphic();
        copy.setDisplacement((org.opengis.style.Displacement)displacementCopy);
        copy.setAnchorPoint((org.opengis.style.AnchorPoint)anchorCopy);
        copy.setExternalGraphics(externalGraphicsCopy);
        copy.setMarks(marksCopy);
        copy.setOpacity(opacityCopy);
        copy.setRotation(rotationCopy);
        copy.setSize(sizeCopy);
        copy.setSymbols(symbolCopys);
        this.pages.push(copy);
    }

    protected Expression rescaleGraphicSize(Graphic gr) {
        return this.rescale(gr.getSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(TextSymbolizer text) {
        this.defaultUnit = text.getUnitOfMeasure();
        try {
            super.visit(text);
            TextSymbolizer copy = (TextSymbolizer)this.pages.peek();
            for (Font font : copy.fonts()) {
                if (font == null) continue;
                font.setSize(this.rescale(font.getSize()));
            }
            LabelPlacement placement = copy.getLabelPlacement();
            if (placement instanceof PointPlacement) {
                PointPlacement pointPlacement = (PointPlacement)placement;
                Displacement disp = pointPlacement.getDisplacement();
                if (disp != null) {
                    disp.setDisplacementX(this.rescale(disp.getDisplacementX()));
                    disp.setDisplacementY(this.rescale(disp.getDisplacementY()));
                    pointPlacement.setDisplacement((org.opengis.style.Displacement)disp);
                }
            } else if (placement instanceof LinePlacement) {
                LinePlacement linePlacement = (LinePlacement)placement;
                linePlacement.setGap(this.rescale(linePlacement.getGap()));
                linePlacement.setInitialGap(this.rescale(linePlacement.getInitialGap()));
                linePlacement.setPerpendicularOffset(this.rescale(linePlacement.getPerpendicularOffset()));
            }
            copy.setLabelPlacement((org.opengis.style.LabelPlacement)placement);
            if (copy.getHalo() != null) {
                copy.getHalo().setRadius(this.rescale(copy.getHalo().getRadius()));
            }
            Map options = copy.getOptions();
            this.rescaleOption((Map<String, String>)options, "spaceAround", 0);
            this.rescaleOption((Map<String, String>)options, "maxDisplacement", 0);
            this.rescaleOption((Map<String, String>)options, "minGroupDistance", -1);
            this.rescaleOption((Map<String, String>)options, "repeat", 0);
            this.rescaleOption((Map<String, String>)options, "autoWrap", 0);
            this.rescaleArrayOption(options, "graphic-margin", 0);
        }
        finally {
            this.defaultUnit = null;
        }
    }

    @Override
    public void visit(Symbolizer sym) {
        this.defaultUnit = sym.getUnitOfMeasure();
        try {
            super.visit(sym);
        }
        finally {
            this.defaultUnit = null;
        }
    }

    @Override
    public void visit(PointSymbolizer sym) {
        this.defaultUnit = sym.getUnitOfMeasure();
        try {
            super.visit(sym);
        }
        finally {
            this.defaultUnit = null;
        }
    }

    @Override
    public void visit(LineSymbolizer sym) {
        this.defaultUnit = sym.getUnitOfMeasure();
        try {
            super.visit(sym);
            LineSymbolizer copy = (LineSymbolizer)this.pages.peek();
            copy.setPerpendicularOffset(this.rescale(copy.getPerpendicularOffset()));
        }
        finally {
            this.defaultUnit = null;
        }
    }

    @Override
    public void visit(PolygonSymbolizer sym) {
        this.defaultUnit = sym.getUnitOfMeasure();
        try {
            super.visit(sym);
            PolygonSymbolizer copy = (PolygonSymbolizer)this.pages.peek();
            this.rescaleArrayOption(copy.getOptions(), "graphic-margin", 0);
        }
        finally {
            this.defaultUnit = null;
        }
    }

    @Override
    public void visit(RasterSymbolizer sym) {
        this.defaultUnit = sym.getUnitOfMeasure();
        try {
            super.visit(sym);
        }
        finally {
            this.defaultUnit = null;
        }
    }

    protected void rescaleOption(Map<String, String> options, String key, double defaultValue) {
        double scaleFactor = (Double)this.scale.evaluate(null, Double.class);
        if (options.get(key) != null) {
            double rescaled = (Double)Converters.convert((Object)options.get(key), Double.class) * scaleFactor;
            options.put(key, String.valueOf(rescaled));
        } else if (defaultValue != 0.0) {
            options.put(key, String.valueOf(defaultValue * scaleFactor));
        }
    }

    protected void rescaleOption(Map<String, String> options, String key, int defaultValue) {
        double scaleFactor = (Double)this.scale.evaluate(null, Double.class);
        if (options.get(key) != null) {
            int rescaled = (int)Math.round((Double)Converters.convert((Object)options.get(key), Double.class) * scaleFactor);
            options.put(key, String.valueOf(rescaled));
        } else if (defaultValue != 0) {
            options.put(key, String.valueOf((int)Math.round((double)defaultValue * scaleFactor)));
        }
    }

    protected void rescaleArrayOption(Map<String, String> options, String key, int defaultValue) {
        double scaleFactor = (Double)this.scale.evaluate(null, Double.class);
        if (options.get(key) != null) {
            String strValue = options.get(key);
            String[] splitted = strValue.split("\\s+");
            StringBuilder sb = new StringBuilder();
            for (String value : splitted) {
                double rescaled = (int)Math.round(Double.parseDouble(value) * scaleFactor);
                sb.append((int)rescaled).append(" ");
            }
            sb.setLength(sb.length() - 1);
            options.put(key, sb.toString());
        } else if (defaultValue != 0) {
            options.put(key, String.valueOf((int)Math.round((double)defaultValue * scaleFactor)));
        }
    }
}

