/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.WorldVanDerGrintenI;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFactory;
import org.locationtech.jts.geom.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WorldVanDerGrintenIHandlerFactory
implements ProjectionHandlerFactory {
    @Override
    public ProjectionHandler getHandler(ReferencedEnvelope renderingEnvelope, CoordinateReferenceSystem sourceCrs, boolean wrap, int maxWraps) throws FactoryException {
        if (renderingEnvelope == null) {
            return null;
        }
        MapProjection mapProjection = CRS.getMapProjection((CoordinateReferenceSystem)renderingEnvelope.getCoordinateReferenceSystem());
        if (mapProjection instanceof WorldVanDerGrintenI) {
            ReferencedEnvelope validArea = new ReferencedEnvelope(-1.7976931348623157E308, Double.MAX_VALUE, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            return new ProjectionHandler(sourceCrs, (Envelope)validArea, renderingEnvelope);
        }
        return null;
    }
}

