/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.projection.LambertAzimuthalEqualArea;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFactory;
import org.locationtech.jts.geom.Envelope;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class LambertAzimuthalEqualAreaHandlerFactory
implements ProjectionHandlerFactory {
    @Override
    public ProjectionHandler getHandler(ReferencedEnvelope renderingEnvelope, CoordinateReferenceSystem sourceCrs, boolean wrap, int maxWraps) throws FactoryException {
        if (renderingEnvelope == null) {
            return null;
        }
        MapProjection mapProjection = CRS.getMapProjection((CoordinateReferenceSystem)renderingEnvelope.getCoordinateReferenceSystem());
        if (mapProjection instanceof LambertAzimuthalEqualArea) {
            ParameterValueGroup params = mapProjection.getParameterValues();
            double latitudeOfCenter = params.parameter(LambertAzimuthalEqualArea.Provider.LATITUDE_OF_CENTRE.getName().getCode()).doubleValue();
            double longitudeOfCenter = params.parameter(LambertAzimuthalEqualArea.Provider.LONGITUDE_OF_CENTRE.getName().getCode()).doubleValue();
            ReferencedEnvelope validArea = latitudeOfCenter > 0.0 ? new ReferencedEnvelope(-180.0, 180.0, 0.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84) : (latitudeOfCenter < 0.0 ? new ReferencedEnvelope(-180.0, 180.0, -90.0, 0.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84) : new ReferencedEnvelope(longitudeOfCenter - 90.0, longitudeOfCenter + 90.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
            return new ProjectionHandler(sourceCrs, (Envelope)validArea, renderingEnvelope);
        }
        return null;
    }
}

