/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts.coordinatesequence;

import org.geotools.geometry.jts.CoordinateSequenceTransformer;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class InPlaceCoordinateSequenceTransformer
implements CoordinateSequenceTransformer {
    FlyWeightDirectPosition start = new FlyWeightDirectPosition(2);

    public CoordinateSequence transform(CoordinateSequence cs, MathTransform transform) throws TransformException {
        if (cs instanceof PackedCoordinateSequence) {
            return this.transformInternal((PackedCoordinateSequence)cs, transform);
        }
        throw new TransformException(cs.getClass().getName() + " is not a implementation that is known to be transformable in place");
    }

    private CoordinateSequence transformInternal(PackedCoordinateSequence sequence, MathTransform transform) throws TransformException {
        this.start.setSequence(sequence);
        for (int i = 0; i < sequence.size(); ++i) {
            this.start.setOffset(i);
            try {
                transform.transform((DirectPosition)this.start, (DirectPosition)this.start);
                continue;
            }
            catch (MismatchedDimensionException e) {
                throw new TransformException("", (Throwable)e);
            }
        }
        return sequence;
    }

    private class FlyWeightDirectPosition
    implements DirectPosition {
        PackedCoordinateSequence sequence;
        int offset = 0;
        private int dimension;

        public FlyWeightDirectPosition(int dim) {
            this.dimension = dim;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public void setSequence(PackedCoordinateSequence sequence) {
            this.sequence = sequence;
        }

        public int getDimension() {
            return this.dimension;
        }

        @Deprecated
        public double[] getCoordinates() {
            return this.getCoordinate();
        }

        public double[] getCoordinate() {
            return new double[]{this.sequence.getX(this.offset), this.sequence.getY(this.offset), this.sequence.getOrdinate(this.offset, 2)};
        }

        public double getOrdinate(int arg0) throws IndexOutOfBoundsException {
            return this.sequence.getOrdinate(this.offset, arg0);
        }

        public void setOrdinate(int arg0, double arg1) throws IndexOutOfBoundsException {
            this.sequence.setOrdinate(this.offset, arg0, arg1);
        }

        public CoordinateReferenceSystem getCoordinateReferenceSystem() {
            throw new UnsupportedOperationException();
        }

        public FlyWeightDirectPosition clone() {
            throw new UnsupportedOperationException();
        }

        public DirectPosition getPosition() {
            return this;
        }

        public DirectPosition getDirectPosition() {
            return this;
        }
    }
}

