package org.geotools.filter.function;

/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 *
 *    (C) 2005-2008, Open Source Geospatial Foundation (OSGeo)
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation;
 *    version 2.1 of the License.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 */

// this was autogenerated and then hand modified to implement better support for geometry
// transformations in SLD

import static org.geotools.filter.capability.FunctionNameImpl.parameter;

import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.filter.capability.FunctionName;

/** @source $URL$ */
public class FilterFunction_buffer extends FunctionExpressionImpl
        implements GeometryTransformation {

    public static FunctionName NAME =
            new FunctionNameImpl(
                    "buffer",
                    parameter("buffer", Geometry.class),
                    parameter("geometry", Geometry.class),
                    parameter("distance", Number.class));

    public FilterFunction_buffer() {
        super(NAME);
    }

    public Object evaluate(Object feature) {
        Geometry arg0;
        double arg1;

        try { // attempt to get value and perform conversion
            arg0 = getExpression(0).evaluate(feature, Geometry.class);
        } catch (Exception e) // probably a type error
        {
            throw new IllegalArgumentException(
                    "Filter Function problem for function buffer argument #0 - expected type Geometry");
        }

        try { // attempt to get value and perform conversion
            arg1 = (getExpression(1).evaluate(feature, Double.class)).doubleValue();
        } catch (Exception e) // probably a type error
        {
            throw new IllegalArgumentException(
                    "Filter Function problem for function buffer argument #1 - expected type double");
        }

        return (StaticGeometry.buffer(arg0, arg1));
    }

    /**
     * Returns an expanded rendering envelope if the buffering size is not using feature attributes.
     * If the buffering size is feature dependent the user will have to expand the rendering area
     * via the renderer buffer parameter
     */
    public ReferencedEnvelope invert(ReferencedEnvelope renderingEnvelope) {
        Double buffer = getExpression(1).evaluate(null, Double.class);
        if (buffer == null || buffer <= 0.0) {
            return null;
        }

        Envelope bufferedEnvelope =
                JTS.toGeometry((Envelope) renderingEnvelope).buffer(buffer).getEnvelopeInternal();
        return new ReferencedEnvelope(
                bufferedEnvelope, renderingEnvelope.getCoordinateReferenceSystem());
    }
}
