/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.styling.DescriptionImpl;
import org.geotools.styling.Graphic;
import org.geotools.styling.Rule;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbolizer;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.Utilities;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.metadata.citation.OnLineResource;
import org.opengis.style.Description;
import org.opengis.style.GraphicLegend;
import org.opengis.util.Cloneable;
import org.opengis.util.InternationalString;

public class RuleImpl
implements Rule,
Cloneable {
    private List<Symbolizer> symbolizers = new ArrayList<Symbolizer>();
    private List<Graphic> legends = new ArrayList<Graphic>();
    private String name;
    private DescriptionImpl description = new DescriptionImpl();
    private Filter filter = null;
    private boolean hasElseFilter = false;
    private double maxScaleDenominator = Double.POSITIVE_INFINITY;
    private double minScaleDenominator = 0.0;
    private OnLineResource online = null;

    protected RuleImpl() {
    }

    protected RuleImpl(Symbolizer[] symbolizers) {
        this.symbolizers.addAll(Arrays.asList(symbolizers));
    }

    protected RuleImpl(Symbolizer[] symbolizers, Description desc, Graphic[] legends, String name, Filter filter, boolean isElseFilter, double maxScale, double minScale) {
        this.setSymbolizers(symbolizers);
        this.description.setAbstract(desc.getAbstract());
        this.description.setTitle(desc.getTitle());
        this.setLegendGraphic(legends);
        this.name = name;
        this.filter = filter;
        this.hasElseFilter = isElseFilter;
        this.maxScaleDenominator = maxScale;
        this.minScaleDenominator = minScale;
    }

    public RuleImpl(org.opengis.style.Rule rule) {
        this.symbolizers = new ArrayList<Symbolizer>();
        for (org.opengis.style.Symbolizer sym : rule.symbolizers()) {
            if (!(sym instanceof Symbolizer)) continue;
            this.symbolizers.add((Symbolizer)sym);
        }
        if (rule.getDescription() != null && rule.getDescription().getTitle() != null) {
            this.description.setTitle(rule.getDescription().getTitle());
        }
        if (rule.getDescription() != null && rule.getDescription().getAbstract() != null) {
            this.description.setTitle(rule.getDescription().getAbstract());
        }
        if (rule.getLegend() instanceof Graphic) {
            Graphic graphic = (Graphic)rule.getLegend();
            this.setLegendGraphic(new Graphic[]{graphic});
        }
        this.name = rule.getName();
        this.filter = rule.getFilter();
        this.hasElseFilter = rule.isElseFilter();
        this.maxScaleDenominator = rule.getMaxScaleDenominator();
        this.minScaleDenominator = rule.getMinScaleDenominator();
    }

    public Graphic[] getLegendGraphic() {
        return this.legends.toArray(new Graphic[0]);
    }

    @Deprecated
    public void addLegendGraphic(Graphic graphic) {
        this.legends.add(graphic);
    }

    @Deprecated
    public void setLegendGraphic(Graphic[] graphics) {
        List<Graphic> graphicList = Arrays.asList(graphics);
        this.legends = new ArrayList<Graphic>(graphicList);
    }

    public GraphicLegend getLegend() {
        if (this.legends.isEmpty()) {
            return null;
        }
        return (GraphicLegend)this.legends.get(0);
    }

    public void setLegend(GraphicLegend legend) {
        this.legends.clear();
        this.legends.add((Graphic)legend);
    }

    public List<Symbolizer> symbolizers() {
        return this.symbolizers;
    }

    @Deprecated
    public void addSymbolizer(Symbolizer symb) {
        this.symbolizers.add(symb);
    }

    @Deprecated
    public void setSymbolizers(Symbolizer[] syms) {
        List<Symbolizer> symbols = Arrays.asList(syms);
        this.symbolizers = new ArrayList<Symbolizer>(symbols);
    }

    @Deprecated
    public Symbolizer[] getSymbolizers() {
        Symbolizer[] ret = new Symbolizer[this.symbolizers.size()];
        int n = this.symbolizers.size();
        for (int i = 0; i < n; ++i) {
            ret[i] = this.symbolizers.get(i);
        }
        return ret;
    }

    public DescriptionImpl getDescription() {
        return this.description;
    }

    public void setDescription(Description description) {
        this.description = DescriptionImpl.cast(description);
    }

    public String getName() {
        return this.name;
    }

    public String getAbstract() {
        if (this.description == null || this.description.getAbstract() == null) {
            return null;
        }
        return this.description.getAbstract().toString();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAbstract(String abstractStr) {
        this.description.setAbstract((InternationalString)(abstractStr != null ? new SimpleInternationalString(abstractStr) : null));
    }

    public String getTitle() {
        if (this.description == null || this.description.getTitle() == null) {
            return null;
        }
        return this.description.getTitle().toString();
    }

    public void setTitle(String title) {
        this.description.setTitle((InternationalString)(title != null ? new SimpleInternationalString(title) : null));
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public boolean isElseFilter() {
        return this.hasElseFilter;
    }

    @Deprecated
    public boolean hasElseFilter() {
        return this.hasElseFilter;
    }

    public void setIsElseFilter(boolean flag) {
        this.hasElseFilter = flag;
    }

    public void setElseFilter(boolean defaultb) {
        this.hasElseFilter = defaultb;
    }

    @Deprecated
    public void setHasElseFilter() {
        this.hasElseFilter = true;
    }

    public double getMaxScaleDenominator() {
        return this.maxScaleDenominator;
    }

    public void setMaxScaleDenominator(double maxScaleDenominator) {
        this.maxScaleDenominator = maxScaleDenominator;
    }

    public double getMinScaleDenominator() {
        return this.minScaleDenominator;
    }

    public void setMinScaleDenominator(double minScaleDenominator) {
        this.minScaleDenominator = minScaleDenominator;
    }

    public Object accept(org.opengis.style.StyleVisitor visitor, Object data) {
        return visitor.visit((org.opengis.style.Rule)this, data);
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((Rule)this);
    }

    public Object clone() {
        try {
            RuleImpl clone = (RuleImpl)super.clone();
            clone.name = this.name;
            clone.description.setAbstract(this.description.getAbstract());
            clone.description.setTitle(this.description.getTitle());
            if (this.filter == null) {
                clone.filter = null;
            } else {
                DuplicatingFilterVisitor visitor = new DuplicatingFilterVisitor();
                clone.filter = (Filter)this.filter.accept((FilterVisitor)visitor, (Object)CommonFactoryFinder.getFilterFactory2(null));
            }
            clone.hasElseFilter = this.hasElseFilter;
            clone.legends = new ArrayList<Graphic>(this.legends);
            clone.symbolizers = new ArrayList<Symbolizer>(this.symbolizers);
            clone.maxScaleDenominator = this.maxScaleDenominator;
            clone.minScaleDenominator = this.minScaleDenominator;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("This will never happen", e);
        }
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        result = 1000003 * result + this.symbolizers.hashCode();
        result = 1000003 * result + this.legends.hashCode();
        if (this.name != null) {
            result = 1000003 * result + this.name.hashCode();
        }
        if (this.description != null) {
            result = 1000003 * result + this.description.hashCode();
        }
        if (this.filter != null) {
            result = 1000003 * result + this.filter.hashCode();
        }
        result = 1000003 * result + (this.hasElseFilter ? 1 : 0);
        long temp = Double.doubleToLongBits(this.maxScaleDenominator);
        result = 1000003 * result + (int)(temp >>> 32);
        result = 1000003 * result + (int)(temp & 0xFFFFFFFFFFFFFFFFL);
        temp = Double.doubleToLongBits(this.minScaleDenominator);
        result = 1000003 * result + (int)(temp >>> 32);
        result = 1000003 * result + (int)(temp & 0xFFFFFFFFFFFFFFFFL);
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof RuleImpl) {
            RuleImpl other = (RuleImpl)oth;
            return Utilities.equals((Object)this.name, (Object)other.name) && Utilities.equals((Object)this.description, (Object)other.description) && Utilities.equals((Object)this.filter, (Object)other.filter) && this.hasElseFilter == other.hasElseFilter && Utilities.equals(this.legends, other.legends) && Utilities.equals(this.symbolizers, other.symbolizers) && Double.doubleToLongBits(this.maxScaleDenominator) == Double.doubleToLongBits(other.maxScaleDenominator) && Double.doubleToLongBits(this.minScaleDenominator) == Double.doubleToLongBits(other.minScaleDenominator);
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<RuleImpl");
        if (this.name != null) {
            buf.append(":");
            buf.append(this.name);
        }
        buf.append("> ");
        buf.append(this.filter);
        if (this.symbolizers != null) {
            buf.append("\n");
            for (Symbolizer symbolizer : this.symbolizers) {
                buf.append("\t");
                buf.append(symbolizer);
                buf.append("\n");
            }
        }
        return buf.toString();
    }

    public OnLineResource getOnlineResource() {
        return this.online;
    }

    public void setOnlineResource(OnLineResource online) {
        this.online = online;
    }

    static RuleImpl cast(org.opengis.style.Rule rule) {
        if (rule == null) {
            return null;
        }
        if (rule instanceof RuleImpl) {
            return (RuleImpl)rule;
        }
        RuleImpl copy = new RuleImpl(rule);
        return copy;
    }
}

