/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.LiteralExpression;
import org.geotools.util.ProgressListener;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

public abstract class ClassificationFunction
extends DefaultExpression
implements FunctionExpression {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.filter.function");
    FunctionName name;
    List params = new ArrayList(2);
    Literal fallback;
    ProgressListener progress;

    public ClassificationFunction(FunctionName name) {
        this.name = name;
        this.expressionType = (short)114;
    }

    public int getArgCount() {
        return this.name.getArgumentNames().size();
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Function)this, extraData);
    }

    @Override
    public Object evaluate(SimpleFeature feature) {
        return this.evaluate((Object)feature);
    }

    @Override
    public abstract Object evaluate(Object var1);

    public void setFallbackValue(Literal fallback) {
        this.fallback = fallback;
    }

    public Literal getFallbackValue() {
        return this.fallback;
    }

    public Expression[] getArgs() {
        List parameters = this.getParameters();
        return parameters.toArray(new Expression[parameters.size()]);
    }

    public void setArgs(Expression[] args) {
        ArrayList<Expression> parameters = new ArrayList<Expression>();
        for (int i = 0; i < args.length; ++i) {
            parameters.add(i, args[i]);
        }
        this.setParameters(parameters);
    }

    public String getName() {
        return this.name.getName();
    }

    public FunctionName getFunctionName() {
        return this.name;
    }

    public List getParameters() {
        return this.params;
    }

    public void setParameters(List params) {
        this.params = params;
    }

    public ProgressListener getProgressListener() {
        return this.progress;
    }

    public void setProgressListener(ProgressListener progress) {
        this.progress = progress;
    }

    public int getNumberOfClasses() {
        return this.getClasses();
    }

    public int getClasses() {
        LiteralExpression classes = (LiteralExpression)this.getParameters().get(1);
        return (Integer)classes.evaluate(null, Integer.class);
    }

    public void setNumberOfClasses(int classes) {
        this.setClasses(classes);
    }

    public void setClasses(int classes) {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        Literal expression = ff.literal(classes);
        this.getParameters().set(1, expression);
    }

    public Expression getExpression() {
        return (Expression)this.getParameters().get(0);
    }

    public void setExpression(Expression e) {
        this.getParameters().set(0, e);
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }

    protected int decimalPlaces(double slotWidth) {
        String str = Double.toString(slotWidth);
        if (str.indexOf(".") > -1) {
            while (str.endsWith("0")) {
                str = str.substring(0, str.length() - 1);
            }
        }
        int intPart = new Double(Math.floor(slotWidth)).intValue();
        double decPart = slotWidth - (double)intPart;
        int intPoints = Integer.toString(intPart).length();
        int decPoints = str.length() - intPoints;
        if (str.indexOf(".") > -1) {
            --decPoints;
        }
        if (decPart == 0.0) {
            decPoints = 0;
        }
        if (intPart == 0) {
            if (decPoints > 6) {
                return 5;
            }
            if (decPoints > 0) {
                return decPoints;
            }
            return 1;
        }
        if (decPoints == 0) {
            return 0;
        }
        int chars = intPoints + decPoints;
        if (chars < 6) {
            return decPoints;
        }
        if (intPoints > 4) {
            return 1;
        }
        return 5 - intPoints;
    }

    protected double round(double value, int decimalPlaces) {
        double divisor = Math.pow(10.0, decimalPlaces);
        double newVal = value * divisor;
        newVal = (double)new Long(Math.round(newVal)).intValue() / divisor;
        return newVal;
    }

    protected double fixRound(double value, int decimalPlaces, boolean up) {
        double divisor = Math.pow(10.0, decimalPlaces);
        double newVal = value * divisor;
        newVal = up ? (newVal += 1.0) : (newVal -= 1.0);
        return newVal /= divisor;
    }
}

