/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import org.geotools.data.simple.SimpleFeatureIterator;
import org.opengis.feature.simple.SimpleFeature;

public class MaxFeaturesSimpleFeatureIterator
implements SimpleFeatureIterator {
    SimpleFeatureIterator delegate;
    long start;
    long end;
    long counter;

    public MaxFeaturesSimpleFeatureIterator(SimpleFeatureIterator iterator, long max) {
        this(iterator, 0L, max);
    }

    public MaxFeaturesSimpleFeatureIterator(SimpleFeatureIterator delegate, long start, long max) {
        this.delegate = delegate;
        this.start = start;
        this.end = start + max;
        this.counter = 0L;
    }

    public SimpleFeatureIterator getDelegate() {
        return this.delegate;
    }

    public boolean hasNext() {
        if (this.counter < this.start) {
            this.skip();
        }
        return this.delegate.hasNext() && this.counter < this.end;
    }

    public SimpleFeature next() {
        if (this.counter < this.start) {
            this.skip();
        }
        if (this.counter <= this.end) {
            ++this.counter;
            SimpleFeature next = (SimpleFeature)this.delegate.next();
            return next;
        }
        return null;
    }

    private void skip() {
        if (this.counter < this.start) {
            while (this.delegate.hasNext() && this.counter < this.start) {
                ++this.counter;
                SimpleFeature simpleFeature = (SimpleFeature)this.delegate.next();
            }
        }
    }

    public void close() {
        this.delegate.close();
    }
}

