/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.geotools.data.DataSourceException;
import org.geotools.data.Diff;
import org.geotools.data.FeatureReader;
import org.geotools.data.TransactionStateDiff;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.filter.AttributeExpression;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.Id;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.identity.Identifier;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

public class DiffFeatureReader<T extends FeatureType, F extends Feature>
implements FeatureReader<T, F> {
    FeatureReader<T, F> reader;
    Diff diff;
    F next = null;
    private Filter filter;
    private Set encounteredFids;
    private Iterator<F> addedIterator;
    private Iterator<F> modifiedIterator;
    private Iterator<Identifier> fids;
    private Iterator<F> spatialIndexIterator;
    private boolean indexedGeometryFilter = false;
    private boolean fidFilter = false;

    public DiffFeatureReader(FeatureReader<T, F> reader, Diff diff2) {
        this(reader, diff2, (Filter)Filter.INCLUDE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiffFeatureReader(FeatureReader<T, F> reader, Diff diff2, Filter filter) {
        this.reader = reader;
        this.diff = diff2;
        this.filter = filter;
        this.encounteredFids = new HashSet();
        if (filter instanceof Id) {
            this.fidFilter = true;
        } else if (this.isSubsetOfBboxFilter(filter)) {
            this.indexedGeometryFilter = true;
        }
        Diff diff = this.diff;
        synchronized (diff) {
            if (this.indexedGeometryFilter) {
                this.spatialIndexIterator = this.getIndexedFeatures().iterator();
            }
            this.addedIterator = this.diff.getAdded().values().iterator();
            this.modifiedIterator = this.diff.getModified().values().iterator();
        }
    }

    public T getFeatureType() {
        return (T)this.reader.getFeatureType();
    }

    public F next() throws IOException, IllegalAttributeException, NoSuchElementException {
        if (this.hasNext()) {
            F live = this.next;
            this.next = null;
            return live;
        }
        throw new NoSuchElementException("No more Feature exists");
    }

    public boolean hasNext() throws IOException {
        if (this.next != null) {
            return true;
        }
        if (this.filter == Filter.EXCLUDE) {
            return false;
        }
        while (this.reader != null && this.reader.hasNext()) {
            Feature peek;
            try {
                peek = this.reader.next();
            }
            catch (NoSuchElementException e) {
                throw new DataSourceException("Could not aquire the next Feature", (Throwable)e);
            }
            catch (IllegalAttributeException e) {
                throw new DataSourceException("Could not aquire the next Feature", (Throwable)e);
            }
            String fid = peek.getIdentifier().getID();
            this.encounteredFids.add(fid);
            Map<String, SimpleFeature> modified = this.diff.getModified();
            if (modified.containsKey(fid)) {
                Feature changed = (Feature)modified.get(fid);
                if (changed == TransactionStateDiff.NULL || !this.filter.evaluate((Object)changed)) continue;
                this.next = changed;
                return true;
            }
            this.next = peek;
            return true;
        }
        this.queryDiff();
        return this.next != null;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        if (this.diff != null) {
            this.diff = null;
            this.addedIterator = null;
        }
    }

    protected void queryDiff() {
        if (this.fidFilter) {
            this.queryFidFilter();
        } else if (this.indexedGeometryFilter) {
            this.querySpatialIndex();
        } else {
            this.queryAdded();
            this.queryModified();
        }
    }

    protected void querySpatialIndex() {
        while (this.spatialIndexIterator.hasNext() && this.next == null) {
            Feature f = (Feature)this.spatialIndexIterator.next();
            if (this.encounteredFids.contains(f.getIdentifier().getID()) || !this.filter.evaluate((Object)f)) continue;
            this.next = f;
        }
    }

    protected void queryAdded() {
        while (this.addedIterator.hasNext() && this.next == null) {
            this.next = (Feature)this.addedIterator.next();
            if (!this.encounteredFids.contains(this.next.getIdentifier().getID()) && this.filter.evaluate(this.next)) continue;
            this.next = null;
        }
    }

    protected void queryModified() {
        while (this.modifiedIterator.hasNext() && this.next == null) {
            this.next = (Feature)this.modifiedIterator.next();
            if (this.next != TransactionStateDiff.NULL && !this.encounteredFids.contains(this.next.getIdentifier().getID()) && this.filter.evaluate(this.next)) continue;
            this.next = null;
        }
    }

    protected void queryFidFilter() {
        Id fidFilter = (Id)this.filter;
        if (this.fids == null) {
            this.fids = fidFilter.getIdentifiers().iterator();
        }
        while (this.fids.hasNext() && this.next == null) {
            String fid = this.fids.next().toString();
            if (this.encounteredFids.contains(fid)) continue;
            this.next = (Feature)this.diff.getModified().get(fid);
            if (this.next != null) continue;
            this.next = (Feature)this.diff.getAdded().get(fid);
        }
    }

    protected List getIndexedFeatures() {
        Envelope env = null;
        env = this.extractBboxForSpatialIndexQuery((BinarySpatialOperator)this.filter);
        return this.diff.queryIndex(env);
    }

    protected Envelope extractBboxForSpatialIndexQuery(BinarySpatialOperator filter) {
        Expression leftGeom = filter.getExpression1();
        Expression rightGeom = filter.getExpression2();
        Geometry g = leftGeom instanceof Literal ? (Geometry)((Literal)leftGeom).getValue() : (Geometry)((Literal)rightGeom).getValue();
        return g.getEnvelopeInternal();
    }

    protected boolean isDefaultGeometry(AttributeExpression ae) {
        return this.reader.getFeatureType().getGeometryDescriptor().getLocalName().equals(ae.getAttributePath());
    }

    protected boolean isSubsetOfBboxFilter(Filter f) {
        return this.filter instanceof Contains || this.filter instanceof Crosses || this.filter instanceof Overlaps || this.filter instanceof Touches || this.filter instanceof Within || this.filter instanceof BBOX;
    }
}

