/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.Join;
import org.geotools.data.Query;
import org.geotools.factory.Hints;
import org.geotools.feature.visitor.CountVisitor;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.SumVisitor;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.function.InFunction;
import org.geotools.filter.visitor.PostPreProcessFilterSplittingVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.ColumnMetadata;
import org.geotools.jdbc.Index;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.NativeFilter;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class SQLDialect {
    protected static final Logger LOGGER = Logging.getLogger(SQLDialect.class);
    public static FilterCapabilities BASE_DBMS_CAPABILITIES = new FilterCapabilities(){
        {
            this.addAll(FilterCapabilities.LOGICAL_OPENGIS);
            this.addAll(FilterCapabilities.SIMPLE_COMPARISONS_OPENGIS);
            this.addAll(InFunction.getInCapabilities());
            this.addType(Add.class);
            this.addType(Subtract.class);
            this.addType(Multiply.class);
            this.addType(Divide.class);
            this.addType(PropertyName.class);
            this.addType(Literal.class);
            this.addType(PropertyIsNull.class);
            this.addType(PropertyIsBetween.class);
            this.addType(Id.class);
            this.addType(IncludeFilter.class);
            this.addType(ExcludeFilter.class);
            this.addType(PropertyIsLike.class);
            this.addType(NativeFilter.class);
        }
    };
    protected JDBCDataStore dataStore;

    protected SQLDialect(JDBCDataStore dataStore) {
        this.dataStore = dataStore;
    }

    public void initializeConnection(Connection cx) throws SQLException {
    }

    public boolean includeTable(String schemaName, String tableName, Connection cx) throws SQLException {
        return true;
    }

    public void registerSqlTypeNameToClassMappings(Map<String, Class<?>> mappings) {
    }

    public Class<?> getMapping(ResultSet columnMetaData, Connection cx) throws SQLException {
        return null;
    }

    public void handleUserDefinedType(ResultSet columnMetaData, ColumnMetadata metadata, Connection cx) throws SQLException {
    }

    public void registerSqlTypeToClassMappings(Map<Integer, Class<?>> mappings) {
        mappings.put(new Integer(12), String.class);
        mappings.put(new Integer(1), String.class);
        mappings.put(new Integer(-1), String.class);
        mappings.put(new Integer(-9), String.class);
        mappings.put(new Integer(-15), String.class);
        mappings.put(new Integer(-7), Boolean.class);
        mappings.put(new Integer(16), Boolean.class);
        mappings.put(new Integer(-6), Short.class);
        mappings.put(new Integer(5), Short.class);
        mappings.put(new Integer(4), Integer.class);
        mappings.put(new Integer(-5), Long.class);
        mappings.put(new Integer(7), Float.class);
        mappings.put(new Integer(6), Double.class);
        mappings.put(new Integer(8), Double.class);
        mappings.put(new Integer(3), BigDecimal.class);
        mappings.put(new Integer(2), BigDecimal.class);
        mappings.put(new Integer(91), Date.class);
        mappings.put(new Integer(92), Time.class);
        mappings.put(new Integer(93), Timestamp.class);
        mappings.put(new Integer(2004), byte[].class);
        mappings.put(new Integer(-2), byte[].class);
        mappings.put(new Integer(2005), String.class);
        mappings.put(new Integer(-3), byte[].class);
    }

    public void registerClassToSqlMappings(Map<Class<?>, Integer> mappings) {
        mappings.put(String.class, new Integer(12));
        mappings.put(Boolean.class, new Integer(16));
        mappings.put(Boolean.TYPE, new Integer(16));
        mappings.put(Short.class, new Integer(5));
        mappings.put(Short.TYPE, new Integer(5));
        mappings.put(Integer.class, new Integer(4));
        mappings.put(Integer.TYPE, new Integer(4));
        mappings.put(Long.class, new Integer(-5));
        mappings.put(Long.TYPE, new Integer(-5));
        mappings.put(Float.class, new Integer(7));
        mappings.put(Float.TYPE, new Integer(7));
        mappings.put(Double.class, new Integer(8));
        mappings.put(Double.TYPE, new Integer(8));
        mappings.put(BigDecimal.class, new Integer(2));
        mappings.put(Date.class, new Integer(91));
        mappings.put(Time.class, new Integer(92));
        mappings.put(java.util.Date.class, new Integer(93));
        mappings.put(Timestamp.class, new Integer(93));
        mappings.put(byte[].class, new Integer(2004));
    }

    public void registerSqlTypeToSqlTypeNameOverrides(Map<Integer, String> overrides) {
    }

    public void registerAggregateFunctions(Map<Class<? extends FeatureVisitor>, String> aggregates) {
        aggregates.put(UniqueVisitor.class, "distinct");
        aggregates.put(CountVisitor.class, "count");
        aggregates.put(MinVisitor.class, "min");
        aggregates.put(MaxVisitor.class, "max");
        aggregates.put(SumVisitor.class, "sum");
    }

    public void registerFunctions(Map<String, String> functions) {
    }

    public String getNameEscape() {
        return "\"";
    }

    protected final String ne() {
        return this.getNameEscape();
    }

    public final void encodeColumnName(String raw, StringBuffer sql) {
        this.encodeColumnName(null, raw, sql);
    }

    public void encodeColumnName(String prefix, String raw, StringBuffer sql) {
        if (prefix != null) {
            sql.append(this.ne()).append(prefix).append(this.ne()).append(".");
        }
        sql.append(this.ne()).append(raw).append(this.ne());
    }

    public void encodeColumnType(String sqlTypeName, StringBuffer sql) {
        sql.append(sqlTypeName);
    }

    public void encodeColumnAlias(String raw, StringBuffer sql) {
        sql.append(" as ");
        this.encodeColumnName(null, raw, sql);
    }

    public void encodeTableAlias(String raw, StringBuffer sql) {
        sql.append(" as ");
        this.encodeColumnName(null, raw, sql);
    }

    public void encodeTableName(String raw, StringBuffer sql) {
        sql.append(this.ne()).append(raw).append(this.ne());
    }

    public void encodeSchemaName(String raw, StringBuffer sql) {
        sql.append(this.ne()).append(raw).append(this.ne());
    }

    public String getGeometryTypeName(Integer type) {
        return null;
    }

    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return null;
    }

    public int getGeometryDimension(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return 2;
    }

    public CoordinateReferenceSystem createCRS(int srid, Connection cx) throws SQLException {
        try {
            return CRS.decode((String)("EPSG:" + srid));
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Could not decode " + srid + " using the built-in EPSG database");
            }
            return null;
        }
    }

    public List<ReferencedEnvelope> getOptimizedBounds(String schema, SimpleFeatureType featureType, Connection cx) throws SQLException, IOException {
        return null;
    }

    public abstract void encodeGeometryEnvelope(String var1, String var2, StringBuffer var3);

    public abstract Envelope decodeGeometryEnvelope(ResultSet var1, int var2, Connection var3) throws SQLException, IOException;

    public final void encodeGeometryColumn(GeometryDescriptor gatt, int srid, StringBuffer sql) {
        this.encodeColumnName(gatt.getLocalName(), sql);
    }

    public void encodeGeometryColumn(GeometryDescriptor gatt, String prefix, int srid, StringBuffer sql) {
        this.encodeColumnName(prefix, gatt.getLocalName(), sql);
    }

    public void encodeGeometryColumn(GeometryDescriptor gatt, String prefix, int srid, Hints hints, StringBuffer sql) {
        this.encodeGeometryColumn(gatt, prefix, srid, sql);
    }

    public final void encodeGeometryColumnGeneralized(GeometryDescriptor gatt, int srid, StringBuffer sql, Double distance) {
        throw new UnsupportedOperationException("Geometry generalization not supported");
    }

    public void encodeGeometryColumnGeneralized(GeometryDescriptor gatt, String prefix, int srid, StringBuffer sql, Double distance) {
        throw new UnsupportedOperationException("Geometry generalization not supported");
    }

    public void encodeGeometryColumnSimplified(GeometryDescriptor gatt, int srid, StringBuffer sql, Double distance) {
        throw new UnsupportedOperationException("Geometry simplification not supported");
    }

    public void encodeGeometryColumnSimplified(GeometryDescriptor gatt, String prefix, int srid, StringBuffer sql, Double distance) {
        throw new UnsupportedOperationException("Geometry simplification not supported");
    }

    public abstract Geometry decodeGeometryValue(GeometryDescriptor var1, ResultSet var2, String var3, GeometryFactory var4, Connection var5, Hints var6) throws IOException, SQLException;

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, int column, GeometryFactory factory, Connection cx, Hints hints) throws IOException, SQLException {
        String columnName = rs.getMetaData().getColumnName(column);
        return this.decodeGeometryValue(descriptor, rs, columnName, factory, cx, hints);
    }

    public void encodePrimaryKey(String column, StringBuffer sql) {
        this.encodeColumnName(null, column, sql);
        sql.append(" INTEGER PRIMARY KEY");
    }

    public void encodeJoin(Join.Type joinType, StringBuffer sql) {
        switch (joinType) {
            case INNER: {
                sql.append("INNER");
                break;
            }
            case OUTER: {
                sql.append("LEFT OUTER");
                break;
            }
            default: {
                throw new IllegalArgumentException("Join type " + joinType + " not supported");
            }
        }
        sql.append(" JOIN");
    }

    public void encodeCreateTable(StringBuffer sql) {
        sql.append("CREATE TABLE ");
    }

    public void encodePostColumnCreateTable(AttributeDescriptor att, StringBuffer sql) {
    }

    public void encodePostCreateTable(String tableName, StringBuffer sql) {
    }

    public void encodePostSelect(SimpleFeatureType featureType, StringBuffer sql) {
    }

    public void postCreateTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException, IOException {
    }

    public void postCreateAttribute(AttributeDescriptor att, String tableName, String schemaName, Connection cx) throws SQLException {
    }

    public void postCreateFeatureType(SimpleFeatureType featureType, DatabaseMetaData metadata, String schemaName, Connection cx) throws SQLException {
    }

    public void preDropTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException {
    }

    public void postDropTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException {
    }

    public boolean lookupGeneratedValuesPostInsert() {
        return false;
    }

    public Object getNextAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return null;
    }

    public Object getLastAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx, Statement st) throws SQLException {
        return this.getLastAutoGeneratedValue(schemaName, tableName, columnName, cx);
    }

    public Object getLastAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return null;
    }

    public String getSequenceForColumn(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return null;
    }

    public Object getNextSequenceValue(String schemaName, String sequenceName, Connection cx) throws SQLException {
        return null;
    }

    public String encodeNextSequenceValue(String schemaName, String sequenceName) {
        return null;
    }

    public boolean isLimitOffsetSupported() {
        return false;
    }

    public boolean isAggregatedSortSupported(String function) {
        return false;
    }

    public boolean isGroupBySupported() {
        return true;
    }

    public void applyLimitOffset(StringBuffer sql, int limit, int offset) {
        throw new UnsupportedOperationException("Ovveride this method when isLimitOffsetSupported returns true");
    }

    protected void addSupportedHints(Set<Hints.Key> hints) {
    }

    public int getDefaultVarcharSize() {
        return 255;
    }

    public boolean isAutoCommitQuery() {
        return false;
    }

    protected boolean supportsSchemaForIndex() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createIndex(Connection cx, SimpleFeatureType schema, String databaseSchema, Index index) throws SQLException {
        StringBuffer sql = new StringBuffer();
        String escape = this.getNameEscape();
        sql.append("CREATE ");
        if (index.isUnique()) {
            sql.append("UNIQUE ");
        }
        sql.append("INDEX ");
        if (this.supportsSchemaForIndex() && databaseSchema != null) {
            this.encodeSchemaName(databaseSchema, sql);
            sql.append(".");
        }
        sql.append(escape).append(index.getIndexName()).append(escape);
        sql.append(" ON ");
        if (databaseSchema != null) {
            this.encodeSchemaName(databaseSchema, sql);
            sql.append(".");
        }
        sql.append(escape).append(index.getTypeName()).append(escape).append("(");
        for (String attribute : index.getAttributes()) {
            sql.append(escape).append(attribute).append(escape).append(", ");
        }
        sql.setLength(sql.length() - 2);
        sql.append(")");
        Statement st = null;
        try {
            st = cx.createStatement();
            st.execute(sql.toString());
            if (!cx.getAutoCommit()) {
                cx.commit();
            }
        }
        finally {
            this.dataStore.closeSafe(cx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropIndex(Connection cx, SimpleFeatureType schema, String databaseSchema, String indexName) throws SQLException {
        StringBuffer sql = new StringBuffer();
        String escape = this.getNameEscape();
        sql.append("DROP INDEX ");
        if (this.supportsSchemaForIndex() && databaseSchema != null) {
            this.encodeSchemaName(databaseSchema, sql);
            sql.append(".");
        }
        sql.append(escape).append(indexName).append(escape);
        Statement st = null;
        try {
            st = cx.createStatement();
            st.execute(sql.toString());
            if (!cx.getAutoCommit()) {
                cx.commit();
            }
        }
        finally {
            this.dataStore.closeSafe(cx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Index> getIndexes(Connection cx, String databaseSchema, String typeName) throws SQLException {
        DatabaseMetaData md = cx.getMetaData();
        ResultSet indexInfo = null;
        try {
            indexInfo = md.getIndexInfo(cx.getCatalog(), databaseSchema, typeName, false, true);
            LinkedHashMap<String, Index> indexes = new LinkedHashMap<String, Index>();
            while (indexInfo.next()) {
                short type = indexInfo.getShort("TYPE");
                if (type == 0) continue;
                String indexName = indexInfo.getString("INDEX_NAME");
                String columnName = indexInfo.getString("COLUMN_NAME");
                Index index = (Index)indexes.get(indexName);
                if (index != null) {
                    index.attributes.add(columnName);
                    continue;
                }
                boolean unique = !indexInfo.getBoolean("NON_UNIQUE");
                index = new Index(typeName, indexName, unique, columnName);
                indexes.put(indexName, index);
            }
            ArrayList<Index> arrayList = new ArrayList<Index>(indexes.values());
            this.dataStore.closeSafe(indexInfo);
            return arrayList;
        }
        catch (Throwable throwable) {
            this.dataStore.closeSafe(indexInfo);
            throw throwable;
        }
    }

    public void handleSelectHints(StringBuffer sql, SimpleFeatureType featureType, Query query) {
    }

    public String[] getDesiredTablesType() {
        return new String[]{"TABLE", "VIEW", "MATERIALIZED VIEW", "SYNONYM"};
    }

    public Filter[] splitFilter(Filter filter, SimpleFeatureType schema) {
        PostPreProcessFilterSplittingVisitor splitter = new PostPreProcessFilterSplittingVisitor(this.dataStore.getFilterCapabilities(), schema, null);
        filter.accept((FilterVisitor)splitter, null);
        Filter[] split = new Filter[]{splitter.getFilterPre(), splitter.getFilterPost()};
        return split;
    }

    protected PrimaryKey getPrimaryKey(String typeName) throws IOException {
        SimpleFeatureType featureType = this.dataStore.getSchema(typeName);
        return this.dataStore.getPrimaryKey(featureType);
    }

    @Deprecated
    protected void encodeAggregateFunction(String function, String column, StringBuffer sql) {
        this.encodeAggregateFunctionPrefix(function, sql);
        sql.append(column);
        this.encodeAggregateFunctionPostfix(function, sql);
    }

    @Deprecated
    public void encodeAggregateFunctionPrefix(String function, StringBuffer sql) {
        sql.append(function).append("(");
    }

    @Deprecated
    public void encodeAggregateFunctionPostfix(String function, StringBuffer sql) {
        sql.append(")");
    }

    public String getPkColumnValue(ResultSet rs, PrimaryKeyColumn pkey, int columnIdx) throws SQLException {
        return rs.getString(columnIdx);
    }
}

