/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.geotools.factory.Hints;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

class InsertionClassifier {
    public final boolean useExisting;
    public final Map<String, Class<? extends Geometry>> geometryTypes;

    public static Map<InsertionClassifier, Collection<SimpleFeature>> classify(SimpleFeatureType featureType, Collection<? extends SimpleFeature> features) {
        HashMap<InsertionClassifier, Collection<SimpleFeature>> kinds = new HashMap<InsertionClassifier, Collection<SimpleFeature>>();
        for (SimpleFeature simpleFeature : features) {
            InsertionClassifier kind = new InsertionClassifier(featureType, simpleFeature);
            ArrayList<SimpleFeature> currents = (ArrayList<SimpleFeature>)kinds.get(kind);
            if (currents == null) {
                currents = new ArrayList<SimpleFeature>();
                kinds.put(kind, currents);
            }
            currents.add(simpleFeature);
        }
        return kinds;
    }

    private InsertionClassifier(SimpleFeatureType featureType, SimpleFeature feature) {
        this.useExisting = InsertionClassifier.useExisting(feature);
        this.geometryTypes = new TreeMap<String, Class<? extends Geometry>>();
        for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
            if (!(att instanceof GeometryDescriptor)) continue;
            Geometry geometry = (Geometry)feature.getAttribute(att.getName());
            if (geometry == null) {
                this.geometryTypes.put(att.getLocalName(), null);
                continue;
            }
            this.geometryTypes.put(att.getLocalName(), geometry.getClass());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsertionClassifier that = (InsertionClassifier)o;
        if (this.useExisting != that.useExisting) {
            return false;
        }
        return this.geometryTypes.equals(that.geometryTypes);
    }

    public int hashCode() {
        int result = this.useExisting ? 1 : 0;
        result = 31 * result + this.geometryTypes.hashCode();
        return result;
    }

    public static boolean useExisting(SimpleFeature feature) {
        return Boolean.TRUE.equals(feature.getUserData().get(Hints.USE_PROVIDED_FID));
    }
}

