/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.image;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.data.DataSourceException;
import org.geotools.data.FileGroupProvider;
import org.geotools.data.PrjFileReader;
import org.geotools.data.WorldFileReader;
import org.geotools.gce.image.WorldImageFormat;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.image.io.ImageIOExt;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public final class WorldImageReader
extends AbstractGridCoverage2DReader
implements GridCoverage2DReader {
    private Logger LOGGER = Logging.getLogger(WorldImageReader.class);
    private boolean wmsRequest;
    private boolean metaFile;
    private String parentPath;
    private String extension;
    private ImageReaderSpi readerSPI;

    public WorldImageReader(Object input) throws DataSourceException {
        this(input, null);
    }

    public WorldImageReader(Object input, Hints hints) throws DataSourceException {
        Object factory;
        if (input == null) {
            IOException ex = new IOException("WorldImage:No source set to read this coverage.");
            this.LOGGER.logp(Level.SEVERE, WorldImageReader.class.toString(), "WorldImageReader", ex.getLocalizedMessage(), ex);
            throw new DataSourceException((Throwable)ex);
        }
        this.source = input;
        if (this.hints == null) {
            this.hints = new Hints();
        }
        if (hints != null) {
            this.hints.add((RenderingHints)hints);
        }
        if (this.hints.containsKey((Object)Hints.GRID_COVERAGE_FACTORY) && (factory = this.hints.get((Object)Hints.GRID_COVERAGE_FACTORY)) != null && factory instanceof GridCoverageFactory) {
            this.coverageFactory = (GridCoverageFactory)factory;
        }
        if (this.coverageFactory == null) {
            this.coverageFactory = CoverageFactoryFinder.getGridCoverageFactory((Hints)this.hints);
        }
        this.coverageName = "image_coverage";
        try {
            boolean closeMe = true;
            if (input instanceof URL) {
                URL sourceURL = (URL)input;
                if (sourceURL.getProtocol().compareToIgnoreCase("file") == 0) {
                    String auth = sourceURL.getAuthority();
                    String path = sourceURL.getPath();
                    if (auth != null && !auth.equals("")) {
                        path = "//" + auth + path;
                    }
                    this.source = input = new File(URLDecoder.decode(path, "UTF-8"));
                } else if (sourceURL.getProtocol().equalsIgnoreCase("http")) {
                    this.wmsRequest = this.WMSRequest(input);
                }
            }
            if (input instanceof File) {
                File sourceFile = (File)input;
                String filename = sourceFile.getName();
                int i = filename.lastIndexOf(46);
                int length = filename.length();
                if (i > 0 && i < length - 1) {
                    this.extension = filename.substring(i + 1).toLowerCase();
                }
                this.parentPath = sourceFile.getParent();
                this.coverageName = filename;
                int dotIndex = this.coverageName.lastIndexOf(".");
                this.coverageName = dotIndex == -1 ? this.coverageName : this.coverageName.substring(0, dotIndex);
            } else if (input instanceof URL) {
                input = ((URL)input).openStream();
            }
            if (input instanceof ImageInputStream) {
                closeMe = false;
            } else {
                this.inStreamSPI = ImageIOExt.getImageInputStreamSPI((Object)this.source);
                if (this.inStreamSPI == null) {
                    throw new DataSourceException("No input stream for the provided source");
                }
                this.inStream = this.inStreamSPI.createInputStreamInstance(this.source, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
            }
            if (this.inStream == null) {
                throw new IllegalArgumentException("No input stream for the provided source");
            }
            if (!this.wmsRequest) {
                Object tempCRS = this.hints.get((Object)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM);
                if (tempCRS != null) {
                    this.crs = (CoordinateReferenceSystem)tempCRS;
                    this.LOGGER.log(Level.WARNING, "Using forced coordinate reference system ");
                } else {
                    this.readCRS();
                }
            }
            this.getHRInfo();
            if (closeMe) {
                this.inStream.close();
            }
        }
        catch (IOException e) {
            this.LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            throw new DataSourceException((Throwable)e);
        }
        catch (TransformException e) {
            this.LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            throw new DataSourceException((Throwable)e);
        }
    }

    private void getHRInfo() throws IOException, TransformException {
        Iterator<ImageReader> it = ImageIO.getImageReaders(this.inStream);
        if (!it.hasNext()) {
            throw new DataSourceException("No reader avalaible for this source");
        }
        ImageReader reader = it.next();
        this.readerSPI = reader.getOriginatingProvider();
        reader.setInput(this.inStream);
        this.setLayout(reader);
        this.numOverviews = this.wmsRequest ? 0 : reader.getNumImages(true) - 1;
        int hrWidth = reader.getWidth(0);
        int hrHeight = reader.getHeight(0);
        Rectangle actualDim = new Rectangle(0, 0, hrWidth, hrHeight);
        this.originalGridRange = new GridEnvelope2D(actualDim);
        if (this.source instanceof File) {
            this.prepareWorldImageGridToWorldTransform();
            if (!this.metaFile) {
                AffineTransform tempTransform = new AffineTransform((AffineTransform)this.raster2Model);
                tempTransform.translate(-0.5, -0.5);
                this.originalEnvelope = CRS.transform((MathTransform)ProjectiveTransform.create((AffineTransform)tempTransform), (Envelope)new GeneralEnvelope((Rectangle2D)actualDim));
                this.originalEnvelope.setCoordinateReferenceSystem(this.crs);
                this.highestRes = new double[2];
                this.highestRes[0] = XAffineTransform.getScaleX0((AffineTransform)tempTransform);
                this.highestRes[1] = XAffineTransform.getScaleY0((AffineTransform)tempTransform);
            } else {
                this.highestRes = WorldImageReader.getResolution((GeneralEnvelope)this.originalEnvelope, (Rectangle2D)actualDim, (CoordinateReferenceSystem)this.crs);
                GridToEnvelopeMapper mapper = new GridToEnvelopeMapper(this.originalGridRange, (Envelope)this.originalEnvelope);
                mapper.setPixelAnchor(PixelInCell.CELL_CENTER);
                this.raster2Model = mapper.createTransform();
            }
        }
        if (this.numOverviews >= 1) {
            this.overViewResolutions = new double[this.numOverviews][2];
            for (int i = 0; i < this.numOverviews; ++i) {
                this.overViewResolutions[i][0] = this.highestRes[0] * (double)this.originalGridRange.getSpan(0) / (double)reader.getWidth(i + 1);
                this.overViewResolutions[i][1] = this.highestRes[1] * (double)this.originalGridRange.getSpan(1) / (double)reader.getHeight(i + 1);
            }
        } else {
            this.overViewResolutions = null;
        }
    }

    public Format getFormat() {
        return new WorldImageFormat();
    }

    public GridCoverage2D read(GeneralParameterValue[] params) throws IllegalArgumentException, IOException {
        GeneralEnvelope requestedEnvelope = null;
        Rectangle dim = null;
        OverviewPolicy overviewPolicy = null;
        if (params != null && params != null) {
            for (int i = 0; i < params.length; ++i) {
                ParameterValue param = (ParameterValue)params[i];
                String name = param.getDescriptor().getName().getCode();
                if (name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString())) {
                    GridGeometry2D gg = (GridGeometry2D)param.getValue();
                    requestedEnvelope = new GeneralEnvelope((Envelope)gg.getEnvelope2D());
                    dim = gg.getGridRange2D().getBounds();
                    continue;
                }
                if (!name.equals(AbstractGridFormat.OVERVIEW_POLICY.getName().toString())) continue;
                overviewPolicy = (OverviewPolicy)param.getValue();
            }
        }
        Integer imageChoice = 0;
        ImageReadParam readP = new ImageReadParam();
        if (!this.wmsRequest) {
            try {
                imageChoice = this.setReadParams(overviewPolicy, readP, requestedEnvelope, dim);
            }
            catch (TransformException e) {
                throw new DataSourceException((Throwable)e);
            }
        }
        Hints newHints = this.hints.clone();
        ParameterBlock pbjRead = new ParameterBlock();
        pbjRead.add(this.inStreamSPI != null ? this.inStreamSPI.createInputStreamInstance(this.source, ImageIO.getUseCache(), ImageIO.getCacheDirectory()) : ImageIO.createImageInputStream(this.source));
        pbjRead.add(imageChoice);
        pbjRead.add(Boolean.FALSE);
        pbjRead.add(Boolean.FALSE);
        pbjRead.add(Boolean.FALSE);
        pbjRead.add(null);
        pbjRead.add(null);
        pbjRead.add(readP);
        pbjRead.add(this.readerSPI.createReaderInstance());
        RenderedOp coverageRaster = JAI.create((String)"ImageRead", (ParameterBlock)pbjRead, (RenderingHints)newHints);
        AffineTransform rasterToModel = this.getRescaledRasterToModel((RenderedImage)coverageRaster);
        return this.createImageCoverage((PlanarImage)coverageRaster, (MathTransform)ProjectiveTransform.create((AffineTransform)rasterToModel));
    }

    private boolean WMSRequest(Object input) {
        if (input instanceof URL && ((URL)input).getProtocol().equalsIgnoreCase("http")) {
            try {
                String query = URLDecoder.decode(((URL)input).getQuery().intern(), "UTF-8");
                if (query.intern().indexOf("GetMap") == -1) {
                    return false;
                }
                String[] pairs = query.split("&");
                int numPairs = pairs.length;
                String[] kvp = null;
                for (int i = 0; i < numPairs; ++i) {
                    kvp = pairs[i].split("=");
                    if (kvp[0].equalsIgnoreCase("BBOX")) {
                        kvp = kvp[1].split(",");
                        this.originalEnvelope = new GeneralEnvelope(new double[]{Double.parseDouble(kvp[0]), Double.parseDouble(kvp[1])}, new double[]{Double.parseDouble(kvp[2]), Double.parseDouble(kvp[3])});
                    }
                    if (kvp[0].equalsIgnoreCase("SRS")) {
                        this.crs = CRS.decode((String)kvp[1], (boolean)true);
                    }
                    if (!kvp[0].equalsIgnoreCase("layers")) continue;
                    this.coverageName = kvp[1].replaceAll(",", "_");
                }
            }
            catch (IOException e) {
                return false;
            }
            catch (NoSuchAuthorityCodeException e) {
                return false;
            }
            catch (MismatchedDimensionException e) {
                return false;
            }
            catch (IndexOutOfBoundsException e) {
                return false;
            }
            catch (FactoryException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readCRS() throws IOException {
        if (this.source instanceof File || this.source instanceof URL && ((URL)this.source).getProtocol() == "file") {
            String sourceAsString;
            if (this.source instanceof File) {
                sourceAsString = ((File)this.source).getAbsolutePath();
            } else {
                String auth = ((URL)this.source).getAuthority();
                String path = ((URL)this.source).getPath();
                sourceAsString = auth != null && !auth.equals("") ? "//" + auth + path : path;
            }
            int index = sourceAsString.lastIndexOf(".");
            StringBuffer base = new StringBuffer(sourceAsString.substring(0, index)).append(".prj");
            File prjFile = new File(base.toString());
            if (prjFile.exists()) {
                PrjFileReader projReader = null;
                try {
                    FileChannel channel = new FileInputStream(prjFile).getChannel();
                    projReader = new PrjFileReader((ReadableByteChannel)channel);
                    this.crs = projReader.getCoordinateReferenceSystem();
                }
                catch (FileNotFoundException e) {
                    this.LOGGER.log(Level.INFO, e.getLocalizedMessage(), e);
                }
                catch (IOException e) {
                    this.LOGGER.log(Level.INFO, e.getLocalizedMessage(), e);
                }
                catch (FactoryException e) {
                    this.LOGGER.log(Level.INFO, e.getLocalizedMessage(), e);
                }
                finally {
                    if (projReader != null) {
                        try {
                            projReader.close();
                        }
                        catch (IOException e) {
                            this.LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                        }
                    }
                }
            }
        }
        if (this.crs == null) {
            this.crs = AbstractGridFormat.getDefaultCRS();
            this.LOGGER.fine("Unable to find crs, continuing with default CRS");
        }
    }

    private void prepareWorldImageGridToWorldTransform() throws IOException {
        String base = this.parentPath != null ? new StringBuffer(this.parentPath).append(File.separator).append(this.coverageName).toString() : this.coverageName;
        File file2Parse = new File(new StringBuffer(base).append(".wld").toString());
        if (file2Parse.exists()) {
            WorldFileReader reader = new WorldFileReader(file2Parse);
            this.raster2Model = reader.getTransform();
        } else {
            Set<String> ext = WorldImageFormat.getWorldExtension(this.extension);
            Iterator<String> it = ext.iterator();
            if (!it.hasNext()) {
                throw new DataSourceException("Unable to parse extension " + this.extension);
            }
            while (!(file2Parse = new File(new StringBuffer(base).append(it.next()).toString())).exists() && it.hasNext()) {
            }
            if (file2Parse.exists()) {
                WorldFileReader reader = new WorldFileReader(file2Parse);
                this.raster2Model = reader.getTransform();
                this.metaFile = false;
            } else {
                file2Parse = new File(new StringBuffer(base).append(".meta").toString());
                if (file2Parse.exists()) {
                    this.parseMetaFile(file2Parse);
                    this.metaFile = true;
                } else {
                    this.LOGGER.warning("Could not find a world transform file for " + this.coverageName + ", assuming the identity transform");
                    this.raster2Model = ProjectiveTransform.create((AffineTransform)new AffineTransform());
                }
            }
        }
    }

    private void parseMetaFile(File file2Parse) throws NumberFormatException, IOException {
        double xMin = 0.0;
        double yMax = 0.0;
        double xMax = 0.0;
        double yMin = 0.0;
        BufferedReader in = new BufferedReader(new FileReader(file2Parse));
        String str = null;
        int index = 0;
        double value = 0.0;
        while ((str = in.readLine()) != null) {
            switch (index) {
                case 1: {
                    xMin = value = Double.parseDouble(str.substring("Origin Longitude = ".intern().length()));
                    break;
                }
                case 2: {
                    yMin = value = Double.parseDouble(str.substring("Origin Latitude = ".intern().length()));
                    break;
                }
                case 3: {
                    xMax = value = Double.parseDouble(str.substring("Corner Longitude = ".intern().length()));
                    break;
                }
                case 4: {
                    yMax = value = Double.parseDouble(str.substring("Corner Latitude = ".intern().length()));
                    break;
                }
            }
            ++index;
        }
        in.close();
        this.originalEnvelope = new GeneralEnvelope(new double[]{xMin, yMin}, new double[]{xMax, yMax});
        this.originalEnvelope.setCoordinateReferenceSystem(this.crs);
    }

    public int getGridCoverageCount() {
        return 1;
    }

    public String getExtension() {
        return this.extension;
    }

    protected List<FileGroupProvider.FileGroup> getFiles() {
        File file = this.getSourceAsFile();
        if (file == null) {
            return null;
        }
        ArrayList files = new ArrayList();
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.add(".prj");
        Set<String> worldExtensions = WorldImageFormat.getWorldExtension(this.getExtension());
        extensions.addAll(worldExtensions);
        String[] siblingExtensions = extensions.toArray(new String[extensions.size()]);
        this.addAllSiblings(file, files, siblingExtensions);
        return Collections.singletonList(new FileGroupProvider.FileGroup(file, files, null));
    }
}

