/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.structure.basic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.GraphVisitor;
import org.geotools.graph.structure.Graphable;
import org.geotools.graph.structure.Node;

public class BasicGraph
implements Graph,
Serializable {
    private transient Collection m_nodes;
    private transient Collection m_edges;

    public BasicGraph() {
    }

    public BasicGraph(Collection nodes, Collection edges) {
        this.m_nodes = nodes;
        this.m_edges = edges;
    }

    public void setNodes(Collection nodes) {
        this.m_nodes = nodes;
    }

    @Override
    public Collection getNodes() {
        return this.m_nodes;
    }

    public void setEdges(Collection edges) {
        this.m_edges = edges;
    }

    @Override
    public Collection getEdges() {
        return this.m_edges;
    }

    @Override
    public List queryNodes(GraphVisitor visitor) {
        return this.query(this.getNodes(), visitor);
    }

    @Override
    public List queryEdges(GraphVisitor visitor) {
        return this.query(this.getEdges(), visitor);
    }

    @Override
    public void visitNodes(GraphVisitor visitor) {
        this.visit(this.m_nodes, visitor);
    }

    @Override
    public void visitEdges(GraphVisitor visitor) {
        this.visit(this.m_edges, visitor);
    }

    @Override
    public List getNodesOfDegree(int n) {
        final int degree = n;
        return this.queryNodes(new GraphVisitor(){

            @Override
            public int visit(Graphable component) {
                if (((Node)component).getDegree() == degree) {
                    return 1;
                }
                return 0;
            }
        });
    }

    @Override
    public List getVisitedNodes(boolean visited) {
        return this.getVisited(this.getNodes(), visited);
    }

    @Override
    public List getVisitedEdges(boolean visited) {
        return this.getVisited(this.getEdges(), visited);
    }

    public void initNodes() {
        for (Node node : this.m_nodes) {
            node.setVisited(false);
            node.setCount(0);
        }
    }

    public void initEdges() {
        for (Edge edge : this.m_edges) {
            edge.setVisited(false);
            edge.setCount(0);
        }
    }

    public String toString() {
        return "V=" + this.m_nodes.toString() + "\nE=" + this.m_edges.toString();
    }

    private List query(Collection components, GraphVisitor visitor) {
        ArrayList<Graphable> result = new ArrayList<Graphable>();
        block5: for (Graphable component : components) {
            switch (visitor.visit(component)) {
                case 1: {
                    result.add(component);
                    continue block5;
                }
                case 2: {
                    result.add(component);
                    return result;
                }
                case 0: {
                    continue block5;
                }
            }
        }
        return result;
    }

    private void visit(Collection components, GraphVisitor visitor) {
        Iterator itr = components.iterator();
        while (itr.hasNext()) {
            visitor.visit((Graphable)itr.next());
        }
    }

    private List getVisited(Collection components, boolean visited) {
        final boolean isVisited = visited;
        return this.query(components, new GraphVisitor(){

            @Override
            public int visit(Graphable component) {
                if (component.isVisited() == isVisited) {
                    return 1;
                }
                return 0;
            }
        });
    }
}

