/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geopkg.geom;

import org.geotools.geopkg.geom.EnvelopeType;

public class GeometryHeaderFlags {
    private byte b;
    private static byte MASK_BINARY_TYPE = (byte)32;
    private static byte MASK_EMPTY = (byte)16;
    private static byte MASK_ENVELOPE_IND = (byte)14;
    private static byte MASK_ENDIANESS = 1;

    public GeometryHeaderFlags(byte b) {
        this.b = b;
    }

    public EnvelopeType getEnvelopeIndicator() {
        return EnvelopeType.valueOf((byte)((this.b & MASK_ENVELOPE_IND) >> 1));
    }

    public void setEnvelopeIndicator(EnvelopeType e) {
        this.b = (byte)(this.b | e.getValue() << 1 & MASK_ENVELOPE_IND);
    }

    public int getEndianess() {
        return (this.b & MASK_ENDIANESS) == 1 ? 2 : 1;
    }

    public void setEndianess(int endian) {
        byte e = (byte)(endian == 2 ? 1 : 0);
        this.b = (byte)(this.b | e & MASK_ENDIANESS);
    }

    public boolean isEmpty() {
        return (this.b & MASK_EMPTY) == 1;
    }

    public void setEmpty(boolean empty) {
        this.b = (byte)(this.b | (byte)(empty ? 1 : 0) & MASK_EMPTY);
    }

    public GeopackageBinaryType getBinaryType() {
        return GeopackageBinaryType.valueOf((byte)((this.b & MASK_BINARY_TYPE) >> 1));
    }

    public void setBinaryType(GeopackageBinaryType binaryType) {
        this.b = (byte)(this.b | binaryType.getValue() << 1 & MASK_BINARY_TYPE);
    }

    public byte toByte() {
        return this.b;
    }

    public static enum GeopackageBinaryType {
        StandardGeoPackageBinary(0),
        ExtendedGeoPackageBinary(1);

        private byte value;

        private GeopackageBinaryType(int value) {
            this.value = (byte)value;
        }

        public byte getValue() {
            return this.value;
        }

        public static GeopackageBinaryType valueOf(byte b) {
            for (GeopackageBinaryType et : GeopackageBinaryType.values()) {
                if (et.value != b) continue;
                return et;
            }
            return null;
        }
    }
}

