/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geopkg;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.geotools.data.DataAccessFactory;
import org.geotools.geopkg.GeoPkgDialect;
import org.geotools.geopkg.geom.GeoPkgGeomWriter;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.SQLDialect;
import org.sqlite.SQLiteConfig;
import org.sqlite.javax.SQLiteConnectionPoolDataSource;

public class GeoPkgDataStoreFactory
extends JDBCDataStoreFactory {
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Type", true, (Object)"geopkg", Collections.singletonMap("level", "program"));
    public static final DataAccessFactory.Param DATABASE = new DataAccessFactory.Param("database", File.class, "Database", true, null, Collections.singletonMap("ext", "gpkg"));
    public static final DataAccessFactory.Param READ_ONLY = new DataAccessFactory.Param("read_only", Boolean.class, "Read only", false);
    File baseDirectory = null;
    GeoPkgGeomWriter.Configuration writerConfig;

    public GeoPkgDataStoreFactory() {
        this.writerConfig = new GeoPkgGeomWriter.Configuration();
    }

    public GeoPkgDataStoreFactory(GeoPkgGeomWriter.Configuration writerConfig) {
        this.writerConfig = writerConfig;
    }

    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    protected String getDatabaseID() {
        return "geopkg";
    }

    public String getDescription() {
        return "GeoPackage";
    }

    protected String getDriverClassName() {
        return "org.sqlite.JDBC";
    }

    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return new GeoPkgDialect(dataStore, this.writerConfig);
    }

    protected String getValidationQuery() {
        return "SELECT 1";
    }

    protected String getJDBCUrl(Map params) throws IOException {
        File db = (File)DATABASE.lookUp(params);
        if (db.getPath().startsWith("file:")) {
            db = new File(db.getPath().substring(5));
        }
        if (this.baseDirectory != null && !db.isAbsolute()) {
            db = new File(this.baseDirectory, db.getPath());
        }
        return "jdbc:sqlite:" + db;
    }

    protected void setupParameters(Map parameters) {
        super.setupParameters(parameters);
        parameters.remove(GeoPkgDataStoreFactory.HOST.key);
        parameters.remove(GeoPkgDataStoreFactory.PORT.key);
        parameters.remove(GeoPkgDataStoreFactory.SCHEMA.key);
        parameters.remove(GeoPkgDataStoreFactory.USER.key);
        parameters.remove(GeoPkgDataStoreFactory.MAXCONN.key);
        parameters.remove(GeoPkgDataStoreFactory.MINCONN.key);
        parameters.remove(GeoPkgDataStoreFactory.MAXWAIT.key);
        parameters.remove(GeoPkgDataStoreFactory.VALIDATECONN.key);
        parameters.remove(GeoPkgDataStoreFactory.TEST_WHILE_IDLE.key);
        parameters.remove(GeoPkgDataStoreFactory.TIME_BETWEEN_EVICTOR_RUNS.key);
        parameters.remove(GeoPkgDataStoreFactory.MIN_EVICTABLE_TIME.key);
        parameters.remove(GeoPkgDataStoreFactory.EVICTOR_TESTS_PER_RUN.key);
        parameters.put(GeoPkgDataStoreFactory.DATABASE.key, DATABASE);
        parameters.put(GeoPkgDataStoreFactory.DBTYPE.key, DBTYPE);
    }

    public BasicDataSource createDataSource(Map params) throws IOException {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(this.getDriverClassName());
        dataSource.setUrl(this.getJDBCUrl(params));
        GeoPkgDataStoreFactory.addConnectionProperties(dataSource, params);
        dataSource.setAccessToUnderlyingConnectionAllowed(true);
        return dataSource;
    }

    protected DataSource createDataSource(Map params, SQLDialect dialect) throws IOException {
        SQLiteConfig config = new SQLiteConfig();
        config.setSharedCache(true);
        config.enableLoadExtension(true);
        SQLiteConnectionPoolDataSource ds = new SQLiteConnectionPoolDataSource(config);
        ds.setUrl(this.getJDBCUrl(params));
        return ds;
    }

    static void addConnectionProperties(BasicDataSource dataSource, Map configuration) throws IOException {
        SQLiteConfig config = new SQLiteConfig();
        config.setSharedCache(true);
        config.enableLoadExtension(true);
        Object synchronous = READ_ONLY.lookUp(configuration);
        if (Boolean.TRUE.equals(synchronous)) {
            config.setPragma(SQLiteConfig.Pragma.SYNCHRONOUS, "OFF");
            config.setReadOnly(true);
        }
        for (Map.Entry<Object, Object> e : config.toProperties().entrySet()) {
            dataSource.addConnectionProperty((String)e.getKey(), (String)e.getValue());
        }
    }

    protected JDBCDataStore createDataStoreInternal(JDBCDataStore dataStore, Map params) throws IOException {
        dataStore.setDatabaseSchema(null);
        return dataStore;
    }
}

