/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geopkg.mosaic;

import it.geosolutions.jaiext.mosaic.MosaicDescriptor;
import it.geosolutions.jaiext.mosaic.MosaicRIF;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.ParameterBlockJAI;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geopkg.GeoPackage;
import org.geotools.geopkg.Tile;
import org.geotools.geopkg.TileEntry;
import org.geotools.geopkg.TileMatrix;
import org.geotools.geopkg.TileReader;
import org.geotools.geopkg.mosaic.GeoPackageFormat;
import org.geotools.geopkg.mosaic.TileImageReader;
import org.geotools.image.ImageWorker;
import org.geotools.referencing.CRS;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeoPackageReader
extends AbstractGridCoverage2DReader {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.geopkg.mosaic");
    protected static final int DEFAULT_TILE_SIZE = 256;
    protected static final int ZOOM_LEVEL_BASE = 2;
    protected GridCoverageFactory coverageFactory;
    protected File sourceFile;
    protected Map<String, TileEntry> tiles = new LinkedHashMap<String, TileEntry>();
    GeoPackage file;

    public GeoPackageReader(Object source, Hints hints) throws IOException {
        this.coverageFactory = CoverageFactoryFinder.getGridCoverageFactory((Hints)this.hints);
        this.sourceFile = GeoPackageFormat.getFileFromSource(source);
        this.file = new GeoPackage(this.sourceFile, null, null, true);
        for (TileEntry tile : this.file.tiles()) {
            this.tiles.put(tile.getTableName(), tile);
        }
        this.coverageName = this.tiles.keySet().iterator().next();
        List<TileMatrix> tileMatricies = this.tiles.get(this.coverageName).getTileMatricies();
        this.numOverviews = tileMatricies.size() - 1;
        this.overViewResolutions = new double[this.numOverviews][2];
        for (int i = 0; i < tileMatricies.size() - 1; ++i) {
            TileMatrix matrix = tileMatricies.get(i);
            this.overViewResolutions[tileMatricies.size() - i - 2] = new double[]{matrix.getXPixelSize(), matrix.getYPixelSize()};
        }
    }

    public Format getFormat() {
        return new GeoPackageFormat();
    }

    protected boolean checkName(String coverageName) {
        Utilities.ensureNonNull((String)"coverageName", (Object)coverageName);
        return this.tiles.keySet().contains(coverageName);
    }

    public GeneralEnvelope getOriginalEnvelope(String coverageName) {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        return new GeneralEnvelope((org.opengis.geometry.Envelope)this.tiles.get(coverageName).getTileMatrixSetBounds());
    }

    protected double[] getHighestRes(String coverageName) {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        List<TileMatrix> matrices = this.tiles.get(coverageName).getTileMatricies();
        TileMatrix matrix = matrices.get(matrices.size() - 1);
        return new double[]{matrix.getXPixelSize(), matrix.getYPixelSize()};
    }

    public GridEnvelope getOriginalGridRange(String coverageName) {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        List<TileMatrix> matrices = this.tiles.get(coverageName).getTileMatricies();
        TileMatrix matrix = matrices.get(matrices.size() - 1);
        return new GridEnvelope2D(new Rectangle(matrix.getMatrixWidth() * matrix.getTileWidth(), matrix.getMatrixHeight() * matrix.getTileHeight()));
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem(String coverageName) {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        try {
            return CRS.decode((String)("EPSG:" + this.tiles.get(coverageName).getSrid()), (boolean)true);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    public String[] getGridCoverageNames() {
        return this.tiles.keySet().toArray(new String[this.tiles.size()]);
    }

    public int getGridCoverageCount() {
        return this.tiles.size();
    }

    public GridCoverage2D read(String coverageName, GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
        int topTile;
        int rightTile;
        int bottomTile;
        int leftTile;
        TileBoundsCalculator tileBoundsCalculator;
        TileEntry entry = this.tiles.get(coverageName);
        RenderedImage image = null;
        ReferencedEnvelope resultEnvelope = null;
        CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem(coverageName);
        ReferencedEnvelope requestedEnvelope = null;
        Rectangle dim = null;
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                ParameterValue param = (ParameterValue)parameters[i];
                ReferenceIdentifier name = param.getDescriptor().getName();
                if (!name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName())) continue;
                GridGeometry2D gg = (GridGeometry2D)param.getValue();
                try {
                    requestedEnvelope = ReferencedEnvelope.create((org.opengis.geometry.Envelope)gg.getEnvelope(), (CoordinateReferenceSystem)gg.getCoordinateReferenceSystem()).transform(crs, true);
                }
                catch (Exception e) {
                    requestedEnvelope = null;
                }
                dim = gg.getGridRange2D().getBounds();
            }
        }
        TileMatrix bestMatrix = null;
        if (requestedEnvelope != null && dim != null) {
            double horRes = requestedEnvelope.getSpan(0) / dim.getWidth();
            double difference = Double.MAX_VALUE;
            for (TileMatrix matrix : entry.getTileMatricies()) {
                double newRes;
                double newDifference;
                if (!matrix.hasTiles() || !((newDifference = Math.abs(horRes - (newRes = matrix.getXPixelSize().doubleValue()))) < difference)) continue;
                difference = newDifference;
                bestMatrix = matrix;
            }
        }
        if (bestMatrix == null) {
            double resolution = Double.POSITIVE_INFINITY;
            for (TileMatrix matrix : entry.getTileMatricies()) {
                double newRes;
                if (!matrix.hasTiles() || !((newRes = matrix.getXPixelSize().doubleValue()) < resolution)) continue;
                resolution = newRes;
                bestMatrix = matrix;
            }
        }
        if (bestMatrix == null) {
            return null;
        }
        ReferencedEnvelope entryBounds = entry.getTileMatrixSetBounds();
        double resX = bestMatrix.getXPixelSize() * (double)bestMatrix.getTileWidth().intValue();
        double resY = bestMatrix.getYPixelSize() * (double)bestMatrix.getTileHeight().intValue();
        double offsetX = entryBounds.getMinX();
        double offsetY = entryBounds.getMaxY();
        if (requestedEnvelope != null) {
            tileBoundsCalculator = new TileBoundsCalculator((Envelope)requestedEnvelope, resX, resY, offsetX, offsetY).invoke();
            leftTile = tileBoundsCalculator.getLeftTile();
            bottomTile = tileBoundsCalculator.getBottomTile();
            rightTile = tileBoundsCalculator.getRightTile();
            topTile = tileBoundsCalculator.getTopTile();
        } else {
            tileBoundsCalculator = new TileBoundsCalculator((Envelope)entryBounds, resX, resY, offsetX, offsetY).invoke();
            leftTile = tileBoundsCalculator.getLeftTile();
            bottomTile = tileBoundsCalculator.getBottomTile();
            rightTile = tileBoundsCalculator.getRightTile();
            topTile = tileBoundsCalculator.getTopTile();
            double minX = entryBounds.getMinX();
            double maxX = entryBounds.getMaxX();
            double minY = entryBounds.getMinY();
            double maxY = entryBounds.getMaxY();
            leftTile = (int)Math.floor((minX - offsetX) / resX);
            topTile = (int)Math.floor((offsetY - maxY) / resY);
            rightTile = (int)Math.ceil((maxX - offsetX) / resX);
            bottomTile = (int)Math.ceil((offsetY - minY) / resY);
        }
        try (TileReader it = this.file.reader(entry, bestMatrix.getZoomLevel(), bestMatrix.getZoomLevel(), leftTile, rightTile, topTile, bottomTile);){
            ArrayList<RenderedImage> sources = new ArrayList<RenderedImage>();
            ImageWorker iw = new ImageWorker();
            TileImageReader tileReader = new TileImageReader();
            while (it.hasNext()) {
                Tile tile = it.next();
                ReferencedEnvelope tileEnvelope = new ReferencedEnvelope(offsetX + (double)tile.getColumn().intValue() * resX, offsetX + (double)(tile.getColumn() + 1) * resX, offsetY - (double)(tile.getRow() + 1) * resY, offsetY - (double)tile.getRow().intValue() * resY, crs);
                if (resultEnvelope == null) {
                    resultEnvelope = tileEnvelope;
                } else {
                    resultEnvelope.expandToInclude((Envelope)tileEnvelope);
                }
                BufferedImage tileImage = tileReader.read(tile.getData());
                iw.setImage((RenderedImage)tileImage);
                int posx = (tile.getColumn() - leftTile) * 256;
                int posy = (tile.getRow() - topTile) * 256;
                if (posx != 0 || posy != 0) {
                    iw.translate((float)posx, (float)posy, Interpolation.getInstance((int)0));
                    RenderedImage translated = iw.getRenderedImage();
                    sources.add(translated);
                    continue;
                }
                sources.add(tileImage);
            }
            it.close();
            if (sources.isEmpty()) {
                GridCoverage2D tile = null;
                return tile;
            }
            if (sources.size() == 1) {
                image = (RenderedImage)sources.get(0);
            } else {
                ParameterBlockJAI pb = new ParameterBlockJAI((OperationDescriptor)new MosaicDescriptor());
                sources.forEach(s -> pb.addSource(s));
                pb.setParameter("mosaicType", (Object)javax.media.jai.operator.MosaicDescriptor.MOSAIC_TYPE_OVERLAY);
                pb.setParameter("sourceAlpha", null);
                pb.setParameter("sourceROI", null);
                pb.setParameter("sourceThreshold", null);
                pb.setParameter("backgroundValues", (Object)new double[]{0.0});
                pb.setParameter("nodata", null);
                Hints hints = new Hints(JAI.getDefaultInstance().getRenderingHints());
                hints.putAll((Map<?, ?>)GeoTools.getDefaultHints());
                image = new MosaicRIF().create((ParameterBlock)pb, (RenderingHints)hints);
            }
        }
        return this.coverageFactory.create((CharSequence)entry.getTableName(), image, resultEnvelope);
    }

    private int normalizeTile(int tile, int min, int max) {
        if (tile < min) {
            return min;
        }
        if (tile > max) {
            return max;
        }
        return tile;
    }

    protected BufferedImage getStartImage(BufferedImage copyFrom, int width, int height) {
        HashMap<String, Object> properties = null;
        if (copyFrom.getPropertyNames() != null) {
            properties = new HashMap<String, Object>();
            for (String name : copyFrom.getPropertyNames()) {
                properties.put(name, copyFrom.getProperty(name));
            }
        }
        SampleModel sm = copyFrom.getSampleModel().createCompatibleSampleModel(width, height);
        WritableRaster raster = Raster.createWritableRaster(sm, null);
        BufferedImage image = new BufferedImage(copyFrom.getColorModel(), raster, copyFrom.isAlphaPremultiplied(), (Hashtable)((Object)properties));
        Graphics2D g2D = (Graphics2D)image.getGraphics();
        Color save = g2D.getColor();
        g2D.setColor(Color.WHITE);
        g2D.fillRect(0, 0, image.getWidth(), image.getHeight());
        g2D.setColor(save);
        return image;
    }

    protected BufferedImage getStartImage(int imageType, int width, int height) {
        if (imageType == 0) {
            imageType = 5;
        }
        BufferedImage image = new BufferedImage(width, height, imageType);
        Graphics2D g2D = (Graphics2D)image.getGraphics();
        Color save = g2D.getColor();
        g2D.setColor(Color.WHITE);
        g2D.fillRect(0, 0, image.getWidth(), image.getHeight());
        g2D.setColor(save);
        return image;
    }

    protected BufferedImage getStartImage(int width, int height) {
        return this.getStartImage(0, width, height);
    }

    public GridCoverage2D read(GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
        return this.read(this.coverageName, parameters);
    }

    public void dispose() {
        if (this.file != null) {
            this.file.close();
        }
    }

    private class TileBoundsCalculator {
        private Envelope requestedEnvelope;
        private double resX;
        private double resY;
        private double offsetX;
        private double offsetY;
        private int leftTile;
        private int bottomTile;
        private int rightTile;
        private int topTile;

        public TileBoundsCalculator(Envelope requestedEnvelope, double resX, double resY, double offsetX, double offsetY) {
            this.requestedEnvelope = requestedEnvelope;
            this.resX = resX;
            this.resY = resY;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
        }

        public int getLeftTile() {
            return this.leftTile;
        }

        public int getBottomTile() {
            return this.bottomTile;
        }

        public int getRightTile() {
            return this.rightTile;
        }

        public int getTopTile() {
            return this.topTile;
        }

        public TileBoundsCalculator invoke() {
            double minX = this.requestedEnvelope.getMinX();
            double maxX = this.requestedEnvelope.getMaxX();
            double minY = this.requestedEnvelope.getMinY();
            double maxY = this.requestedEnvelope.getMaxY();
            this.leftTile = (int)Math.floor((minX - this.offsetX) / this.resX);
            this.topTile = (int)Math.floor((this.offsetY - maxY) / this.resY);
            this.rightTile = (int)Math.ceil((maxX - this.offsetX) / this.resX);
            if (this.offsetX + (double)this.rightTile * this.resX > maxX) {
                --this.rightTile;
            }
            this.bottomTile = (int)Math.ceil((this.offsetY - minY) / this.resY);
            if (this.offsetY - (double)this.bottomTile * this.resY < minY) {
                --this.bottomTile;
            }
            return this;
        }
    }
}

