/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geopkg.mosaic;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.factory.Hints;
import org.geotools.geopkg.mosaic.GeoPackageReader;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.util.URLs;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;

public class GeoPackageFormat
extends AbstractGridFormat {
    private static final Logger LOGGER = Logging.getLogger((String)GeoPackageFormat.class.getPackage().getName());

    public static File getFileFromSource(Object source) {
        if (source == null) {
            return null;
        }
        File sourceFile = null;
        try {
            if (source instanceof File) {
                sourceFile = (File)source;
            } else if (source instanceof URL) {
                if (((URL)source).getProtocol().equals("file")) {
                    sourceFile = URLs.urlToFile((URL)((URL)source));
                }
            } else if (source instanceof String) {
                sourceFile = new File((String)source);
            }
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            return null;
        }
        return sourceFile;
    }

    public AbstractGridCoverage2DReader getReader(Object source) {
        return this.getReader(source, null);
    }

    public AbstractGridCoverage2DReader getReader(Object source, Hints hints) {
        try {
            return new GeoPackageReader(source, hints);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            return null;
        }
    }

    public GridCoverageWriter getWriter(Object destination) {
        return this.getWriter(destination, null);
    }

    public GridCoverageWriter getWriter(Object destination, Hints hints) {
        throw new UnsupportedOperationException("Unsupported method: Geopackage format is read-only.");
    }

    public boolean accepts(Object source, Hints hints) {
        if (source == null) {
            return false;
        }
        File sourceFile = GeoPackageFormat.getFileFromSource(source);
        if (sourceFile == null) {
            return false;
        }
        return sourceFile.getName().endsWith(".gpkg");
    }

    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        throw new UnsupportedOperationException("Unsupported method.");
    }

    public GeoPackageFormat() {
        this.setInfo();
    }

    private void setInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("name", "GeoPackage (mosaic)");
        info.put("description", "GeoPackage mosaic plugin");
        info.put("vendor", "Geotools");
        info.put("docURL", "");
        info.put("version", "1.0");
        this.mInfo = info;
        this.readParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D}));
        this.writeParameters = null;
    }
}

