/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geopkg.geom;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.geotools.geopkg.geom.EnvelopeType;
import org.geotools.geopkg.geom.GeometryHeader;
import org.geotools.geopkg.geom.GeometryHeaderFlags;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ByteOrderValues;
import org.locationtech.jts.io.OutStream;
import org.locationtech.jts.io.OutputStreamOutStream;
import org.locationtech.jts.io.WKBWriter;

public class GeoPkgGeomWriter {
    protected Configuration config;
    protected int dim;

    public GeoPkgGeomWriter() {
        this(2, new Configuration());
    }

    public GeoPkgGeomWriter(int dim) {
        this(dim, new Configuration());
    }

    public GeoPkgGeomWriter(Configuration config) {
        this(2, config);
    }

    public GeoPkgGeomWriter(int dim, Configuration config) {
        this.config = config;
        this.dim = dim;
    }

    public byte[] write(Geometry g) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.write(g, bout);
        return bout.toByteArray();
    }

    public void write(Geometry g, OutputStream out) throws IOException {
        this.write(g, (OutStream)new OutputStreamOutStream(out));
        out.flush();
    }

    void write(Geometry g, OutStream out) throws IOException {
        if (g == null) {
            return;
        }
        GeometryHeaderFlags flags = new GeometryHeaderFlags(0);
        flags.setBinaryType(GeometryHeaderFlags.GeopackageBinaryType.StandardGeoPackageBinary);
        flags.setEmpty(g.isEmpty());
        flags.setEndianess(1);
        flags.setEnvelopeIndicator(this.config.isWriteEnvelope() ? EnvelopeType.XY : EnvelopeType.NONE);
        GeometryHeader h = new GeometryHeader();
        h.setVersion((byte)0);
        h.setFlags(flags);
        h.setSrid(g.getSRID());
        if (this.config.isWriteEnvelope()) {
            h.setEnvelope(g.getEnvelopeInternal());
        }
        byte[] buf = new byte[8];
        buf[0] = 71;
        buf[1] = 80;
        buf[2] = h.getVersion();
        buf[3] = flags.toByte();
        out.write(buf, 4);
        int order = flags.getEndianess();
        ByteOrderValues.putInt((int)g.getSRID(), (byte[])buf, (int)order);
        out.write(buf, 4);
        if (flags.getEnvelopeIndicator() != EnvelopeType.NONE) {
            Envelope env = g.getEnvelopeInternal();
            ByteOrderValues.putDouble((double)env.getMinX(), (byte[])buf, (int)order);
            out.write(buf, 8);
            ByteOrderValues.putDouble((double)env.getMaxX(), (byte[])buf, (int)order);
            out.write(buf, 8);
            ByteOrderValues.putDouble((double)env.getMinY(), (byte[])buf, (int)order);
            out.write(buf, 8);
            ByteOrderValues.putDouble((double)env.getMaxY(), (byte[])buf, (int)order);
            out.write(buf, 8);
        }
        new WKBWriter(this.dim, order).write(g, out);
    }

    public static class Configuration {
        protected boolean writeEnvelope = true;

        public boolean isWriteEnvelope() {
            return this.writeEnvelope;
        }

        public void setWriteEnvelope(boolean writeEnvelope) {
            this.writeEnvelope = writeEnvelope;
        }
    }
}

