/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geopkg;

import java.io.IOException;
import java.io.Writer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.geotools.data.jdbc.FilterToSQLException;
import org.geotools.filter.FilterCapabilities;
import org.geotools.geopkg.GeoPkgDialect;
import org.geotools.jdbc.PreparedFilterToSQL;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BinarySpatialOperator;

public class GeoPkgFilterToSQL
extends PreparedFilterToSQL {
    GeoPkgDialect dialect;

    public GeoPkgFilterToSQL(GeoPkgDialect dialect) {
        super((PreparedStatementSQLDialect)dialect);
        this.dialect = dialect;
    }

    public void encode(Filter filter) throws FilterToSQLException {
        if (this.out == null) {
            throw new FilterToSQLException("Can't encode to a null writer.");
        }
        FilterCapabilities caps = this.createFilterCapabilities();
        caps.addType(BBOX.class);
        if (caps.fullySupports(filter)) {
            try {
                if (!this.inline) {
                    this.out.write("WHERE ");
                }
                filter.accept((FilterVisitor)this, null);
            }
            catch (IOException ioe) {
                LOGGER.warning("Unable to export filter" + ioe);
                throw new FilterToSQLException("Problem writing filter: ", (Throwable)ioe);
            }
        } else {
            throw new FilterToSQLException("Filter type not supported");
        }
    }

    public GeoPkgFilterToSQL(Writer out) {
        super(out);
    }

    public Object visit(Literal expression, Object context) throws RuntimeException {
        if (!this.isPrepareEnabled()) {
            return super.visit(expression, context);
        }
        Object literalValue = this.evaluateLiteral(expression, context instanceof Class ? (Class)context : null);
        this.literalValues.add(literalValue);
        this.SRIDs.add(this.currentSRID);
        this.dimensions.add(this.currentDimension);
        this.descriptors.add(context instanceof AttributeDescriptor ? (AttributeDescriptor)context : null);
        Class<?> clazz = null;
        if (context instanceof Class) {
            clazz = (Class<?>)context;
        } else if (literalValue != null) {
            clazz = literalValue.getClass();
        }
        this.literalTypes.add(clazz);
        try {
            if (literalValue == null || this.dialect == null) {
                this.out.write("?");
            } else {
                StringBuffer sb = new StringBuffer();
                if (Geometry.class.isAssignableFrom(literalValue.getClass())) {
                    int srid = this.currentSRID != null ? this.currentSRID : -1;
                    int dimension = this.currentDimension != null ? this.currentDimension : -1;
                    this.dialect.prepareGeometryValue((Geometry)literalValue, dimension, srid, Geometry.class, sb);
                } else if (Time.class.isAssignableFrom(literalValue.getClass())) {
                    sb.append("time(?,'localtime')");
                } else if (Timestamp.class.isAssignableFrom(literalValue.getClass())) {
                    sb.append("datetime(?,'localtime')");
                } else if (Date.class.isAssignableFrom(literalValue.getClass())) {
                    sb.append("date(?,'localtime')");
                } else if (this.encodingFunction) {
                    this.dialect.prepareFunctionArgument(clazz, sb);
                } else {
                    sb.append("?");
                }
                this.out.write(sb.toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return context;
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        AttributeDescriptor attribute = (AttributeDescriptor)property.evaluate((Object)this.featureType, AttributeDescriptor.class);
        Geometry reference = (Geometry)geometry.evaluate(null, Geometry.class);
        Envelope envelope = reference.getEnvelopeInternal();
        if (envelope == null) {
            throw new IllegalArgumentException("Invalid BBOX filter specification, it's defined against a NULL envelope");
        }
        envelope.expandBy(1.0E-11);
        try {
            if (this.primaryKey != null && attribute != null && Boolean.TRUE.equals(attribute.getUserData().get("hasGeopkgSpatialIndex"))) {
                PrimaryKeyColumn pk = (PrimaryKeyColumn)this.primaryKey.getColumns().get(0);
                String pkName = pk.getName();
                filterFactory.property(pkName).accept((ExpressionVisitor)this, null);
                StringBuffer sb = new StringBuffer();
                this.dialect.encodeTableName("rtree_" + this.featureType.getTypeName() + "_" + attribute.getLocalName(), sb);
                String spatial_index = sb.toString();
                this.out.write(" IN (SELECT id FROM " + spatial_index + " r WHERE");
                this.out.write(" r.maxx >= " + envelope.getMinX());
                this.out.write(" AND r.minx <= " + envelope.getMaxX());
                this.out.write(" AND r.maxy >= " + envelope.getMinY());
                this.out.write(" AND r.miny <= " + envelope.getMaxY());
                this.out.write(")");
            } else {
                StringBuffer sb = new StringBuffer();
                this.dialect.encodeColumnName(null, attribute.getLocalName(), sb);
                String encodedPropertyName = sb.toString();
                this.out.write("(ST_MaxX(" + encodedPropertyName + ") >= " + envelope.getMinX() + " AND\n");
                this.out.write("ST_MinX(" + encodedPropertyName + ") <= " + envelope.getMaxX() + " AND\n");
                this.out.write("ST_MaxY(" + encodedPropertyName + ") >= " + envelope.getMinY() + " AND\n");
                this.out.write("ST_MinY(" + encodedPropertyName + ") <= " + envelope.getMaxY() + ")\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failure encoding the SQL equivalent for a spatial filter", e);
        }
        return extraData;
    }
}

