/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.primitive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.geotools.geometry.iso.coordinate.CurveSegmentImpl;
import org.geotools.geometry.iso.coordinate.DirectPositionImpl;
import org.geotools.geometry.iso.coordinate.EnvelopeImpl;
import org.geotools.geometry.iso.coordinate.GeometryFactoryImpl;
import org.geotools.geometry.iso.coordinate.LineStringImpl;
import org.geotools.geometry.iso.coordinate.PointArrayImpl;
import org.geotools.geometry.iso.coordinate.PositionImpl;
import org.geotools.geometry.iso.io.GeometryToString;
import org.geotools.geometry.iso.operation.IsSimpleOp;
import org.geotools.geometry.iso.operation.Merger;
import org.geotools.geometry.iso.primitive.CurveBoundaryImpl;
import org.geotools.geometry.iso.primitive.CurveProxy;
import org.geotools.geometry.iso.primitive.OrientableCurveImpl;
import org.geotools.geometry.iso.primitive.PointImpl;
import org.geotools.geometry.iso.primitive.PrimitiveFactoryImpl;
import org.geotools.geometry.iso.util.DoubleOperation;
import org.geotools.geometry.iso.util.algorithmND.AlgoPointND;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.Geometry;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.TransfiniteSet;
import org.opengis.geometry.complex.CompositeCurve;
import org.opengis.geometry.coordinate.LineSegment;
import org.opengis.geometry.coordinate.LineString;
import org.opengis.geometry.coordinate.ParamForPoint;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.primitive.Curve;
import org.opengis.geometry.primitive.CurveBoundary;
import org.opengis.geometry.primitive.CurveSegment;
import org.opengis.geometry.primitive.OrientableCurve;
import org.opengis.geometry.primitive.OrientablePrimitive;
import org.opengis.geometry.primitive.Point;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class CurveImpl
extends OrientableCurveImpl
implements Curve {
    private static final long serialVersionUID = -9117646009629975742L;
    private List<CurveSegment> curveSegments = null;
    private EnvelopeImpl envelope = null;
    protected CurveBoundaryImpl boundary = null;

    public CurveImpl(CoordinateReferenceSystem crs, List<? extends CurveSegment> segments) throws IllegalArgumentException {
        super(crs);
        this.initialize(segments);
    }

    public CurveImpl(LineSegment edge) {
        this(edge.getControlPoints().getCoordinateReferenceSystem(), Collections.singletonList(edge));
    }

    private void initialize(List<? extends CurveSegment> segments) {
        DirectPositionImpl copy;
        if (segments == null || segments.isEmpty()) {
            throw new IllegalArgumentException("The list of CurveSegments ist empty.");
        }
        this.curveSegments = segments;
        Iterator<? extends CurveSegment> it = segments.iterator();
        CurveSegmentImpl cs0 = (CurveSegmentImpl)it.next();
        cs0.setCurve(this);
        this.envelope = new EnvelopeImpl(cs0.getEnvelope());
        Position p0 = cs0.getStartPosition();
        CurveSegmentImpl cs1 = null;
        while (it.hasNext()) {
            cs1 = (CurveSegmentImpl)it.next();
            cs1.setCurve(this);
            this.envelope.expand(cs1.getEnvelope());
            if (!cs0.getEndPoint().equals((Object)cs1.getStartPoint())) {
                throw new IllegalArgumentException("Curvesegments are not continuous. Following curve segments are disjoint:" + cs0 + " and " + cs1);
            }
            cs0 = cs1;
        }
        Position p1 = cs0.getEndPosition();
        Point pt0 = this.toPoint(p0);
        Point pt1 = this.toPoint(p1);
        if (pt0 == null) {
            copy = new DirectPositionImpl(p0.getDirectPosition());
            pt0 = new PointImpl(copy);
        }
        if (pt1 == null) {
            copy = new DirectPositionImpl(p1.getDirectPosition());
            pt1 = new PointImpl(copy);
        }
        this.boundary = this.calculateBoundary(pt0, pt1);
        this.calculateParametrisation();
    }

    private Point toPoint(Position position) {
        if (position instanceof Point) {
            return (Point)position;
        }
        return new PointImpl(new DirectPositionImpl(position));
    }

    private CurveBoundaryImpl calculateBoundary(Point start, Point end) {
        if (start.equals((TransfiniteSet)end)) {
            return null;
        }
        return new CurveBoundaryImpl(this.getCoordinateReferenceSystem(), start, end);
    }

    @Override
    public OrientableCurve[] getProxy() {
        return super.getProxy();
    }

    @Override
    public CurveImpl clone() throws CloneNotSupportedException {
        List<DirectPosition> dPList = this.asDirectPositions();
        ArrayList<DirectPositionImpl> newDPList = new ArrayList<DirectPositionImpl>();
        for (int i = 0; i < dPList.size(); ++i) {
            newDPList.add(new DirectPositionImpl(dPList.get(i)));
        }
        LinkedList<Position> rPositions = new LinkedList<Position>();
        for (int i = 0; i < newDPList.size(); ++i) {
            rPositions.add(new PositionImpl((DirectPosition)newDPList.get(i)));
        }
        LinkedList<Position> positionList = rPositions;
        LineStringImpl lineString = new LineStringImpl(new PointArrayImpl((List<Position>)positionList), 0.0);
        ArrayList<LineStringImpl> segments = new ArrayList<LineStringImpl>();
        segments.add(lineString);
        return new CurveImpl(this.crs, segments);
    }

    @Override
    protected OrientablePrimitive createProxy() {
        return new CurveProxy(this);
    }

    @Override
    public CurveBoundary getBoundary() {
        return this.boundary;
    }

    @Override
    public Envelope getEnvelope() {
        return this.envelope;
    }

    public void split(double distance) {
        for (CurveSegment curveSegment : this.curveSegments) {
            ((CurveSegmentImpl)curveSegment).split(distance);
        }
    }

    protected CurveSegmentImpl getSegmentAt(double dist) {
        if (this.curveSegments == null) {
            return null;
        }
        double length = 0.0;
        for (CurveSegment curveSegment : this.curveSegments) {
            if (!(dist < (length = DoubleOperation.add(length, ((CurveSegmentImpl)curveSegment).length())))) continue;
            return (CurveSegmentImpl)curveSegment;
        }
        return (CurveSegmentImpl)this.curveSegments.get(this.curveSegments.size() - 1);
    }

    public DirectPosition getStartPoint() {
        return this.curveSegments.get(0).getStartPoint();
    }

    public DirectPosition getEndPoint() {
        return this.curveSegments.get(this.curveSegments.size() - 1).getEndPoint();
    }

    public ParamForPoint getParamForPoint(DirectPosition p) {
        ParamForPoint paramForPoints = this.curveSegments.get(0).getParamForPoint(p);
        double minDistanceSquare = AlgoPointND.getDistanceSquare(p.getCoordinate(), paramForPoints.getPosition().getCoordinate());
        double actDistanceSquare = 0.0;
        for (int i = 1; i < this.curveSegments.size(); ++i) {
            ParamForPoint paramForPoints1 = this.curveSegments.get(i).getParamForPoint(p);
            actDistanceSquare = AlgoPointND.getDistanceSquare(p.getCoordinate(), paramForPoints1.getPosition().getCoordinate());
            if (!(actDistanceSquare <= minDistanceSquare)) continue;
        }
        return paramForPoints;
    }

    public DirectPosition forParam(double distance) {
        int index;
        if (distance < this.getStartParam() || distance > this.getEndParam()) {
            throw new IllegalArgumentException("Distance parameter not in parametrisation range.");
        }
        for (index = 0; index < this.curveSegments.size() && distance > this.curveSegments.get(index).getEndParam(); ++index) {
        }
        return this.curveSegments.get(index).forParam(distance);
    }

    public double length(double par1, double par2) {
        if (par1 < 0.0 || par2 > this.length()) {
            throw new IllegalArgumentException("Parameter out of parametrisation range.");
        }
        return DoubleOperation.subtract(par2, par1);
    }

    public double length() {
        return Math.abs(DoubleOperation.subtract(this.getEndParam(), this.getStartParam()));
    }

    public List<LineSegment> asLineSegments() {
        ArrayList<LineSegment> mergedSegments = new ArrayList<LineSegment>();
        for (CurveSegment curveSegment : this.curveSegments) {
            LineString lineString = curveSegment.asLineString(0.0, 0.0);
            List lineSegments = lineString.asLineSegments();
            for (LineSegment lineSegment : lineSegments) {
                mergedSegments.add(lineSegment);
            }
        }
        return mergedSegments;
    }

    public LineStringImpl asLineString(double spacing, double offset) {
        if (this.curveSegments.isEmpty()) {
            return null;
        }
        CurveSegment seg = this.curveSegments.get(0);
        LineStringImpl ls = (LineStringImpl)seg.asLineString(spacing, offset);
        LineStringImpl result = new LineStringImpl(ls);
        for (int i = 1; i < this.curveSegments.size(); ++i) {
            seg = this.curveSegments.get(i);
            ls = (LineStringImpl)seg.asLineString(spacing, offset);
            result = result.merge(ls);
        }
        result.setStartParam(this.getStartParam());
        result.setEndParam(this.getEndParam());
        return result;
    }

    public LineStringImpl asLineString() {
        return this.asLineString(0.0, 0.0);
    }

    @Override
    public int getDimension(DirectPosition point) {
        if (point == null) {
            return 1;
        }
        return Math.min(point.getDimension(), 1);
    }

    private void calculateParametrisation() {
        if (this.curveSegments == null || this.curveSegments.size() == 0) {
            throw new IllegalArgumentException("Segment array not set.");
        }
        double tmpLineLength = 0.0;
        double totalValue = 0.0;
        for (int i = 0; i < this.curveSegments.size(); ++i) {
            tmpLineLength = ((LineStringImpl)this.curveSegments.get(i)).length();
            ((LineStringImpl)this.curveSegments.get(i)).setStartParam(totalValue);
            totalValue = DoubleOperation.add(totalValue, tmpLineLength);
            ((LineStringImpl)this.curveSegments.get(i)).setEndParam(totalValue);
        }
    }

    @Override
    public DirectPosition getRepresentativePoint() {
        return this.forConstructiveParam(0.5);
    }

    public boolean isSimple() {
        IsSimpleOp simpleOp = new IsSimpleOp();
        return simpleOp.isSimple(this);
    }

    public List<CurveSegment> getSegments() {
        return this.curveSegments;
    }

    @Override
    public CompositeCurve getComposite() {
        return null;
    }

    public double[] getTangent(double distance) {
        int i;
        if (distance < this.getStartParam() || distance > this.getEndParam()) {
            throw new IllegalArgumentException("Distance parameter not in parametrisation range.");
        }
        for (i = 0; this.curveSegments.get(i).getEndParam() < distance && i < this.curveSegments.size(); ++i) {
        }
        return this.curveSegments.get(i).getTangent(distance);
    }

    public double getStartParam() {
        return 0.0;
    }

    public double getEndParam() {
        return this.curveSegments.get(this.curveSegments.size() - 1).getEndParam();
    }

    public double getStartConstructiveParam() {
        return 0.0;
    }

    public double getEndConstructiveParam() {
        return 1.0;
    }

    public DirectPosition forConstructiveParam(double cp) {
        double par = DoubleOperation.mult(cp, this.length());
        return this.forParam(par);
    }

    public double length(Position point1, Position point2) {
        if (point1 == null && point2 == null) {
            return this.length();
        }
        ParamForPoint startParams = this.getParamForPoint(point1.getDirectPosition());
        ParamForPoint endParams = this.getParamForPoint(point2.getDirectPosition());
        double minDistance = Math.abs(DoubleOperation.subtract(startParams.getDistance(), endParams.getDistance()));
        return minDistance;
    }

    public List<DirectPosition> asDirectPositions() {
        ArrayList<DirectPosition> rList = new ArrayList<DirectPosition>();
        CurveSegment tSegment = null;
        for (int i = 0; i < this.curveSegments.size(); ++i) {
            tSegment = this.curveSegments.get(i);
            LineStringImpl tLineString = (LineStringImpl)tSegment;
            for (LineSegment tLineSegment : tLineString.asLineSegments()) {
                rList.add(tLineSegment.getStartPoint().getDirectPosition());
            }
        }
        rList.add(tSegment.getEndPoint());
        return rList;
    }

    public CurveImpl merge(CurveImpl other) {
        Merger merger = new Merger(this.crs);
        return merger.merge(this, other);
    }

    public String toString() {
        return GeometryToString.getString(this);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.curveSegments == null ? 0 : this.curveSegments.hashCode());
        result = 31 * result + (this.envelope == null ? 0 : this.envelope.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CurveImpl other = (CurveImpl)obj;
        if (this.curveSegments == null ? other.curveSegments != null : !this.curveSegments.equals(other.curveSegments)) {
            return false;
        }
        return !(this.envelope == null ? other.envelope != null : !this.envelope.equals(other.envelope));
    }

    @Override
    public Geometry transform(CoordinateReferenceSystem newCRS, MathTransform transform) throws MismatchedDimensionException, TransformException {
        PrimitiveFactoryImpl primitiveFactory = new PrimitiveFactoryImpl(newCRS, this.getPositionFactory());
        GeometryFactoryImpl geometryFactory = new GeometryFactoryImpl(newCRS, this.getPositionFactory());
        DirectPositionImpl dp1 = null;
        List<DirectPosition> currentpositions = this.asDirectPositions();
        Iterator<DirectPosition> iter = currentpositions.iterator();
        ArrayList<DirectPositionImpl> newpositions = new ArrayList<DirectPositionImpl>();
        while (iter.hasNext()) {
            DirectPosition thispos = iter.next();
            dp1 = new DirectPositionImpl(newCRS);
            dp1 = (DirectPositionImpl)transform.transform(thispos, (DirectPosition)dp1);
            newpositions.add(dp1);
        }
        LineString lineString = geometryFactory.createLineString(newpositions);
        List<LineString> curveSegmentList = Collections.singletonList(lineString);
        CurveImpl newCurve = (CurveImpl)primitiveFactory.createCurve(curveSegmentList);
        return newCurve;
    }
}

