/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.store.ContentFeatureStore;
import org.geotools.data.store.ContentState;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.BoundingBox;

public class EventContentFeatureWriter
implements FeatureWriter<SimpleFeatureType, SimpleFeature> {
    ContentState state;
    SimpleFeature feature;
    ContentFeatureStore store;
    FeatureWriter<SimpleFeatureType, SimpleFeature> writer;

    public EventContentFeatureWriter(ContentFeatureStore store, FeatureWriter<SimpleFeatureType, SimpleFeature> writer) {
        this.store = store;
        this.writer = writer;
        this.state = store.getState();
        Transaction t = this.state.getTransaction();
        if (t != Transaction.AUTO_COMMIT) {
            t.putState((Object)this, (Transaction.State)new EventContentTransactionState());
        }
    }

    public SimpleFeatureType getFeatureType() {
        return (SimpleFeatureType)this.writer.getFeatureType();
    }

    public SimpleFeature next() throws IOException {
        this.feature = (SimpleFeature)this.writer.next();
        return this.feature;
    }

    public void remove() throws IOException {
        this.state.fireFeatureRemoved((FeatureSource<?, ?>)this.store, (Feature)this.feature);
        this.writer.remove();
    }

    public void write() throws IOException {
        this.writer.write();
        if (this.feature == null) {
            throw new IOException("No feature available to write");
        }
        if (this.writer.hasNext()) {
            ReferencedEnvelope bounds = ReferencedEnvelope.reference((BoundingBox)this.feature.getBounds());
            this.state.fireFeatureUpdated((FeatureSource<?, ?>)this.store, (Feature)this.feature, bounds);
            this.feature = null;
        } else {
            this.state.fireFeatureAdded((FeatureSource<?, ?>)this.store, (Feature)this.feature);
        }
    }

    public boolean hasNext() throws IOException {
        return this.writer.hasNext();
    }

    public void close() throws IOException {
        Transaction t = this.state.getTransaction();
        if (t != Transaction.AUTO_COMMIT) {
            t.removeState((Object)this);
        }
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        this.feature = null;
    }

    class EventContentTransactionState
    implements Transaction.State {
        EventContentTransactionState() {
        }

        public void commit() throws IOException {
            EventContentFeatureWriter.this.store.getState().fireBatchFeatureEvent(true);
        }

        public void rollback() throws IOException {
            EventContentFeatureWriter.this.store.getState().fireBatchFeatureEvent(false);
        }

        public void setTransaction(Transaction transaction) {
        }

        public void addAuthorization(String AuthID) throws IOException {
        }
    }
}

