/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.geotools.data.DataSourceException;
import org.geotools.data.Diff;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.store.ContentFeatureStore;
import org.geotools.data.store.ContentState;
import org.geotools.factory.Hints;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.BoundingBox;

public class DiffContentFeatureWriter
implements FeatureWriter<SimpleFeatureType, SimpleFeature> {
    protected FeatureReader<SimpleFeatureType, SimpleFeature> reader;
    ContentState state;
    protected Diff diff;
    SimpleFeature next;
    SimpleFeature live;
    SimpleFeature current;
    ContentFeatureStore store;

    public DiffContentFeatureWriter(ContentFeatureStore store, Diff diff, FeatureReader<SimpleFeatureType, SimpleFeature> reader) {
        this.store = store;
        this.reader = reader;
        this.state = store.getState();
        this.diff = diff;
    }

    public SimpleFeatureType getFeatureType() {
        return (SimpleFeatureType)this.reader.getFeatureType();
    }

    public SimpleFeature next() throws IOException {
        SimpleFeatureType type = this.getFeatureType();
        if (this.hasNext()) {
            this.live = this.next;
            this.next = null;
            this.current = SimpleFeatureBuilder.copy((SimpleFeature)this.live);
            return this.current;
        }
        this.live = null;
        this.next = null;
        this.current = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[type.getAttributeCount()], (String)("new" + this.diff.nextFID));
        ++this.diff.nextFID;
        return this.current;
    }

    public void remove() throws IOException {
        if (this.live != null) {
            this.diff.remove(this.live.getID());
            this.state.fireFeatureRemoved((FeatureSource<?, ?>)this.store, (Feature)this.live);
            this.live = null;
            this.current = null;
        } else if (this.current != null) {
            this.current = null;
        }
    }

    public void write() throws IOException {
        if (this.live != null) {
            this.diff.modify(this.live.getID(), this.current);
            ReferencedEnvelope bounds = ReferencedEnvelope.reference((BoundingBox)this.current.getBounds());
            this.state.fireFeatureUpdated((FeatureSource<?, ?>)this.store, (Feature)this.live, bounds);
            this.live = null;
            this.current = null;
        } else if (this.live == null && this.current != null) {
            String fid = this.current.getID();
            if (Boolean.TRUE.equals(this.current.getUserData().get(Hints.USE_PROVIDED_FID)) && this.current.getUserData().containsKey(Hints.PROVIDED_FID)) {
                fid = (String)this.current.getUserData().get(Hints.PROVIDED_FID);
                Map userData = this.current.getUserData();
                this.current = SimpleFeatureBuilder.build((SimpleFeatureType)this.current.getFeatureType(), (List)this.current.getAttributes(), (String)fid);
                this.current.getUserData().putAll(userData);
            }
            this.diff.add(fid, this.current);
            this.state.fireFeatureAdded((FeatureSource<?, ?>)this.store, (Feature)this.current);
            this.current = null;
        } else {
            throw new IOException("No feature available to write");
        }
    }

    public boolean hasNext() throws IOException {
        if (this.next != null) {
            return true;
        }
        this.live = null;
        this.current = null;
        if (this.reader.hasNext()) {
            try {
                this.next = (SimpleFeature)this.reader.next();
            }
            catch (NoSuchElementException e) {
                throw new DataSourceException("No more content", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        this.current = null;
        this.live = null;
        this.next = null;
        this.diff = null;
    }
}

