/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.directory;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.directory.DataStoreSoftReference;
import org.geotools.data.directory.DirectoryWatcher;
import org.geotools.data.directory.FactoryAdapter;
import org.geotools.data.directory.FileStoreFactory;
import org.geotools.data.directory.ImmediateDirectoryWatcher;
import org.geotools.util.logging.Logging;

class DirectoryTypeCache {
    static final Logger LOGGER = Logging.getLogger(DirectoryTypeCache.class);
    Map<String, FileEntry> ftCache = new ConcurrentHashMap<String, FileEntry>();
    File directory;
    DirectoryWatcher watcher;
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    FileStoreFactory factory;

    DirectoryTypeCache(File directory, FileStoreFactory factory) throws IOException {
        if (directory == null) {
            throw new NullPointerException("Directory parameter should be not null");
        }
        if (!directory.exists()) {
            throw new IllegalArgumentException("Specified directory does not exists: " + directory.getAbsolutePath());
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Specified path is not a directory, it'a s file instead: " + directory.getAbsolutePath());
        }
        this.directory = directory;
        this.factory = factory;
        this.watcher = new ImmediateDirectoryWatcher(directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataStore getDataStore(String typeName, boolean forceUpdate) throws IOException {
        this.lock.readLock().lock();
        try {
            FileEntry fileEntry;
            if (forceUpdate) {
                this.updateCache();
            }
            if ((fileEntry = this.ftCache.get(typeName)) == null) {
                throw new IOException("Not available: " + typeName);
            }
            DataStore dataStore = fileEntry.getStore(true);
            return dataStore;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getTypeNames() throws IOException {
        this.lock.readLock().lock();
        try {
            this.updateCache();
            Set<String> set = this.ftCache.keySet();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<DataStore> getDataStores() {
        ArrayList<DataStore> stores = new ArrayList<DataStore>();
        this.lock.readLock().lock();
        try {
            for (FileEntry entry : this.ftCache.values()) {
                try {
                    DataStore store = entry.getStore(false);
                    if (store == null) continue;
                    stores.add(store);
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, "Error occurred trying to grab a datastore", e);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return stores;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCache() throws IOException {
        if (this.watcher.isStale()) {
            this.lock.readLock().unlock();
            this.lock.writeLock().lock();
            try {
                if (this.watcher.isStale()) {
                    this.watcher.mark();
                    this.refreshCacheContents();
                }
            }
            finally {
                this.lock.readLock().lock();
                this.lock.writeLock().unlock();
            }
        }
    }

    void refreshCacheContents() throws IOException {
        TreeMap<String, FileEntry> result = new TreeMap<String, FileEntry>();
        HashMap<File, FileEntry> fileCache = new HashMap<File, FileEntry>();
        for (FileEntry entry : this.ftCache.values()) {
            fileCache.put(entry.file, entry);
        }
        for (File file : this.directory.listFiles()) {
            DataStore store;
            if (file.isDirectory()) continue;
            FileEntry entry = (FileEntry)fileCache.get(file);
            if (entry == null && (store = this.factory.getDataStore(file)) != null) {
                entry = new FileEntry(file, store);
            }
            if (entry == null) continue;
            for (String typeName : entry.getStore(true).getTypeNames()) {
                if (!result.containsKey(typeName)) {
                    result.put(typeName, entry);
                    continue;
                }
                LOGGER.log(Level.WARNING, "Type name " + typeName + " is available from multiple datastores");
            }
        }
        HashSet<String> removedFTs = new HashSet<String>(this.ftCache.keySet());
        removedFTs.removeAll(result.keySet());
        HashSet<FileEntry> disposable = new HashSet<FileEntry>();
        for (String removedFT : removedFTs) {
            disposable.add(this.ftCache.remove(removedFT));
        }
        for (FileEntry entry : result.values()) {
            disposable.remove(entry);
        }
        for (FileEntry entry : disposable) {
            entry.dispose();
        }
        HashSet added = new HashSet(result.keySet());
        added.removeAll(this.ftCache.keySet());
        for (String newFeatureType : added) {
            this.ftCache.put(newFeatureType, (FileEntry)result.get(newFeatureType));
        }
    }

    List<FactoryAdapter> lookupFileDataStores() {
        ArrayList<FactoryAdapter> adapters = new ArrayList<FactoryAdapter>();
        Iterator it = DataStoreFinder.getAllDataStores();
        while (it.hasNext()) {
            DataStoreFactorySpi factory = (DataStoreFactorySpi)it.next();
            DataAccessFactory.Param[] params = factory.getParametersInfo();
            if (params == null) {
                LOGGER.fine("DataStore factory " + factory + " returns null from getParametersInfo!");
                continue;
            }
            DataAccessFactory.Param fileParam = null;
            DataAccessFactory.Param nsParam = null;
            for (DataAccessFactory.Param param : params) {
                Class type = param.type;
                String key = param.key;
                if (File.class.isAssignableFrom(type) || URL.class.isAssignableFrom(type)) {
                    fileParam = param;
                    continue;
                }
                if (!key.equalsIgnoreCase("namespace") || !String.class.isAssignableFrom(type) && !URI.class.isAssignableFrom(type)) continue;
                nsParam = param;
            }
            if (fileParam == null) continue;
            adapters.add(new FactoryAdapter(factory, fileParam, nsParam));
        }
        return adapters;
    }

    void dispose() {
        for (FileEntry entry : this.ftCache.values()) {
            entry.dispose();
        }
    }

    class FileEntry {
        File file;
        SoftReference<DataStore> ref;

        public FileEntry(File file, DataStore store) {
            this.file = file;
            this.ref = new DataStoreSoftReference(store);
        }

        DataStore getStore(boolean force) throws IOException {
            DataStore store;
            DataStore dataStore = store = this.ref != null ? this.ref.get() : null;
            if (store == null && force) {
                store = DirectoryTypeCache.this.factory.getDataStore(this.file);
                this.ref = new DataStoreSoftReference(store);
            }
            return store;
        }

        void dispose() {
            DataStore store;
            DataStore dataStore = store = this.ref != null ? this.ref.get() : null;
            if (store != null) {
                store.dispose();
            }
            this.ref.clear();
        }
    }

    class DirectoryFilter
    implements FileFilter {
        DirectoryFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return !pathname.isDirectory();
        }
    }
}

