/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.txt;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.cql2.CQLFilterBuilder;
import org.geotools.filter.text.cql2.IToken;
import org.geotools.filter.text.cql2.Result;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.identity.FeatureId;

final class TXTFilterBuilder
extends CQLFilterBuilder {
    public TXTFilterBuilder(String cqlSource, FilterFactory filterFactory) {
        super(cqlSource, filterFactory);
    }

    public FeatureId buildFeatureID(IToken token) {
        String strId = this.removeQuotes(((Object)token).toString());
        FeatureId id = this.getFilterFactory().featureId(strId);
        return id;
    }

    public Id buildFilterId(int nodeFeatureId) throws CQLException {
        Result result;
        int node;
        LinkedList<FeatureId> idList = new LinkedList<FeatureId>();
        while (!this.getResultStack().empty() && (node = (result = this.getResultStack().peek()).getNodeType()) == nodeFeatureId) {
            FeatureId id = (FeatureId)result.getBuilt();
            idList.add(id);
            this.getResultStack().popResult();
        }
        assert (idList.size() >= 1) : "must have one or more FeatureIds";
        Collections.reverse(idList);
        LinkedHashSet idSet = new LinkedHashSet(idList);
        Id filter = this.getFilterFactory().id(idSet);
        return filter;
    }

    public Literal bulidNegativeNumber() throws CQLException {
        Literal literal = this.getResultStack().popLiteral();
        String strNumber = "-" + literal.getValue();
        Object value = literal.getValue();
        Number number = null;
        if (value instanceof Double) {
            number = Double.parseDouble(strNumber);
        } else if (value instanceof Float) {
            number = Float.valueOf(Float.parseFloat(strNumber));
        } else if (value instanceof Integer) {
            number = Integer.parseInt(strNumber);
        } else if (value instanceof Long) {
            number = Long.parseLong(strNumber);
        } else assert (false) : "Number instnce is expected";
        Literal signedNumber = this.getFilterFactory().literal((Object)strNumber);
        return signedNumber;
    }
}

