/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql2;

import java.security.InvalidParameterException;
import java.util.Date;
import org.geotools.filter.text.cql2.DurationUtil;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Literal;

class PeriodNode {
    private Literal begin = null;
    private Literal end = null;

    private PeriodNode(Literal begin, Literal end) {
        if (!(begin.getValue() instanceof Date)) {
            throw new InvalidParameterException("begin parameter must be Literal with Date");
        }
        if (!(begin.getValue() instanceof Date)) {
            throw new InvalidParameterException("end paremeter must be Literal with Date");
        }
        this.begin = begin;
        this.end = end;
    }

    public static PeriodNode createPeriodDateAndDate(Literal beginDate, Literal endDate) {
        PeriodNode period = new PeriodNode(beginDate, endDate);
        return period;
    }

    public static PeriodNode createPeriodDateAndDuration(Literal date, Literal duration, FilterFactory filterFactory) {
        Date firstDate = (Date)date.getValue();
        String strDuration = (String)duration.getValue();
        Date lastDate = DurationUtil.addDurationToDate(firstDate, strDuration);
        Literal literalLastDate = filterFactory.literal((Object)lastDate);
        PeriodNode period = new PeriodNode(date, literalLastDate);
        return period;
    }

    public static PeriodNode createPeriodDurationAndDate(Literal duration, Literal date, FilterFactory filterFactory) {
        Date lastDate = (Date)date.getValue();
        String strDuration = (String)duration.getValue();
        Date firstDate = DurationUtil.subtractDurationToDate(lastDate, strDuration);
        Literal literalFirstDate = filterFactory.literal((Object)firstDate);
        PeriodNode period = new PeriodNode(literalFirstDate, date);
        return period;
    }

    public Literal getBeginning() {
        return this.begin;
    }

    public Literal getEnding() {
        return this.end;
    }
}

