/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql2;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.geotools.filter.FilterTransformer;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.cql2.CompilerFactory;
import org.geotools.filter.text.cql2.FilterToCQL;
import org.geotools.filter.text.cql2.ICompiler;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CQL {
    protected CQL() {
    }

    public static Filter toFilter(String cqlPredicate) throws CQLException {
        Filter filter = CQL.toFilter(cqlPredicate, null);
        return filter;
    }

    public static Filter toFilter(String cqlPredicate, FilterFactory filterFactory) throws CQLException {
        ICompiler compiler = CompilerFactory.makeCompiler(CompilerFactory.Language.CQL, cqlPredicate, filterFactory);
        compiler.compileFilter();
        Filter result = compiler.getFilter();
        return result;
    }

    public static Expression toExpression(String cqlExpression) throws CQLException {
        return CQL.toExpression(cqlExpression, null);
    }

    public static Expression toExpression(String cqlExpression, FilterFactory filterFactory) throws CQLException {
        ICompiler compiler = CompilerFactory.makeCompiler(CompilerFactory.Language.CQL, cqlExpression, filterFactory);
        compiler.compileExpression();
        Expression builtFilter = compiler.getExpression();
        return builtFilter;
    }

    public static List<Filter> toFilterList(String cqlFilterList) throws CQLException {
        List<Filter> filters = CQL.toFilterList(cqlFilterList, null);
        return filters;
    }

    public static String toCQL(Filter filter) {
        FilterToCQL toCQL = new FilterToCQL();
        StringBuffer output = (StringBuffer)filter.accept((FilterVisitor)toCQL, (Object)new StringBuffer());
        return output.toString();
    }

    public static String toCQL(Expression expression) {
        FilterToCQL toCQL = new FilterToCQL();
        StringBuffer output = (StringBuffer)expression.accept((ExpressionVisitor)toCQL, (Object)new StringBuffer());
        return output.toString();
    }

    public static List<Filter> toFilterList(String cqlSourceFilterList, FilterFactory filterFactory) throws CQLException {
        ICompiler compiler = CompilerFactory.makeCompiler(CompilerFactory.Language.CQL, cqlSourceFilterList, filterFactory);
        compiler.compileFilterList();
        List<Filter> results = compiler.getFilterList();
        return results;
    }

    public static final void main(String[] args) {
        System.out.println("Expression Tester (\"quit\" to finish)");
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        FilterTransformer filterTransformer = new FilterTransformer();
        filterTransformer.setIndentation(4);
        while (true) {
            System.out.print(">");
            String line = null;
            try {
                line = reader.readLine();
                if (line.equals("quit")) {
                    System.out.println("Bye!");
                    break;
                }
                Filter newFilter = CQL.toFilter(line);
                filterTransformer.transform((Object)newFilter, (OutputStream)System.out);
                System.out.println();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            catch (CQLException cqlex) {
                System.out.println(cqlex.getSyntaxError());
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
        }
    }
}

