/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.filter;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Or;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;

public class ArcSdeSimplifyingFilterVisitor
extends SimplifyingFilterVisitor {
    static final FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2(null);
    static final Set<Class<? extends BinarySpatialOperator>> SPATIAL_OPERATIONS = new HashSet<Class<? extends BinarySpatialOperator>>();
    private SimpleFeatureType schema;

    public ArcSdeSimplifyingFilterVisitor(SimpleFeatureType schema) {
        this.schema = schema;
    }

    public Object visit(Or filter, Object extraData) {
        Filter simplified = (Filter)super.visit(filter, extraData);
        if (simplified instanceof Or) {
            HashMap<String, ArrayList<SpatialOperation>> spatialOps = new HashMap<String, ArrayList<SpatialOperation>>();
            ArrayList<Object> otherFilters = new ArrayList<Object>();
            List children = ((Or)simplified).getChildren();
            for (Filter child : children) {
                if (child instanceof BinarySpatialOperator) {
                    BinarySpatialOperator bso = (BinarySpatialOperator)child;
                    String name = null;
                    SpatialOperation so = null;
                    if (bso.getExpression1() instanceof PropertyName && bso.getExpression2() instanceof Literal) {
                        name = ((PropertyName)bso.getExpression1()).getPropertyName();
                        so = new SpatialOperation(bso);
                    } else if (bso.getExpression2() instanceof PropertyName && bso.getExpression1() instanceof Literal) {
                        name = ((PropertyName)bso.getExpression2()).getPropertyName();
                        so = new SpatialOperation(bso);
                    }
                    if (name != null && so != null) {
                        ArrayList<SpatialOperation> list;
                        if ("".equals(name) && this.schema.getGeometryDescriptor() != null) {
                            name = this.schema.getGeometryDescriptor().getLocalName();
                        }
                        if ((list = (ArrayList<SpatialOperation>)spatialOps.get(name)) == null) {
                            list = new ArrayList<SpatialOperation>();
                            spatialOps.put(name, list);
                        }
                        list.add(so);
                        continue;
                    }
                    otherFilters.add(child);
                    continue;
                }
                otherFilters.add(child);
            }
            ArrayList<Filter> mergedFilters = new ArrayList<Filter>();
            for (String property : spatialOps.keySet()) {
                List propertyFilters = (List)spatialOps.get(property);
                while (propertyFilters.size() > 0) {
                    SpatialOperation main = (SpatialOperation)propertyFilters.get(0);
                    ArrayList<SpatialOperation> toMerge = new ArrayList<SpatialOperation>();
                    toMerge.add(main);
                    int j = 1;
                    while (j < propertyFilters.size()) {
                        SpatialOperation secondary = (SpatialOperation)propertyFilters.get(j);
                        if (secondary.operation == main.operation || secondary.operation == BBOX.class && main.operation == Intersects.class || secondary.operation == Intersects.class && main.operation == BBOX.class) {
                            toMerge.add(secondary);
                            propertyFilters.remove(j);
                            continue;
                        }
                        ++j;
                    }
                    if (toMerge.size() == 1) {
                        otherFilters.add(main.op);
                    } else {
                        try {
                            Filter merged = this.mergeOperations(property, toMerge);
                            mergedFilters.add(merged);
                        }
                        catch (Exception e) {
                            for (SpatialOperation so : toMerge) {
                                otherFilters.add(so.op);
                            }
                        }
                    }
                    propertyFilters.remove(0);
                }
            }
            if (mergedFilters.size() == 1 && otherFilters.size() == 0) {
                simplified = (Filter)mergedFilters.get(0);
            } else if (mergedFilters.size() > 0) {
                ArrayList<Object> full = new ArrayList<Object>();
                full.addAll(mergedFilters);
                full.addAll(otherFilters);
                simplified = FF.or(full);
            }
        }
        return simplified;
    }

    private Filter mergeOperations(String propertyName, List<SpatialOperation> ops) {
        PropertyName property = FF.property(propertyName);
        Geometry[] geomArray = new Geometry[ops.size()];
        for (int i = 0; i < geomArray.length; ++i) {
            geomArray[i] = ops.get((int)i).geometry;
        }
        GeometryCollection collection = geomArray[0].getFactory().createGeometryCollection(geomArray);
        Geometry united = collection.union();
        Literal geometry = FF.literal((Object)united);
        Class<?> operation = ops.get((int)0).operation;
        if (BBOX.class.isAssignableFrom(operation) || Intersects.class.isAssignableFrom(operation)) {
            return FF.intersects((Expression)property, (Expression)geometry);
        }
        if (Crosses.class.isAssignableFrom(operation)) {
            return FF.crosses((Expression)property, (Expression)geometry);
        }
        if (Overlaps.class.isAssignableFrom(operation)) {
            return FF.overlaps((Expression)property, (Expression)geometry);
        }
        if (Touches.class.isAssignableFrom(operation)) {
            return FF.touches((Expression)property, (Expression)geometry);
        }
        throw new IllegalArgumentException("Cannot merge operation " + operation.getName());
    }

    static {
        SPATIAL_OPERATIONS.add(BBOX.class);
        SPATIAL_OPERATIONS.add(Intersects.class);
        SPATIAL_OPERATIONS.add(Crosses.class);
        SPATIAL_OPERATIONS.add(Overlaps.class);
    }

    static class SpatialOperation {
        BinarySpatialOperator op;
        Class<?> operation;
        Geometry geometry;

        public SpatialOperation(BinarySpatialOperator op) {
            this.op = op;
            for (Class<?> iface : op.getClass().getInterfaces()) {
                if (!SPATIAL_OPERATIONS.contains(iface)) continue;
                this.operation = iface;
                break;
            }
            if (op.getExpression1() instanceof Literal) {
                this.geometry = (Geometry)op.getExpression1().evaluate(null, Geometry.class);
            } else if (op.getExpression2() instanceof Literal) {
                this.geometry = (Geometry)op.getExpression2().evaluate(null, Geometry.class);
            } else {
                throw new IllegalArgumentException("Cannot find literal geometry in the spatial filter");
            }
        }
    }
}

