/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.data;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.Union;
import org.geotools.arcsde.data.ArcSDEDataStore;
import org.geotools.data.DataSourceException;
import org.geotools.util.logging.Logging;

public class ViewRegisteringFactoryHelper {
    private static final Logger LOGGER = Logging.getLogger((String)ViewRegisteringFactoryHelper.class.getName());

    private ViewRegisteringFactoryHelper() {
    }

    public static void registerSqlViews(ArcSDEDataStore dataStore, Map<String, Serializable> params) throws IOException {
        Map<String, Serializable> cleanedUp = ViewRegisteringFactoryHelper.cleanUpViewDefinitions(params);
        for (Map.Entry<String, Serializable> entry : cleanedUp.entrySet()) {
            String typeName = entry.getKey();
            String sqlQuery = (String)((Object)entry.getValue());
            LOGGER.finer("registering view " + typeName);
            LOGGER.finest("sql query is '" + sqlQuery + "'");
            PlainSelect selectBody = ViewRegisteringFactoryHelper.parseSqlQuery(sqlQuery);
            dataStore.registerView(typeName, selectBody);
        }
    }

    public static Map<String, Serializable> cleanUpViewDefinitions(Map<String, Serializable> params) {
        HashMap<String, Serializable> cleanedUpViews = new HashMap<String, Serializable>();
        for (Map.Entry<String, Serializable> entry : params.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith("sqlView.") || !key.endsWith(".typeName")) continue;
            String typeName = (String)((Object)entry.getValue());
            String viewId = key.substring("sqlView.".length(), key.indexOf(".typeName"));
            String queryKey = "sqlView." + viewId + ".sqlQuery";
            String query = (String)((Object)params.get(queryKey));
            if (query == null) {
                throw new IllegalArgumentException("No SQL query definition provided for type name " + typeName);
            }
            cleanedUpViews.put(typeName, (Serializable)((Object)query));
        }
        return cleanedUpViews;
    }

    public static PlainSelect parseSqlQuery(String selectStatement) throws IOException {
        Statement statement;
        CCJSqlParserManager pm = new CCJSqlParserManager();
        StringReader reader = new StringReader(selectStatement);
        try {
            statement = pm.parse((Reader)reader);
        }
        catch (Exception e) {
            throw new DataSourceException("parsing select statement: " + e.getCause().getMessage(), (Throwable)e);
        }
        if (!(statement instanceof Select)) {
            throw new IllegalArgumentException("expected select or union statement: " + statement);
        }
        SelectBody selectBody = ((Select)statement).getSelectBody();
        if (selectBody instanceof Union) {
            throw new UnsupportedOperationException("ArcSDEDataStore does not supports registering Union queries");
        }
        if (selectBody instanceof PlainSelect) {
            return (PlainSelect)selectBody;
        }
        throw new IllegalStateException(selectBody.getClass().getName());
    }
}

