/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.data;

import com.esri.sde.sdk.client.SeColumnDefinition;
import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeCoordinateReference;
import com.esri.sde.sdk.client.SeDelete;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeInsert;
import com.esri.sde.sdk.client.SeLayer;
import com.esri.sde.sdk.client.SeObjectId;
import com.esri.sde.sdk.client.SeRegistration;
import com.esri.sde.sdk.client.SeRow;
import com.esri.sde.sdk.client.SeShape;
import com.esri.sde.sdk.client.SeStreamOp;
import com.esri.sde.sdk.client.SeTable;
import com.esri.sde.sdk.client.SeUpdate;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jts.operation.valid.TopologyValidationError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.arcsde.ArcSdeException;
import org.geotools.arcsde.data.ArcSDEAdapter;
import org.geotools.arcsde.data.ArcSDEGeometryBuilder;
import org.geotools.arcsde.data.FIDReader;
import org.geotools.arcsde.session.Command;
import org.geotools.arcsde.session.ISession;
import org.geotools.arcsde.versioning.ArcSdeVersionHandler;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureListenerManager;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureImpl;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;
import org.opengis.geometry.BoundingBox;

abstract class ArcSdeFeatureWriter
implements FeatureWriter<SimpleFeatureType, SimpleFeature> {
    protected static final Logger LOGGER = Logging.getLogger((String)ArcSdeFeatureWriter.class.getName());
    private static final String NEW_FID_PREFIX = "@NEW_";
    protected final SimpleFeatureType featureType;
    protected ISession session;
    protected FeatureReader<SimpleFeatureType, SimpleFeature> filteredContent;
    protected final SimpleFeatureBuilder featureBuilder;
    private LinkedHashMap<Integer, String> mutableColumnNames;
    private LinkedHashMap<Integer, String> insertableColumnNames;
    private SeLayer cachedLayer;
    private SeTable cachedTable;
    protected SimpleFeature feature;
    protected final FIDReader fidReader;
    protected final FeatureListenerManager listenerManager;
    private final ArcSdeVersionHandler versionHandler;

    public ArcSdeFeatureWriter(FIDReader fidReader, SimpleFeatureType featureType, FeatureReader<SimpleFeatureType, SimpleFeature> filteredContent, ISession session, FeatureListenerManager listenerManager, ArcSdeVersionHandler versionHandler) throws IOException {
        assert (fidReader != null);
        assert (featureType != null);
        assert (filteredContent != null);
        assert (session != null);
        assert (listenerManager != null);
        assert (versionHandler != null);
        if (!(fidReader instanceof FIDReader.SdeManagedFidReader) && !(fidReader instanceof FIDReader.UserManagedFidReader)) {
            throw new DataSourceException("fid reader is not user nor sde managed: " + fidReader);
        }
        this.fidReader = fidReader;
        this.featureType = featureType;
        this.filteredContent = filteredContent;
        this.session = session;
        this.listenerManager = listenerManager;
        this.featureBuilder = new SimpleFeatureBuilder(featureType);
        this.versionHandler = versionHandler;
    }

    private SeStreamOp createStream(Class<? extends SeStreamOp> streamType) throws IOException {
        SeInsert streamOp;
        if (SeInsert.class == streamType) {
            streamOp = this.session.createSeInsert();
        } else if (SeUpdate.class == streamType) {
            streamOp = this.session.createSeUpdate();
        } else if (SeDelete.class == streamType) {
            streamOp = this.session.createSeDelete();
        } else {
            throw new IllegalArgumentException("Unrecognized stream type: " + streamType);
        }
        this.versionHandler.setUpStream(this.session, (SeStreamOp)streamOp);
        return streamOp;
    }

    public void close() throws IOException {
        if (this.filteredContent != null) {
            this.filteredContent.close();
            this.filteredContent = null;
        }
        if (this.session != null && !this.session.isDisposed()) {
            this.session.dispose();
        }
        this.session = null;
    }

    public final SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public final boolean hasNext() throws IOException {
        boolean hasNext;
        boolean bl = hasNext = this.filteredContent != null && this.filteredContent.hasNext();
        if (!hasNext && this.filteredContent != null) {
            this.filteredContent.close();
            this.filteredContent = null;
        }
        return hasNext;
    }

    public final SimpleFeature next() throws IOException {
        if (this.hasNext()) {
            this.feature = (SimpleFeature)this.filteredContent.next();
        } else {
            String newFid = this.newFid();
            SimpleFeature newFeature = this.featureBuilder.buildFeature(newFid);
            List properties = newFeature.getAttributes();
            this.feature = new MutableFIDFeature(properties, this.featureType, newFid);
        }
        return this.feature;
    }

    public void remove() throws IOException {
        boolean handleTransaction;
        if (this.isNewlyCreated(this.feature)) {
            return;
        }
        boolean bl = handleTransaction = !this.session.isTransactionActive();
        if (handleTransaction) {
            this.session.startTransaction();
        }
        String id = this.feature.getID();
        final long featureId = ArcSDEAdapter.getNumericFid(id);
        final SeObjectId objectID = new SeObjectId(featureId);
        final String qualifiedName = this.featureType.getTypeName();
        final SeDelete seDelete = (SeDelete)this.createStream(SeDelete.class);
        Command<Void> deleteCmd = new Command<Void>(){

            public Void execute(ISession session, SeConnection connection) throws SeException, IOException {
                try {
                    seDelete.byId(qualifiedName, objectID);
                    ArcSdeFeatureWriter.this.versionHandler.editOperationWritten((SeStreamOp)seDelete);
                    if (handleTransaction) {
                        session.commitTransaction();
                    }
                }
                catch (IOException e) {
                    if (handleTransaction) {
                        try {
                            session.rollbackTransaction();
                        }
                        catch (IOException e1) {
                            LOGGER.log(Level.SEVERE, "Unrecoverable error rolling back delete transaction", e);
                        }
                    }
                    throw new DataSourceException("Error deleting feature with id:" + featureId, (Throwable)e);
                }
                finally {
                    if (seDelete != null) {
                        try {
                            seDelete.close();
                        }
                        catch (SeException e) {
                            LOGGER.log(Level.SEVERE, "Unrecoverable error rolling back delete transaction", e);
                        }
                    }
                }
                return null;
            }
        };
        try {
            this.session.issue((Command)deleteCmd);
            this.fireRemoved(this.feature);
        }
        catch (IOException e) {
            this.versionHandler.editOperationFailed((SeStreamOp)seDelete);
            throw e;
        }
    }

    private void fireAdded(SimpleFeature addedFeature) {
        String typeName = this.featureType.getTypeName();
        BoundingBox bounds = addedFeature.getBounds();
        ReferencedEnvelope referencedEnvelope = ReferencedEnvelope.reference((BoundingBox)bounds);
        String fid = addedFeature.getID();
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        Id filter = ff.id(Collections.singleton(ff.featureId(fid)));
        this.doFireFeaturesAdded(typeName, referencedEnvelope, (Filter)filter);
    }

    private void fireChanged(SimpleFeature changedFeature) {
        String typeName = this.featureType.getTypeName();
        BoundingBox bounds = changedFeature.getBounds();
        ReferencedEnvelope referencedEnvelope = ReferencedEnvelope.reference((BoundingBox)bounds);
        String fid = changedFeature.getID();
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        Id filter = ff.id(Collections.singleton(ff.featureId(fid)));
        this.doFireFeaturesChanged(typeName, referencedEnvelope, (Filter)filter);
    }

    private void fireRemoved(SimpleFeature removedFeature) {
        String typeName = this.featureType.getTypeName();
        BoundingBox bounds = removedFeature.getBounds();
        ReferencedEnvelope referencedEnvelope = ReferencedEnvelope.reference((BoundingBox)bounds);
        String fid = removedFeature.getID();
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        Id filter = ff.id(Collections.singleton(ff.featureId(fid)));
        this.doFireFeaturesRemoved(typeName, referencedEnvelope, (Filter)filter);
    }

    protected abstract void doFireFeaturesAdded(String var1, ReferencedEnvelope var2, Filter var3);

    protected abstract void doFireFeaturesChanged(String var1, ReferencedEnvelope var2, Filter var3);

    protected abstract void doFireFeaturesRemoved(String var1, ReferencedEnvelope var2, Filter var3);

    public void write() throws IOException {
        this.feature.validate();
        if (this.isNewlyCreated(this.feature)) {
            Number newId;
            try {
                newId = this.insertSeRow(this.feature);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Error inserting " + this.feature + ": " + e.getMessage(), e);
                throw e;
            }
            MutableFIDFeature mutableFidFeature = (MutableFIDFeature)this.feature;
            String id = this.featureType.getTypeName() + "." + newId.longValue();
            mutableFidFeature.setID(id);
            this.fireAdded((SimpleFeature)mutableFidFeature);
        } else {
            try {
                this.updateRow(this.feature);
                this.fireChanged(this.feature);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Error updating " + this.feature + ": " + e.getMessage(), e);
                throw e;
            }
        }
    }

    private void updateRow(final SimpleFeature modifiedFeature) throws IOException {
        SeLayer layer = this.getLayer();
        final SeCoordinateReference seCoordRef = layer == null ? null : layer.getCoordRef();
        final SeUpdate updateStream = (SeUpdate)this.createStream(SeUpdate.class);
        final LinkedHashMap<Integer, String> mutableColumns = this.getUpdatableColumnNames();
        final String[] rowColumnNames = new ArrayList<String>(mutableColumns.values()).toArray(new String[0]);
        final String typeName = this.featureType.getTypeName();
        String fid = modifiedFeature.getID();
        long numericFid = ArcSDEAdapter.getNumericFid(fid);
        final SeObjectId seObjectId = new SeObjectId(numericFid);
        Command<Void> updateCmd = new Command<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void execute(ISession session, SeConnection connection) throws SeException, IOException {
                try {
                    SeRow row = updateStream.singleRow(seObjectId, typeName, rowColumnNames);
                    ArcSdeFeatureWriter.setRowProperties(modifiedFeature, seCoordRef, mutableColumns, row);
                    updateStream.execute();
                }
                finally {
                    updateStream.close();
                }
                return null;
            }
        };
        try {
            this.session.issue((Command)updateCmd);
            this.versionHandler.editOperationWritten((SeStreamOp)updateStream);
        }
        catch (NoSuchElementException e) {
            this.versionHandler.editOperationFailed((SeStreamOp)updateStream);
            throw e;
        }
        catch (IOException e) {
            this.versionHandler.editOperationFailed((SeStreamOp)updateStream);
            throw e;
        }
    }

    private Number insertSeRow(final SimpleFeature newFeature) throws IOException {
        SeLayer layer = this.getLayer();
        final SeCoordinateReference seCoordRef = layer == null ? null : layer.getCoordRef();
        final LinkedHashMap<Integer, String> insertColumns = this.getInsertableColumnNames();
        Command<Number> insertCmd = new Command<Number>(){

            public Number execute(ISession session, SeConnection connection) throws SeException, IOException {
                SeInsert insertStream = (SeInsert)ArcSdeFeatureWriter.this.createStream(SeInsert.class);
                Number newId = null;
                try {
                    if (ArcSdeFeatureWriter.this.fidReader instanceof FIDReader.UserManagedFidReader) {
                        newId = ArcSdeFeatureWriter.this.getNextAvailableUserManagedId();
                        if (newId == null) {
                            LOGGER.finest("There seems not to be a sequence for the table, not setting a generated id, user ought to be taking care of it");
                            newId = (Number)newFeature.getAttribute(ArcSdeFeatureWriter.this.fidReader.getColumnIndex());
                        } else {
                            int rowIdIndex = ArcSdeFeatureWriter.this.fidReader.getColumnIndex();
                            newFeature.setAttribute(rowIdIndex, (Object)newId);
                        }
                    }
                    String[] rowColumnNames = new ArrayList(insertColumns.values()).toArray(new String[0]);
                    String typeName = ArcSdeFeatureWriter.this.featureType.getTypeName();
                    insertStream.intoTable(typeName, rowColumnNames);
                    insertStream.setWriteMode(true);
                    SeRow row = insertStream.getRowToSet();
                    ArcSdeFeatureWriter.setRowProperties(newFeature, seCoordRef, insertColumns, row);
                    insertStream.execute();
                    if (ArcSdeFeatureWriter.this.fidReader instanceof FIDReader.SdeManagedFidReader) {
                        SeObjectId newRowId = insertStream.lastInsertedRowId();
                        newId = newRowId.longValue();
                    }
                    insertStream.flushBufferedWrites();
                    ArcSdeFeatureWriter.this.versionHandler.editOperationWritten((SeStreamOp)insertStream);
                }
                catch (Exception e) {
                    ArcSdeFeatureWriter.this.versionHandler.editOperationFailed((SeStreamOp)insertStream);
                    if (e instanceof SeException) {
                        throw (SeException)((Object)e);
                    }
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    throw new DataSourceException((Throwable)e);
                }
                insertStream.close();
                return newId;
            }
        };
        Number newId = (Number)this.session.issue((Command)insertCmd);
        return newId;
    }

    private static void setRowProperties(SimpleFeature feature, SeCoordinateReference seCoordRef, Map<Integer, String> mutableColumns, SeRow row) throws SeException, IOException {
        for (Map.Entry<Integer, String> entry : mutableColumns.entrySet()) {
            int seRowIndex = entry.getKey();
            String attName = entry.getValue();
            Object value = feature.getAttribute(attName);
            ArcSdeFeatureWriter.setRowValue(row, seRowIndex, value, seCoordRef, attName);
        }
    }

    private Number getNextAvailableUserManagedId() throws IOException, SeException {
        Number userFidValue;
        SeTable.SeTableIdRange ids;
        SeLayer layer = this.getLayer();
        SeTable table = this.getTable();
        SeTable.SeTableIdRange seTableIdRange = ids = layer == null ? null : table.getIds(1);
        if (ids == null) {
            return null;
        }
        SeObjectId startId = ids.getStartId();
        long id = startId.longValue();
        Long newId = id;
        AttributeDescriptor rowIdAtt = this.featureType.getDescriptor(this.fidReader.getFidColumn());
        Class binding = rowIdAtt.getType().getBinding();
        if (Long.class == binding) {
            userFidValue = newId;
        } else if (Integer.class == binding) {
            userFidValue = newId.intValue();
        } else if (Double.class == binding) {
            userFidValue = new Double(newId.doubleValue());
        } else if (Float.class == binding) {
            userFidValue = new Float(newId.floatValue());
        } else {
            throw new IllegalArgumentException("Can't handle a user managed row id of type " + binding);
        }
        return userFidValue;
    }

    private static void setRowValue(SeRow row, int index, Object value, SeCoordinateReference coordRef, String attName) throws IOException {
        try {
            SeColumnDefinition seColumnDefinition = row.getColumnDef(index);
            int colType = seColumnDefinition.getType();
            Object convertedValue = value;
            if (colType == SeColumnDefinition.TYPE_INT16) {
                convertedValue = Converters.convert((Object)convertedValue, Short.class);
                row.setShort(index, (Short)convertedValue);
            } else if (colType == SeColumnDefinition.TYPE_INT32) {
                convertedValue = Converters.convert((Object)convertedValue, Integer.class);
                row.setInteger(index, (Integer)convertedValue);
            } else if (colType == SeColumnDefinition.TYPE_INT64) {
                convertedValue = Converters.convert((Object)convertedValue, Long.class);
                row.setLong(index, (Long)convertedValue);
            } else if (colType == SeColumnDefinition.TYPE_FLOAT32) {
                convertedValue = Converters.convert((Object)convertedValue, Float.class);
                row.setFloat(index, (Float)convertedValue);
            } else if (colType == SeColumnDefinition.TYPE_FLOAT64) {
                convertedValue = Converters.convert((Object)convertedValue, Double.class);
                row.setDouble(index, (Double)convertedValue);
            } else if (colType == SeColumnDefinition.TYPE_STRING || colType == SeColumnDefinition.TYPE_CLOB || colType == SeColumnDefinition.TYPE_NCLOB) {
                convertedValue = Converters.convert((Object)convertedValue, String.class);
                row.setString(index, (String)convertedValue);
            } else if (colType == SeColumnDefinition.TYPE_NSTRING) {
                convertedValue = Converters.convert((Object)convertedValue, String.class);
                row.setNString(index, (String)convertedValue);
            } else if (colType == SeColumnDefinition.TYPE_DATE) {
                if (convertedValue != null) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime((Date)convertedValue);
                    row.setTime(index, calendar);
                } else {
                    row.setTime(index, null);
                }
            } else if (colType == SeColumnDefinition.TYPE_SHAPE) {
                if (convertedValue != null) {
                    Geometry geom = (Geometry)convertedValue;
                    IsValidOp validator = new IsValidOp(geom);
                    if (!validator.isValid()) {
                        TopologyValidationError validationError = validator.getValidationError();
                        String validationErrorMessage = validationError.getMessage();
                        Coordinate coordinate = validationError.getCoordinate();
                        String errorMessage = "Topology validation error at or near point " + coordinate + ": " + validationErrorMessage;
                        throw new DataSourceException("Invalid geometry passed for " + attName + "\n Geomerty: " + geom + "\n" + errorMessage);
                    }
                    ArcSDEGeometryBuilder geometryBuilder = ArcSDEGeometryBuilder.builderFor(geom.getClass());
                    SeShape shape = geometryBuilder.constructShape(geom, coordRef);
                    row.setShape(index, shape);
                } else {
                    row.setShape(index, null);
                }
            }
        }
        catch (SeException e) {
            throw new ArcSdeException(e);
        }
    }

    private LinkedHashMap<Integer, String> getUpdatableColumnNames() throws NoSuchElementException, IOException {
        if (this.mutableColumnNames == null) {
            final String typeName = this.featureType.getTypeName();
            SeColumnDefinition[] columnDefinitions = this.session.describe(typeName);
            String shapeAttributeName = this.featureType.getGeometryDescriptor() == null ? null : (String)this.session.issue((Command)new Command<String>(){

                public String execute(ISession session, SeConnection connection) throws SeException, IOException {
                    SeLayer layer = session.getLayer(typeName);
                    return layer.getShapeAttributeName(SeLayer.SE_SHAPE_ATTRIBUTE_FID);
                }
            });
            LinkedHashMap<Integer, String> columnList = new LinkedHashMap<Integer, String>();
            int usedIndex = 0;
            for (int actualIndex = 0; actualIndex < columnDefinitions.length; ++actualIndex) {
                short rowIdType;
                int sdeType;
                SeColumnDefinition columnDefinition = columnDefinitions[actualIndex];
                String columnName = columnDefinition.getName();
                if (columnName.equals(shapeAttributeName) || SeColumnDefinition.TYPE_SHAPE != (sdeType = columnDefinition.getType()) && null == ArcSDEAdapter.getJavaBinding(new Integer(sdeType)) || SeRegistration.SE_REGISTRATION_ROW_ID_COLUMN_TYPE_SDE == (rowIdType = columnDefinition.getRowIdType())) continue;
                columnList.put(usedIndex, columnName);
                ++usedIndex;
            }
            this.mutableColumnNames = columnList;
        }
        return this.mutableColumnNames;
    }

    private LinkedHashMap<Integer, String> getInsertableColumnNames() throws NoSuchElementException, IOException {
        if (this.insertableColumnNames == null) {
            String typeName = this.featureType.getTypeName();
            SeColumnDefinition[] columnDefinitions = this.session.describe(typeName);
            LinkedHashMap<Integer, String> columnList = new LinkedHashMap<Integer, String>();
            int usedIndex = 0;
            for (int actualIndex = 0; actualIndex < columnDefinitions.length; ++actualIndex) {
                int sdeType;
                SeColumnDefinition columnDefinition = columnDefinitions[actualIndex];
                String columnName = columnDefinition.getName();
                if (this.fidReader instanceof FIDReader.SdeManagedFidReader && columnName.equals(this.fidReader.getFidColumn()) || SeColumnDefinition.TYPE_SHAPE != (sdeType = columnDefinition.getType()) && null == ArcSDEAdapter.getJavaBinding(sdeType)) continue;
                columnList.put(usedIndex, columnName);
                ++usedIndex;
            }
            this.insertableColumnNames = columnList;
        }
        return this.insertableColumnNames;
    }

    private SeTable getTable() throws IOException {
        if (this.cachedTable == null) {
            String typeName = this.featureType.getTypeName();
            this.cachedTable = this.session.getTable(typeName);
        }
        return this.cachedTable;
    }

    private SeLayer getLayer() throws IOException {
        if (this.cachedLayer == null && this.featureType.getGeometryDescriptor() != null) {
            SeLayer layer;
            String typeName = this.featureType.getTypeName();
            this.cachedLayer = layer = this.session.getLayer(typeName);
        }
        return this.cachedLayer;
    }

    private String newFid() {
        return NEW_FID_PREFIX + UUID.randomUUID();
    }

    private final boolean isNewlyCreated(SimpleFeature aFeature) {
        String id = aFeature.getID();
        return id.startsWith(NEW_FID_PREFIX);
    }

    public ISession getSession() {
        return this.session;
    }

    private static class MutableFIDFeature
    extends SimpleFeatureImpl {
        public MutableFIDFeature(List<Object> values, SimpleFeatureType ft, String fid) throws IllegalAttributeException {
            super(values, ft, (FeatureId)MutableFIDFeature.createDefaultFID(fid));
        }

        private static FeatureIdImpl createDefaultFID(String id) {
            if (id == null) {
                id = SimpleFeatureBuilder.createDefaultFeatureId();
            }
            return new FeatureIdImpl(id);
        }

        public void setID(String fid) {
            ((FeatureIdImpl)this.id).setID(fid);
        }
    }
}

