/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.filter;

import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeExtent;
import com.esri.sde.sdk.client.SeFilter;
import com.esri.sde.sdk.client.SeLayer;
import com.esri.sde.sdk.client.SeShape;
import com.esri.sde.sdk.client.SeShapeFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.arcsde.data.ArcSDEGeometryBuilder;
import org.geotools.arcsde.filter.GeometryEncoderException;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.visitor.DefaultFilterVisitor;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.DistanceBufferOperator;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

public class GeometryEncoderSDE
extends DefaultFilterVisitor
implements FilterVisitor {
    private static Logger log = Logging.getLogger((String)"org.geotools.filter");
    private static FilterCapabilities capabilities = new FilterCapabilities();
    private List<SeShapeFilter> sdeSpatialFilters;
    private SeLayer sdeLayer;
    private SimpleFeatureType featureType;

    public GeometryEncoderSDE() {
    }

    public GeometryEncoderSDE(SeLayer layer, SimpleFeatureType featureType) {
        this.sdeLayer = layer;
        this.featureType = featureType;
    }

    public static FilterCapabilities getCapabilities() {
        return capabilities;
    }

    public SeFilter[] getSpatialFilters() {
        SeFilter[] filters = new SeFilter[this.sdeSpatialFilters.size()];
        return this.sdeSpatialFilters.toArray(filters);
    }

    private String getLayerName() throws SeException {
        if (this.sdeLayer == null) {
            throw new IllegalStateException("SDE layer has not been set");
        }
        return this.sdeLayer.getQualifiedName();
    }

    public void encode(Filter filter) throws GeometryEncoderException {
        this.sdeSpatialFilters = new ArrayList<SeShapeFilter>();
        if (Filter.INCLUDE.equals(filter)) {
            return;
        }
        if (!capabilities.fullySupports(filter)) {
            throw new GeometryEncoderException("Filter type " + filter.getClass() + " not supported");
        }
        filter.accept((FilterVisitor)this, null);
    }

    private void addSpatialFilter(BinarySpatialOperator filter, int sdeMethod, boolean truth, Object extraData) {
        String rawPropName;
        Literal geomLiteralExpr;
        PropertyName propertyExpr;
        boolean appliedTruth = truth;
        if (extraData != null && extraData instanceof Boolean) {
            boolean andValue = (Boolean)extraData;
            appliedTruth = andValue ? truth && andValue : !truth;
        }
        Expression left = filter.getExpression1();
        Expression right = filter.getExpression2();
        if (left instanceof PropertyName && right instanceof Literal) {
            propertyExpr = (PropertyName)left;
            geomLiteralExpr = (Literal)right;
        } else if (right instanceof PropertyName && left instanceof Literal) {
            propertyExpr = (PropertyName)right;
            geomLiteralExpr = (Literal)left;
        } else {
            String err = "SDE currently supports one geometry and one attribute expr.  You gave: " + left + ", " + right;
            throw new IllegalArgumentException(err);
        }
        String spatialCol = this.featureType.getGeometryDescriptor().getLocalName();
        String localPropName = rawPropName = propertyExpr.getPropertyName();
        if (rawPropName.indexOf(":") != -1) {
            localPropName = rawPropName.substring(rawPropName.indexOf(":") + 1);
        }
        if ("".equals(localPropName)) {
            log.fine("Empty property name found on filter, using default geometry property");
            localPropName = spatialCol;
        }
        if (!rawPropName.equalsIgnoreCase(spatialCol) && !localPropName.equalsIgnoreCase(spatialCol)) {
            throw new IllegalArgumentException("When querying against a spatial column, your property name must match the spatial column name.You used '" + propertyExpr.getPropertyName() + "', but the DB's spatial column name is '" + spatialCol + "'");
        }
        Geometry geom = (Geometry)geomLiteralExpr.getValue();
        ArcSDEGeometryBuilder gb = ArcSDEGeometryBuilder.builderFor(Polygon.class);
        SeExtent seExtent = this.sdeLayer.getExtent();
        if (seExtent.getMaxX() == seExtent.getMinX()) {
            seExtent = new SeExtent(seExtent.getMinX() - 100.0, seExtent.getMinY(), seExtent.getMaxX() + 100.0, seExtent.getMaxY());
        }
        if (seExtent.getMaxY() == seExtent.getMinY()) {
            seExtent = new SeExtent(seExtent.getMinX(), seExtent.getMinY() - 100.0, seExtent.getMaxX(), seExtent.getMaxY() + 100.0);
        }
        try {
            SeShape filterShape;
            if (seExtent.isEmpty()) {
                filterShape = new SeShape(this.sdeLayer.getCoordRef());
            } else {
                SeShape extent = new SeShape(this.sdeLayer.getCoordRef());
                extent.generateRectangle(seExtent);
                if (geom.getClass() == GeometryCollection.class) {
                    filterShape = new SeShape(this.sdeLayer.getCoordRef());
                } else {
                    gb = ArcSDEGeometryBuilder.builderFor(geom.getClass());
                    filterShape = gb.constructShape(geom, this.sdeLayer.getCoordRef());
                }
            }
            SeShapeFilter shapeFilter = new SeShapeFilter(this.getLayerName(), this.sdeLayer.getSpatialColumn(), filterShape, sdeMethod, appliedTruth);
            this.sdeSpatialFilters.add(shapeFilter);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (SeException se) {
            throw new RuntimeException(se);
        }
    }

    public Object visit(BBOX filter, Object extraData) {
        this.addSpatialFilter((BinarySpatialOperator)filter, SeFilter.METHOD_ENVP, true, extraData);
        return extraData;
    }

    public Object visit(Contains filter, Object extraData) {
        if (filter.getExpression1() instanceof PropertyName && filter.getExpression2() instanceof Literal) {
            this.addSpatialFilter((BinarySpatialOperator)filter, SeFilter.METHOD_PC, true, extraData);
        } else {
            this.addSpatialFilter((BinarySpatialOperator)filter, SeFilter.METHOD_SC, true, extraData);
        }
        return extraData;
    }

    public Object visit(Crosses filter, Object extraData) {
        this.addSpatialFilter((BinarySpatialOperator)filter, SeFilter.METHOD_LCROSS_OR_CP, true, extraData);
        return extraData;
    }

    public Object visit(Disjoint filter, Object extraData) {
        this.addSpatialFilter((BinarySpatialOperator)filter, SeFilter.METHOD_II_OR_ET, false, extraData);
        return extraData;
    }

    public Object visit(Touches filter, Object extraData) {
        this.addSpatialFilter((BinarySpatialOperator)filter, SeFilter.METHOD_II_NO_ET, false, extraData);
        return extraData;
    }

    public Object visit(DWithin filter, Object extraData) {
        return this.visitDistanceBufferOperator((DistanceBufferOperator)filter, true, extraData);
    }

    public Object visit(Beyond filter, Object extraData) {
        return this.visitDistanceBufferOperator((DistanceBufferOperator)filter, false, extraData);
    }

    private Object visitDistanceBufferOperator(DistanceBufferOperator filter, boolean truth, Object extraData) {
        Literal literal;
        PropertyName property;
        Expression expression1 = filter.getExpression1();
        Expression expression2 = filter.getExpression2();
        if (expression1 instanceof PropertyName && expression2 instanceof Literal) {
            property = (PropertyName)expression1;
            literal = (Literal)expression2;
        } else if (expression2 instanceof PropertyName && expression1 instanceof Literal) {
            property = (PropertyName)expression2;
            literal = (Literal)expression1;
        } else {
            throw new IllegalArgumentException("expected propertyname/literal, got " + expression1 + "/" + expression2);
        }
        Geometry geom = (Geometry)literal.evaluate(null, Geometry.class);
        double distance = filter.getDistance();
        Geometry buffer = geom.buffer(distance);
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        Intersects intersects = ff.intersects((Expression)property, (Expression)ff.literal((Object)buffer));
        this.addSpatialFilter((BinarySpatialOperator)intersects, SeFilter.METHOD_II_OR_ET, truth, extraData);
        return extraData;
    }

    public Object visit(Equals filter, Object extraData) {
        this.addSpatialFilter((BinarySpatialOperator)filter, SeFilter.METHOD_IDENTICAL, true, extraData);
        return extraData;
    }

    public Object visit(Intersects filter, Object extraData) {
        this.addSpatialFilter((BinarySpatialOperator)filter, SeFilter.METHOD_II_OR_ET, true, extraData);
        return extraData;
    }

    public Object visit(Overlaps filter, Object extraData) {
        this.addSpatialFilter((BinarySpatialOperator)filter, SeFilter.METHOD_II, true, extraData);
        return extraData;
    }

    public Object visit(Within filter, Object extraData) {
        if (filter.getExpression1() instanceof PropertyName && filter.getExpression2() instanceof Literal) {
            this.addSpatialFilter((BinarySpatialOperator)filter, SeFilter.METHOD_SC, true, extraData);
        } else {
            this.addSpatialFilter((BinarySpatialOperator)filter, SeFilter.METHOD_PC, true, extraData);
        }
        return extraData;
    }

    public Object visit(And filter, Object extraData) {
        List children = filter.getChildren();
        for (Filter child : children) {
            child.accept((FilterVisitor)this, extraData);
        }
        return extraData;
    }

    public Object visit(Or filter, Object extraData) {
        List children = filter.getChildren();
        for (Filter child : children) {
            child.accept((FilterVisitor)this, extraData);
        }
        return extraData;
    }

    public Object visit(Not filter, Object extraData) {
        Boolean truth = Boolean.FALSE;
        Filter negated = filter.getFilter();
        return negated.accept((FilterVisitor)this, (Object)truth);
    }

    static {
        capabilities.addType(And.class);
        capabilities.addType(Not.class);
        capabilities.addType(Id.class);
        capabilities.addType(BBOX.class);
        capabilities.addType(Contains.class);
        capabilities.addType(Crosses.class);
        capabilities.addType(Disjoint.class);
        capabilities.addType(Equals.class);
        capabilities.addType(Intersects.class);
        capabilities.addType(Overlaps.class);
        capabilities.addType(Within.class);
        capabilities.addType(DWithin.class);
        capabilities.addType(Beyond.class);
        capabilities.addType(Touches.class);
    }
}

